/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.WaitableResult;

public class ProxyLookup
extends Lookup {
    private Lookup[] lookups;
    private HashMap results;
    static /* synthetic */ Class class$org$openide$util$LookupListener;

    public ProxyLookup(Lookup[] lookups) {
        this.lookups = lookups;
    }

    protected ProxyLookup() {
        this(new Lookup[0]);
    }

    public String toString() {
        return "ProxyLookup(class=" + this.getClass() + ")->" + Arrays.asList(this.lookups);
    }

    protected final Lookup[] getLookups() {
        return this.lookups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setLookups(Lookup[] lookups) {
        Reference[] arr;
        ProxyLookup proxyLookup = this;
        synchronized (proxyLookup) {
            HashSet<Lookup> current = new HashSet<Lookup>(Arrays.asList(this.lookups));
            HashSet<Lookup> newL = new HashSet<Lookup>(Arrays.asList(lookups));
            Lookup[] old = this.lookups;
            this.lookups = lookups;
            if (this.results == null || this.results.isEmpty()) {
                return;
            }
            arr = this.results.values().toArray(new Reference[0]);
            HashSet<Lookup> removed = new HashSet<Lookup>(current);
            removed.removeAll(newL);
            newL.removeAll(current);
            if (removed.isEmpty() && newL.isEmpty()) {
                return;
            }
            for (int i = 0; i < arr.length; ++i) {
                R r = (R)arr[i].get();
                if (r == null) continue;
                r.lookupChange(newL, removed, old, lookups);
            }
        }
        for (int i = 0; i < arr.length; ++i) {
            R r = (R)arr[i].get();
            if (r == null) continue;
            r.resultChanged(null);
        }
    }

    protected void beforeLookup(Lookup.Template template) {
    }

    public final Object lookup(Class clazz) {
        this.beforeLookup(new Lookup.Template(clazz));
        Lookup[] lookups = this.lookups;
        for (int i = 0; i < lookups.length; ++i) {
            Object o = lookups[i].lookup(clazz);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public final Lookup.Item lookupItem(Lookup.Template template) {
        this.beforeLookup(template);
        Lookup[] lookups = this.lookups;
        for (int i = 0; i < lookups.length; ++i) {
            Lookup.Item o = lookups[i].lookupItem(template);
            if (o == null) continue;
            return o;
        }
        return null;
    }

    public final synchronized Lookup.Result lookup(Lookup.Template template) {
        R r;
        if (this.results != null) {
            Reference ref = (Reference)this.results.get(template);
            R r2 = r = ref == null ? null : (R)ref.get();
            if (r != null) {
                return r;
            }
        } else {
            this.results = new HashMap();
        }
        r = new R(template);
        this.results.put(template, new SoftReference<R>(r));
        return r;
    }

    private final synchronized void unregisterTemplate(Lookup.Template template) {
        if (this.results == null) {
            return;
        }
        Reference ref = (Reference)this.results.remove(template);
        if (ref != null && ref.get() != null) {
            this.results.put(template, ref);
        }
    }

    private final class R
    extends WaitableResult
    implements LookupListener {
        private EventListenerList listeners;
        private Lookup.Template template;
        private Lookup.Result[] results;
        private Collection[] cache;

        public R(Lookup.Template t) {
            this.template = t;
        }

        protected void finalize() {
            ProxyLookup.this.unregisterTemplate(this.template);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup.Result[] initResults() {
            R r = this;
            synchronized (r) {
                if (this.results != null) {
                    return this.results;
                }
            }
            Lookup.Result[] arr = new Lookup.Result[ProxyLookup.this.lookups.length];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = ProxyLookup.this.lookups[i].lookup(this.template);
            }
            R r2 = this;
            synchronized (r2) {
                if (this.results != null) {
                    return this.results;
                }
                this.cache = new Collection[3];
                for (int i = 0; i < arr.length; ++i) {
                    arr[i].addLookupListener(this);
                }
                this.results = arr;
                return arr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void lookupChange(Set added, Set removed, Lookup[] old, Lookup[] current) {
            R r = this;
            synchronized (r) {
                if (this.results == null) {
                    return;
                }
                HashMap<Lookup, Lookup.Result> map = new HashMap<Lookup, Lookup.Result>(old.length * 2);
                for (int i = 0; i < old.length; ++i) {
                    if (removed.contains(old[i])) {
                        this.results[i].removeLookupListener(this);
                        continue;
                    }
                    map.put(old[i], this.results[i]);
                }
                Lookup.Result[] arr = new Lookup.Result[current.length];
                for (int i = 0; i < current.length; ++i) {
                    if (added.contains(current[i])) {
                        arr[i] = current[i].lookup(this.template);
                        arr[i].addLookupListener(this);
                        continue;
                    }
                    arr[i] = (Lookup.Result)map.get(current[i]);
                    if (arr[i] != null) continue;
                    throw new IllegalStateException();
                }
                this.results = arr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            if (this.listeners == null) {
                R r = this;
                synchronized (r) {
                    if (this.listeners == null) {
                        this.listeners = new EventListenerList();
                    }
                }
            }
            this.listeners.add(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = ProxyLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
        }

        public void removeLookupListener(LookupListener l) {
            if (this.listeners != null) {
                this.listeners.remove(class$org$openide$util$LookupListener == null ? (class$org$openide$util$LookupListener = ProxyLookup.class$("org.openide.util.LookupListener")) : class$org$openide$util$LookupListener, l);
            }
        }

        public Collection allInstances() {
            return this.computeResult(0);
        }

        public Set allClasses() {
            return (Set)this.computeResult(1);
        }

        public Collection allItems() {
            return this.computeResult(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Collection computeResult(int indexToCache) {
            Lookup.Result[] arr = this.myBeforeLookup();
            R r = this;
            synchronized (r) {
                if (this.cache != null && this.cache[indexToCache] != null) {
                    return this.cache[indexToCache];
                }
            }
            AbstractCollection ll = indexToCache == 1 ? new HashSet() : new ArrayList(arr.length * 2);
            block11: for (int i = 0; i < arr.length; ++i) {
                switch (indexToCache) {
                    case 0: {
                        ll.addAll(arr[i].allInstances());
                        continue block11;
                    }
                    case 1: {
                        ll.addAll(arr[i].allClasses());
                        continue block11;
                    }
                    case 2: {
                        ll.addAll(arr[i].allItems());
                    }
                }
            }
            R r2 = this;
            synchronized (r2) {
                if (arr == this.results && this.cache != null) {
                    this.cache[indexToCache] = ll;
                }
            }
            return ll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            R r = this;
            synchronized (r) {
                this.cache = null;
                if (this.listeners == null) {
                    return;
                }
            }
            Object[] arr = this.listeners.getListenerList();
            if (arr.length == 0) {
                return;
            }
            ev = new LookupEvent(this);
            AbstractLookup.notifyListeners(arr, ev);
        }

        private Lookup.Result[] myBeforeLookup() {
            ProxyLookup.this.beforeLookup(this.template);
            Lookup.Result[] arr = this.initResults();
            for (int i = 0; i < arr.length; ++i) {
                if (!(arr[i] instanceof WaitableResult)) continue;
                WaitableResult w = (WaitableResult)arr[i];
                w.beforeLookup(this.template);
            }
            return arr;
        }

        protected void beforeLookup(Lookup.Template t) {
            if (t.getType() == this.template.getType()) {
                this.myBeforeLookup();
            }
        }
    }
}

