/*
 * Decompiled with CFR 0.152.
 */
package org.openide.xml;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openide.ErrorManager;
import org.openide.xml.XMLUtilImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class XMLUtil {
    private static boolean useFastSAXParserFactory = true;
    private static final char[] DEC2HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static Class fastParserFactoryClass = null;

    private XMLUtil() {
    }

    public static XMLReader createXMLReader() throws SAXException {
        return XMLUtil.createXMLReader(false, false);
    }

    public static XMLReader createXMLReader(boolean validate) throws SAXException {
        return XMLUtil.createXMLReader(validate, false);
    }

    public static XMLReader createXMLReader(boolean validate, boolean namespaceAware) throws SAXException {
        SAXParserFactory factory;
        if (!validate && useFastSAXParserFactory) {
            try {
                factory = XMLUtil.createFastSAXParserFactory();
            }
            catch (ParserConfigurationException ex) {
                factory = SAXParserFactory.newInstance();
            }
            catch (SAXException ex) {
                factory = SAXParserFactory.newInstance();
            }
        } else {
            useFastSAXParserFactory = false;
            factory = SAXParserFactory.newInstance();
        }
        factory.setValidating(validate);
        factory.setNamespaceAware(namespaceAware);
        try {
            return factory.newSAXParser().getXMLReader();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
    }

    public static Document createDocument(String rootQName, String namespaceURI, String doctypePublicID, String doctypeSystemID) throws DOMException {
        DOMImplementation impl = XMLUtil.getDOMImplementation();
        if (doctypePublicID != null && doctypeSystemID == null) {
            throw new IllegalArgumentException("System ID cannot be null if public ID specified. ");
        }
        DocumentType dtd = null;
        if (doctypeSystemID != null) {
            dtd = impl.createDocumentType(rootQName, doctypePublicID, doctypeSystemID);
        }
        return impl.createDocument(namespaceURI, rootQName, dtd);
    }

    private static DOMImplementation getDOMImplementation() throws DOMException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            return factory.newDocumentBuilder().getDOMImplementation();
        }
        catch (ParserConfigurationException ex) {
            throw new DOMException(9, "Cannot create parser satisfying configuration parameters");
        }
        catch (RuntimeException e) {
            throw (DOMException)new DOMException(9, e.toString()).initCause(e);
        }
    }

    public static Document parse(InputSource input, boolean validate, boolean namespaceAware, ErrorHandler errorHandler, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        factory.setNamespaceAware(namespaceAware);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException("Cannot create parser satisfying configuration parameters", ex);
        }
        if (errorHandler != null) {
            builder.setErrorHandler(errorHandler);
        }
        if (entityResolver != null) {
            builder.setEntityResolver(entityResolver);
        }
        return builder.parse(input);
    }

    public static void write(Document doc, OutputStream out, String enc) throws IOException {
        XMLUtilImpl.write(doc, out, enc);
    }

    public static String toAttributeValue(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkAttributeCharacters(val)) {
            return val;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('\'' == ch) {
                buf.append("&apos;");
                continue;
            }
            if ('\"' == ch) {
                buf.append("&quot;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toElementContent(String val) throws CharConversionException {
        if (val == null) {
            throw new CharConversionException("null");
        }
        if (XMLUtil.checkContentCharacters(val)) {
            return val;
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if ('<' == ch) {
                buf.append("&lt;");
                continue;
            }
            if ('&' == ch) {
                buf.append("&amp;");
                continue;
            }
            if ('>' == ch && i > 1 && val.charAt(i - 2) == ']' && val.charAt(i - 1) == ']') {
                buf.append("&gt;");
                continue;
            }
            buf.append(ch);
        }
        return buf.toString();
    }

    public static String toHex(byte[] val, int start, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            byte b = val[start + i];
            buf.append(DEC2HEX[(b & 0xF0) >> 4]);
            buf.append(DEC2HEX[b & 0xF]);
        }
        return buf.toString();
    }

    public static byte[] fromHex(char[] hex, int start, int len) throws IOException {
        if (hex == null) {
            throw new IOException("null");
        }
        int i = hex.length;
        if (i % 2 != 0) {
            throw new IOException("odd length");
        }
        byte[] magic = new byte[i / 2];
        while (i > 0) {
            String g = new String(hex, i - 2, 2);
            try {
                magic[i / 2 - 1] = (byte)Integer.parseInt(g, 16);
            }
            catch (NumberFormatException ex) {
                throw new IOException(ex.getLocalizedMessage());
            }
            i -= 2;
        }
        return magic;
    }

    private static boolean checkAttributeCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block4: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block4;
                }
                case '\"': 
                case '&': 
                case '\'': 
                case '<': {
                    escape = true;
                    continue block4;
                }
                default: {
                    if (ch >= ' ') continue block4;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static boolean checkContentCharacters(String chars) throws CharConversionException {
        boolean escape = false;
        block5: for (int i = 0; i < chars.length(); ++i) {
            char ch = chars.charAt(i);
            if (ch > ']') continue;
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block5;
                }
                case '>': {
                    if (escape) continue block5;
                    escape = i > 0 && chars.charAt(i - 1) == ']';
                    continue block5;
                }
                case '&': 
                case '<': {
                    escape = true;
                    continue block5;
                }
                default: {
                    if (ch >= ' ') continue block5;
                    throw new CharConversionException("Invalid XML character &#" + ch + ";.");
                }
            }
        }
        return !escape;
    }

    private static SAXParserFactory createFastSAXParserFactory() throws ParserConfigurationException, SAXException {
        block6: {
            if (fastParserFactoryClass == null) {
                try {
                    fastParserFactoryClass = Class.forName("org.apache.crimson.jaxp.SAXParserFactoryImpl");
                }
                catch (Exception ex) {
                    useFastSAXParserFactory = false;
                    if (!System.getProperty("java.version").startsWith("1.4")) break block6;
                    ErrorManager.getDefault().notify(1, ex);
                }
            }
        }
        if (fastParserFactoryClass != null) {
            try {
                SAXParserFactory factory = (SAXParserFactory)fastParserFactoryClass.newInstance();
                return factory;
            }
            catch (Exception ex) {
                useFastSAXParserFactory = false;
                throw new ParserConfigurationException(ex.getMessage());
            }
        }
        return SAXParserFactory.newInstance();
    }
}

