/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.IndirectPropertyChangeSupport;
import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.beans.PropertyUnboundException;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class BeanAdapter
extends Model {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final boolean observeChanges;
    private final Map propertyAdapters;
    private IndirectPropertyChangeSupport indirectChangeSupport;
    private Object storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;

    public BeanAdapter(Object bean) {
        this(bean, false);
    }

    public BeanAdapter(Object bean, boolean observeChanges) {
        this(new ValueHolder(bean, true), observeChanges);
    }

    public BeanAdapter(ValueModel beanChannel) {
        this(beanChannel, false);
    }

    public BeanAdapter(ValueModel beanChannel, boolean observeChanges) {
        this.beanChannel = beanChannel != null ? beanChannel : new ValueHolder(null, true);
        this.observeChanges = observeChanges;
        this.propertyAdapters = new HashMap();
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        Object initialBean = this.getBean();
        if (initialBean != null) {
            if (observeChanges && !BeanUtils.supportsBoundProperties(initialBean.getClass())) {
                throw new PropertyUnboundException("The bean must provide support for listening on property changes as described in section 7.4.5 of the Java Bean Specification.");
            }
            this.observe(initialBean);
        }
        this.storedOldBean = initialBean;
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object newBean) {
        this.beanChannel.setValue(newBean);
        this.resetChanged();
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue(String propertyName) {
        Object bean = this.getBean();
        if (bean == null) {
            return null;
        }
        return this.getValue0(bean, propertyName);
    }

    public void setValue(String propertyName, Object newValue) {
        Object bean = this.getBean();
        if (bean == null) {
            return;
        }
        this.setValue0(bean, propertyName, newValue);
    }

    public AbstractValueModel getValueModel(String propertyName) {
        return this.getValueModel(propertyName, null, null);
    }

    public AbstractValueModel getValueModel(String propertyName, String getterName, String setterName) {
        SimplePropertyAdapter adaptingModel = this.getPropertyAdapter(propertyName);
        if (adaptingModel == null) {
            adaptingModel = new SimplePropertyAdapter(propertyName, getterName, setterName);
            this.propertyAdapters.put(propertyName, adaptingModel);
        } else if (!this.equals(getterName, adaptingModel.getterName) || !this.equals(setterName, adaptingModel.setterName)) {
            throw new IllegalArgumentException("You must not invoke this method twice with different getter and/or setter names.");
        }
        return adaptingModel;
    }

    SimplePropertyAdapter getPropertyAdapter(String propertyName) {
        return (SimplePropertyAdapter)this.propertyAdapters.get(propertyName);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTYNAME_CHANGED, oldValue, newValue);
    }

    public synchronized void addBeanPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(listener);
    }

    public synchronized void removeBeanPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.indirectChangeSupport == null) {
            this.indirectChangeSupport = new IndirectPropertyChangeSupport(this.beanChannel);
        }
        this.indirectChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removeBeanPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (listener == null || this.indirectChangeSupport == null) {
            return;
        }
        this.indirectChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners() {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners();
    }

    public synchronized PropertyChangeListener[] getBeanPropertyChangeListeners(String propertyName) {
        if (this.indirectChangeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.indirectChangeSupport.getPropertyChangeListeners(propertyName);
    }

    public void release() {
        this.retractInterestFor(this.getBean());
    }

    private void setBean0(Object oldBean, Object newBean) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, oldBean, newBean, true);
        this.retractInterestFor(oldBean);
        this.forwardAllAdaptedValuesChanged(oldBean, newBean);
        this.resetChanged();
        this.observe(newBean);
        this.firePropertyChange(PROPERTYNAME_BEAN, oldBean, newBean, true);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, oldBean, newBean, true);
    }

    private void forwardAllAdaptedValuesChanged(Object oldBean, Object newBean) {
        Iterator iter = new LinkedList(this.propertyAdapters.values()).iterator();
        while (iter.hasNext()) {
            SimplePropertyAdapter adapter = (SimplePropertyAdapter)iter.next();
            adapter.setBean0(oldBean, newBean);
        }
    }

    private void forwardAllAdaptedValuesChanged() {
        Object currentBean = this.getBean();
        Iterator iter = new LinkedList(this.propertyAdapters.values()).iterator();
        while (iter.hasNext()) {
            SimplePropertyAdapter adapter = (SimplePropertyAdapter)iter.next();
            adapter.fireChange(currentBean);
        }
    }

    private void observe(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(bean, this.propertyChangeHandler);
    }

    private void retractInterestFor(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(bean, this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Object getValue0(Object bean, String propertyName) {
        return this.getValue0(bean, this.getPropertyDescriptor(bean, propertyName));
    }

    private Object getValue0(Object bean, PropertyDescriptor propertyDescriptor) {
        return bean == null ? null : BeanUtils.getValue(bean, propertyDescriptor);
    }

    private void setValue0(Object bean, String propertyName, Object newValue) {
        this.setValue0(bean, this.getPropertyDescriptor(bean, propertyName), newValue);
    }

    private void setValue0(Object bean, PropertyDescriptor propertyDescriptor, Object newValue) {
        if (bean != null) {
            BeanUtils.setValue(bean, propertyDescriptor, newValue);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(Object bean, String propertyName) {
        return BeanUtils.getPropertyDescriptor(bean, propertyName, null, null);
    }

    public final class SimplePropertyAdapter
    extends AbstractValueModel {
        private final String propertyName;
        private final String getterName;
        private final String setterName;
        private PropertyDescriptor cachedPropertyDescriptor;
        private Class cachedBeanClass;

        private SimplePropertyAdapter(String propertyName, String getterName, String setterName) {
            this.propertyName = propertyName;
            this.getterName = getterName;
            this.setterName = setterName;
            Object bean = BeanAdapter.this.getBean();
            if (bean != null) {
                this.getPropertyDescriptor(bean);
            }
        }

        public Object getValue() {
            Object bean = BeanAdapter.this.getBean();
            return bean == null ? null : BeanAdapter.this.getValue0(bean, this.getPropertyDescriptor(bean));
        }

        public void setValue(Object newValue) {
            Object bean = BeanAdapter.this.getBean();
            if (bean != null) {
                BeanAdapter.this.setValue0(bean, this.getPropertyDescriptor(bean), newValue);
            }
        }

        private PropertyDescriptor getPropertyDescriptor(Object bean) {
            if (this.cachedPropertyDescriptor == null || bean.getClass() != this.cachedBeanClass) {
                this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(bean, this.propertyName, this.getterName, this.setterName);
                this.cachedBeanClass = bean.getClass();
            }
            return this.cachedPropertyDescriptor;
        }

        void fireChange(Object currentBean) {
            Object newValue;
            if (currentBean == null) {
                newValue = null;
            } else {
                PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(currentBean);
                boolean isWriteOnly = null == propertyDescriptor.getReadMethod();
                newValue = isWriteOnly ? null : BeanAdapter.this.getValue0(currentBean, propertyDescriptor);
            }
            this.fireValueChange(null, newValue);
        }

        void setBean0(Object oldBean, Object newBean) {
            Object newValue;
            boolean isWriteOnly;
            PropertyDescriptor propertyDescriptor;
            Object oldValue;
            if (oldBean == null) {
                oldValue = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(oldBean);
                isWriteOnly = null == propertyDescriptor.getReadMethod();
                Object object = oldValue = isWriteOnly ? null : BeanAdapter.this.getValue0(oldBean, propertyDescriptor);
            }
            if (newBean == null) {
                newValue = null;
            } else {
                propertyDescriptor = this.getPropertyDescriptor(newBean);
                isWriteOnly = null == propertyDescriptor.getReadMethod();
                Object object = newValue = isWriteOnly ? null : BeanAdapter.this.getValue0(newBean, propertyDescriptor);
            }
            if (oldValue != null || newValue != null) {
                this.fireValueChange(oldValue, newValue, true);
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            BeanAdapter.this.setChanged(true);
            String propertyName = evt.getPropertyName();
            if (propertyName == null) {
                BeanAdapter.this.forwardAllAdaptedValuesChanged();
            } else {
                SimplePropertyAdapter adapter = BeanAdapter.this.getPropertyAdapter(propertyName);
                if (adapter != null) {
                    adapter.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
                }
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newBean = evt.getNewValue() != null ? evt.getNewValue() : BeanAdapter.this.getBean();
            BeanAdapter.this.setBean0(BeanAdapter.this.storedOldBean, newBean);
            BeanAdapter.this.storedOldBean = newBean;
        }
    }
}

