/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

public final class PropertyAdapter
extends AbstractValueModel {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final String propertyName;
    private final String getterName;
    private final String setterName;
    private final boolean observeChanges;
    private Object storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;
    private PropertyDescriptor cachedPropertyDescriptor;
    private Class cachedBeanClass;

    public PropertyAdapter(Object bean, String propertyName) {
        this(bean, propertyName, false);
    }

    public PropertyAdapter(Object bean, String propertyName, boolean observeChanges) {
        this(bean, propertyName, null, null, observeChanges);
    }

    public PropertyAdapter(Object bean, String propertyName, String getterName, String setterName) {
        this(bean, propertyName, getterName, setterName, false);
    }

    public PropertyAdapter(Object bean, String propertyName, String getterName, String setterName, boolean observeChanges) {
        this(new ValueHolder(bean, true), propertyName, getterName, setterName, observeChanges);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName) {
        this(beanChannel, propertyName, false);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, boolean observeChanges) {
        this(beanChannel, propertyName, null, null, observeChanges);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, String getterName, String setterName) {
        this(beanChannel, propertyName, getterName, setterName, false);
    }

    public PropertyAdapter(ValueModel beanChannel, String propertyName, String getterName, String setterName, boolean observeChanges) {
        this.beanChannel = beanChannel != null ? beanChannel : new ValueHolder(null, true);
        this.propertyName = propertyName;
        this.getterName = getterName;
        this.setterName = setterName;
        this.observeChanges = observeChanges;
        if (propertyName == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("The property name must not be empty.");
        }
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        Object initialBean = this.getBean();
        if (initialBean != null) {
            this.getPropertyDescriptor(initialBean);
            this.observe(initialBean);
        }
        this.storedOldBean = initialBean;
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object newBean) {
        this.beanChannel.setValue(newBean);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue() {
        Object bean = this.getBean();
        if (bean == null) {
            return null;
        }
        return this.getValue0(bean);
    }

    public void setValue(Object newValue) {
        this.setValue0(this.getBean(), newValue);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean newValue) {
        boolean oldValue = this.isChanged();
        this.changed = newValue;
        this.firePropertyChange(PROPERTYNAME_CHANGED, oldValue, newValue);
    }

    public void release() {
        this.retractInterestFor(this.getBean());
    }

    private void setBean0(Object oldBean, Object newBean) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, oldBean, newBean, true);
        this.retractInterestFor(oldBean);
        this.forwardAdaptedValueChanged(oldBean, newBean);
        this.resetChanged();
        this.observe(newBean);
        this.firePropertyChange(PROPERTYNAME_BEAN, oldBean, newBean, true);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, oldBean, newBean, true);
    }

    private void forwardAdaptedValueChanged(Object oldBean, Object newBean) {
        Object newValue;
        Object oldValue = oldBean == null || this.isWriteOnlyProperty(oldBean) ? null : this.getValue0(oldBean);
        Object object = newValue = newBean == null || this.isWriteOnlyProperty(newBean) ? null : this.getValue0(newBean);
        if (oldValue != null || newValue != null) {
            this.fireValueChange(oldValue, newValue, true);
        }
    }

    private void forwardAdaptedValueChanged(Object newBean) {
        Object newValue = newBean == null || this.isWriteOnlyProperty(newBean) ? null : this.getValue0(newBean);
        this.fireValueChange(null, newValue);
    }

    private void observe(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(bean, this.propertyChangeHandler);
    }

    private void retractInterestFor(Object bean) {
        if (!this.observeChanges || bean == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(bean, this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Object getValue0(Object bean) {
        return bean == null ? null : BeanUtils.getValue(bean, this.getPropertyDescriptor(bean));
    }

    private void setValue0(Object bean, Object newValue) {
        if (bean != null) {
            BeanUtils.setValue(bean, this.getPropertyDescriptor(bean), newValue);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(Object bean) {
        if (this.cachedPropertyDescriptor == null || bean.getClass() != this.cachedBeanClass) {
            this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(bean, this.getPropertyName(), this.getterName, this.setterName);
            this.cachedBeanClass = bean.getClass();
        }
        return this.cachedPropertyDescriptor;
    }

    private boolean isWriteOnlyProperty(Object bean) {
        return null == this.getPropertyDescriptor(bean).getReadMethod();
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            PropertyAdapter.this.setChanged(true);
            if (evt.getPropertyName() == null) {
                PropertyAdapter.this.forwardAdaptedValueChanged(PropertyAdapter.this.getBean());
            } else if (evt.getPropertyName().equals(PropertyAdapter.this.getPropertyName())) {
                PropertyAdapter.this.fireValueChange(evt.getOldValue(), evt.getNewValue(), true);
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newBean = evt.getNewValue() != null ? evt.getNewValue() : PropertyAdapter.this.getBean();
            PropertyAdapter.this.setBean0(PropertyAdapter.this.storedOldBean, newBean);
            PropertyAdapter.this.storedOldBean = newBean;
        }
    }
}

