/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractConverter;
import com.jgoodies.binding.value.ValueModel;
import java.text.Format;
import java.text.ParseException;

public final class ConverterFactory {
    private ConverterFactory() {
    }

    public static ValueModel createBooleanNegator(ValueModel booleanSubject) {
        return new BooleanNegator(booleanSubject);
    }

    public static ValueModel createBooleanToStringConverter(ValueModel booleanSubject, String trueText, String falseText) {
        return ConverterFactory.createBooleanToStringConverter(booleanSubject, trueText, falseText, "");
    }

    public static ValueModel createBooleanToStringConverter(ValueModel booleanSubject, String trueText, String falseText, String nullText) {
        return new BooleanToStringConverter(booleanSubject, trueText, falseText, nullText);
    }

    public static ValueModel createDoubleConverter(ValueModel doubleSubject, double multiplier) {
        return new DoubleConverter(doubleSubject, multiplier);
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel doubleSubject) {
        return ConverterFactory.createDoubleToIntegerConverter(doubleSubject, 1);
    }

    public static ValueModel createDoubleToIntegerConverter(ValueModel doubleSubject, int multiplier) {
        return new DoubleToIntegerConverter(doubleSubject, multiplier);
    }

    public static ValueModel createFloatConverter(ValueModel floatSubject, float multiplier) {
        return new FloatConverter(floatSubject, multiplier);
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel floatSubject) {
        return ConverterFactory.createFloatToIntegerConverter(floatSubject, 1);
    }

    public static ValueModel createFloatToIntegerConverter(ValueModel floatSubject, int multiplier) {
        return new FloatToIntegerConverter(floatSubject, multiplier);
    }

    public static ValueModel createIntegerConverter(ValueModel integerSubject, float multiplier) {
        return new IntegerConverter(integerSubject, multiplier);
    }

    public static ValueModel createLongConverter(ValueModel longSubject, float multiplier) {
        return new LongConverter(longSubject, multiplier);
    }

    public static ValueModel createLongToIntegerConverter(ValueModel longSubject) {
        return ConverterFactory.createLongToIntegerConverter(longSubject, 1);
    }

    public static ValueModel createLongToIntegerConverter(ValueModel longSubject, int multiplier) {
        return new LongToIntegerConverter(longSubject, multiplier);
    }

    public static ValueModel createStringConverter(ValueModel subject, Format format) {
        return new StringConverter(subject, format);
    }

    public static final class StringConverter
    extends AbstractConverter {
        private final Format format;

        private StringConverter(ValueModel subject, Format format) {
            super(subject);
            if (format == null) {
                throw new NullPointerException("The format must not be null.");
            }
            this.format = format;
        }

        public Object convertFromSubject(Object subjectValue) {
            return this.format.format(subjectValue);
        }

        public void setValue(Object value) {
            try {
                this.subject.setValue(this.format.parseObject((String)value));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }

    public static final class LongToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        private LongToIntegerConverter(ValueModel longSubject, int multiplier) {
            super(longSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            int intValue = ((Long)subjectValue).intValue();
            if (this.multiplier != 1) {
                intValue *= this.multiplier;
            }
            return new Integer(intValue);
        }

        public void setValue(Object newValue) {
            long longValue = ((Integer)newValue).longValue();
            if (this.multiplier != 1) {
                longValue /= (long)this.multiplier;
            }
            this.subject.setValue(new Long(longValue));
        }
    }

    public static final class IntegerConverter
    extends AbstractConverter {
        private final double multiplier;

        private IntegerConverter(ValueModel IntegerSubject, double multiplier) {
            super(IntegerSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            double doubleValue = ((Integer)subjectValue).doubleValue();
            return new Integer((int)(doubleValue * this.multiplier));
        }

        public void setValue(Object newValue) {
            double doubleValue = ((Integer)newValue).doubleValue();
            this.subject.setValue(new Integer((int)(doubleValue / this.multiplier)));
        }
    }

    public static final class LongConverter
    extends AbstractConverter {
        private final double multiplier;

        private LongConverter(ValueModel longSubject, double multiplier) {
            super(longSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            double doubleValue = ((Long)subjectValue).doubleValue();
            return new Long((long)(doubleValue * this.multiplier));
        }

        public void setValue(Object newValue) {
            double doubleValue = ((Long)newValue).doubleValue();
            this.subject.setValue(new Long((long)(doubleValue / this.multiplier)));
        }
    }

    public static final class FloatToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        private FloatToIntegerConverter(ValueModel floatSubject, int multiplier) {
            super(floatSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            float floatValue = ((Float)subjectValue).floatValue();
            if (this.multiplier != 1) {
                floatValue *= (float)this.multiplier;
            }
            return new Integer(Math.round(floatValue));
        }

        public void setValue(Object newValue) {
            float floatValue = ((Integer)newValue).floatValue();
            if (this.multiplier != 1) {
                floatValue /= (float)this.multiplier;
            }
            this.subject.setValue(new Float(floatValue));
        }
    }

    public static final class FloatConverter
    extends AbstractConverter {
        private final float multiplier;

        private FloatConverter(ValueModel doubleSubject, float multiplier) {
            super(doubleSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            float floatValue = ((Float)subjectValue).floatValue();
            return new Float(floatValue * this.multiplier);
        }

        public void setValue(Object newValue) {
            float floatValue = ((Float)newValue).floatValue();
            this.subject.setValue(new Float(floatValue / this.multiplier));
        }
    }

    public static final class DoubleToIntegerConverter
    extends AbstractConverter {
        private final int multiplier;

        private DoubleToIntegerConverter(ValueModel doubleSubject, int multiplier) {
            super(doubleSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            double doubleValue = (Double)subjectValue;
            if (this.multiplier != 1) {
                doubleValue *= (double)this.multiplier;
            }
            return new Integer((int)Math.round(doubleValue));
        }

        public void setValue(Object newValue) {
            double doubleValue = ((Integer)newValue).doubleValue();
            if (this.multiplier != 1) {
                doubleValue /= (double)this.multiplier;
            }
            this.subject.setValue(new Double(doubleValue));
        }
    }

    public static final class DoubleConverter
    extends AbstractConverter {
        private final double multiplier;

        private DoubleConverter(ValueModel doubleSubject, double multiplier) {
            super(doubleSubject);
            this.multiplier = multiplier;
        }

        public Object convertFromSubject(Object subjectValue) {
            double doubleValue = (Double)subjectValue;
            return new Double(doubleValue * this.multiplier);
        }

        public void setValue(Object newValue) {
            double doubleValue = (Double)newValue;
            this.subject.setValue(new Double(doubleValue / this.multiplier));
        }
    }

    public static final class BooleanToStringConverter
    extends AbstractConverter {
        private final String trueText;
        private final String falseText;
        private final String nullText;

        private BooleanToStringConverter(ValueModel booleanSubject, String trueText, String falseText, String nullText) {
            super(booleanSubject);
            if (trueText == null || falseText == null || nullText == null) {
                throw new NullPointerException("The trueText, falseText and nullText must not be null.");
            }
            if (trueText.equals(falseText)) {
                throw new IllegalArgumentException("The trueText and falseText must be different.");
            }
            this.trueText = trueText;
            this.falseText = falseText;
            this.nullText = nullText;
        }

        public Object convertFromSubject(Object subjectValue) {
            if (Boolean.TRUE.equals(subjectValue)) {
                return this.trueText;
            }
            if (Boolean.FALSE.equals(subjectValue)) {
                return this.falseText;
            }
            if (subjectValue == null) {
                return this.nullText;
            }
            throw new ClassCastException("The subject value must be of type Boolean.");
        }

        public void setValue(Object newValue) {
            if (!(newValue instanceof String)) {
                throw new ClassCastException("The new value must be a string.");
            }
            String newString = (String)newValue;
            if (this.trueText.equalsIgnoreCase(newString)) {
                this.subject.setValue(Boolean.TRUE);
            } else if (this.falseText.equalsIgnoreCase(newString)) {
                this.subject.setValue(Boolean.FALSE);
            } else if (this.nullText.equalsIgnoreCase(newString)) {
                this.subject.setValue(null);
            } else {
                throw new IllegalArgumentException("The new value must be one of: " + this.trueText + '/' + this.falseText + '/' + this.nullText);
            }
        }
    }

    public static final class BooleanNegator
    extends AbstractConverter {
        private BooleanNegator(ValueModel booleanSubject) {
            super(booleanSubject);
        }

        public Object convertFromSubject(Object subjectValue) {
            return this.negate(subjectValue);
        }

        public void setValue(Object newValue) {
            this.subject.setValue(this.negate(newValue));
        }

        private Boolean negate(Object value) {
            if (value == null) {
                return null;
            }
            if (Boolean.TRUE.equals(value)) {
                return Boolean.FALSE;
            }
            if (Boolean.FALSE.equals(value)) {
                return Boolean.TRUE;
            }
            throw new ClassCastException("The value must be a Boolean.");
        }
    }
}

