/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.util.JGraphUtilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JGraphGXLCodec {
    static transient Hashtable encodeHash;
    static transient Hashtable decodeHash;
    private static boolean validateDTD;

    public static Hashtable getLastEncodingHashtable() {
        return encodeHash;
    }

    public static Hashtable getLastDecodingHashtable() {
        return decodeHash;
    }

    public static String encode(JGraph jGraph) {
        Object[] objectArray = jGraph.getDescendants(jGraph.getRoots());
        return JGraphGXLCodec.encode(jGraph, objectArray);
    }

    public static String encode(JGraph jGraph, Object[] objectArray) {
        int n = 0;
        encodeHash = new Hashtable();
        String string = "<?xml version=\"1.0\"?>\n<!DOCTYPE gxl SYSTEM \"http://www.gupro.de/GXL/gxl-1.1.dtd\">\n<gxl xmlns:xlink=\"http://www.w3.org/1999/xlink\">\n<graph id=\"jGraph\">\n";
        for (int i = 0; i < objectArray.length; ++i) {
            if (!JGraphUtilities.isVertex(jGraph, objectArray[i])) continue;
            encodeHash.put(objectArray[i], "node" + n);
            ++n;
        }
        Iterator iterator = encodeHash.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            string = string + JGraphGXLCodec.encodeVertex(jGraph, (String)encodeHash.get(k), k);
        }
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (!jGraph.getModel().isEdge(objectArray[i])) continue;
            string = string + JGraphGXLCodec.encodeEdge(jGraph, new Integer(n2++), objectArray[i]);
        }
        string = string + "\n</graph>\n</gxl>";
        return string;
    }

    private static String createTab(int n) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "\t";
        }
        return string;
    }

    protected static String encodeValue(String string, String string2, int n) {
        return JGraphGXLCodec.createTab(n) + "<" + string + ">" + string2 + "</" + string + ">\n";
    }

    private static String encodeValue(boolean bl, int n) {
        return JGraphGXLCodec.createTab(n) + "<bool>" + bl + "</bool>\n";
    }

    protected static String encodeValue(int n, int n2) {
        return JGraphGXLCodec.createTab(n2) + "<int>" + n + "</int>\n";
    }

    protected static String encodeValue(String string, int n) {
        return JGraphGXLCodec.createTab(n) + "<string>" + string + "</string>\n";
    }

    protected static String encodeAttribute(String string, String string2, int n) {
        String string3 = JGraphGXLCodec.createTab(n);
        return string3 + "<attr name=\"" + string2 + "\">\n" + string + string3 + "</attr>\n";
    }

    protected static String encodeString(String string, String string2, int n) {
        if (string != null) {
            return JGraphGXLCodec.encodeAttribute(JGraphGXLCodec.encodeValue(string, n + 1), string2, n);
        }
        return "";
    }

    protected static String encodeInteger(int n, String string, int n2) {
        return JGraphGXLCodec.encodeAttribute(JGraphGXLCodec.encodeValue(n, n2 + 1), string, n2);
    }

    protected static String encodeBoolean(boolean bl, String string, int n) {
        return JGraphGXLCodec.encodeAttribute(JGraphGXLCodec.encodeValue(bl, n + 1), string, n);
    }

    protected static String encodeColor(Color color, String string, int n) {
        if (color != null) {
            String string2 = JGraphGXLCodec.createTab(n + 1);
            int n2 = n + 2;
            String string3 = string2 + "<tup>\n" + JGraphGXLCodec.encodeValue(color.getRed(), n2) + JGraphGXLCodec.encodeValue(color.getGreen(), n2) + JGraphGXLCodec.encodeValue(color.getBlue(), n2) + string2 + "</tup>\n";
            return JGraphGXLCodec.encodeAttribute(string3, string, n);
        }
        return "";
    }

    protected static String encodeFont(Font font, String string, int n) {
        if (font != null) {
            String string2 = JGraphGXLCodec.createTab(n + 1);
            int n2 = n + 2;
            String string3 = string2 + "<tup>\n" + JGraphGXLCodec.encodeValue(font.getFontName(), n2) + JGraphGXLCodec.encodeValue(font.getStyle(), n2) + JGraphGXLCodec.encodeValue(font.getSize(), n2) + string2 + "</tup>\n";
            return JGraphGXLCodec.encodeAttribute(string3, string, n);
        }
        return "";
    }

    protected static String encodeRectangle(Rectangle2D rectangle2D, String string, int n) {
        if (rectangle2D != null) {
            String string2 = JGraphGXLCodec.createTab(n + 1);
            int n2 = n + 2;
            String string3 = string2 + "<tup>\n" + JGraphGXLCodec.encodeValue((int)rectangle2D.getCenterX(), n2) + JGraphGXLCodec.encodeValue((int)rectangle2D.getCenterY(), n2) + JGraphGXLCodec.encodeValue((int)rectangle2D.getWidth(), n2) + JGraphGXLCodec.encodeValue((int)rectangle2D.getHeight(), n2) + string2 + "</tup>\n";
            return JGraphGXLCodec.encodeAttribute(string3, string, n);
        }
        return "";
    }

    protected static String encodeBean(Object object, String string, int n) {
        String string2 = "";
        if (object != null) {
            try {
                int n2 = n + 1;
                String string3 = JGraphGXLCodec.createTab(n2);
                int n3 = n + 2;
                BeanInfo beanInfo = null;
                PropertyDescriptor[] propertyDescriptorArray = null;
                PropertyDescriptor propertyDescriptor = null;
                beanInfo = Introspector.getBeanInfo(object.getClass());
                propertyDescriptorArray = beanInfo.getPropertyDescriptors();
                string2 = string2 + JGraphGXLCodec.encodeString(object.getClass().getName(), "ClassName", n2);
                for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                    propertyDescriptor = propertyDescriptorArray[i];
                    string2 = string2 + JGraphGXLCodec.encodeString(propertyDescriptor.getReadMethod().invoke(object, null).toString(), propertyDescriptor.getDisplayName(), n2);
                }
                string2 = JGraphGXLCodec.encodeAttribute(string2, string, n);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string2;
    }

    protected static String encodeVertex(JGraph jGraph, String string, Object object) {
        int n = 2;
        String string2 = jGraph.convertValueToString(object);
        AttributeMap attributeMap = ((GraphCell)object).getAttributes();
        String string3 = "\n\t<node id=\"" + string + "\">\n" + JGraphGXLCodec.encodeString(string2, "Label", n) + JGraphGXLCodec.encodeRectangle(GraphConstants.getBounds((Map)attributeMap), "Bounds", n) + JGraphGXLCodec.encodeColor(GraphConstants.getBorderColor((Map)attributeMap), "BorderColor", n) + JGraphGXLCodec.encodeColor(GraphConstants.getForeground((Map)attributeMap), "BorderColor", n) + JGraphGXLCodec.encodeColor(GraphConstants.getBackground((Map)attributeMap), "BorderColor", n) + JGraphGXLCodec.encodeFont(GraphConstants.getFont((Map)attributeMap), "Font", n) + JGraphGXLCodec.encodeColor(GraphConstants.getLineColor((Map)attributeMap), "BorderColor", n) + "\t</node>";
        return string3;
    }

    protected static String encodeEdge(JGraph jGraph, Object object, Object object2) {
        Object v;
        String string;
        GraphModel graphModel = jGraph.getModel();
        String string2 = "";
        if (graphModel.getSource(object2) != null && (string = encodeHash.get(graphModel.getParent(graphModel.getSource(object2)))) != null) {
            string2 = string.toString();
        }
        string = "";
        if (graphModel.getTarget(object2) != null && (v = encodeHash.get(graphModel.getParent(graphModel.getTarget(object2)))) != null) {
            string = v.toString();
        }
        if (string2 != null && string != null) {
            int n = 2;
            AttributeMap attributeMap = ((GraphCell)object2).getAttributes();
            String string3 = jGraph.convertValueToString(object2);
            return "\n\t<edge id=\"edge" + object.toString() + "\"" + " from=\"" + string2 + "\"" + " to=\"" + string + "\">\n" + JGraphGXLCodec.encodeString(string3, "Label", 2) + JGraphGXLCodec.encodeInteger(GraphConstants.getLineEnd((Map)attributeMap), "LineEnd", n) + JGraphGXLCodec.encodeColor(GraphConstants.getForeground((Map)attributeMap), "Foreground", n) + JGraphGXLCodec.encodeFont(GraphConstants.getFont((Map)attributeMap), "Font", n) + JGraphGXLCodec.encodeInteger(GraphConstants.getLineStyle((Map)attributeMap), "LineStyle", n) + JGraphGXLCodec.encodeColor(GraphConstants.getLineColor((Map)attributeMap), "LineColor", n) + "\n\t</edge>";
        }
        return "";
    }

    protected static void decodeCell(Node node, Map map) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Serializable serializable;
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("attr")) continue;
            String string = ((Element)node2).getAttribute("name");
            LinkedList linkedList = new LinkedList();
            JGraphGXLCodec.readGXLAttributeValues(node2, linkedList);
            if (string == null || linkedList.size() <= 0) continue;
            if (string.equals("Bounds")) {
                if (linkedList.size() != 4) continue;
                serializable = new Point(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)));
                Dimension dimension = new Dimension(Integer.parseInt((String)linkedList.get(2)), Integer.parseInt((String)linkedList.get(3)));
                Rectangle rectangle = new Rectangle((Point)serializable, dimension);
                GraphConstants.setBounds((Map)map, (Rectangle2D)rectangle);
                continue;
            }
            if (string.equals("Font")) {
                if (linkedList.size() != 3) continue;
                serializable = new Font((String)linkedList.get(0), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                GraphConstants.setFont((Map)map, (Font)serializable);
                continue;
            }
            if (string.equals("Foreground")) {
                try {
                    serializable = new Color(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                    GraphConstants.setForeground((Map)map, (Color)serializable);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("BorderColor")) {
                try {
                    serializable = new Color(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                    GraphConstants.setBorderColor((Map)map, (Color)serializable);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("LineColor")) {
                try {
                    serializable = new Color(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                    GraphConstants.setLineColor((Map)map, (Color)serializable);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("Background")) {
                try {
                    serializable = new Color(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                    GraphConstants.setBackground((Map)map, (Color)serializable);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("LineColor")) {
                try {
                    serializable = new Color(Integer.parseInt((String)linkedList.get(0)), Integer.parseInt((String)linkedList.get(1)), Integer.parseInt((String)linkedList.get(2)));
                    GraphConstants.setLineColor((Map)map, (Color)serializable);
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("LineEnd")) {
                try {
                    GraphConstants.setLineEnd((Map)map, (int)Integer.parseInt((String)linkedList.get(0)));
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equals("LineStyle")) {
                try {
                    GraphConstants.setLineStyle((Map)map, (int)Integer.parseInt((String)linkedList.get(0)));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!string.equals("AutoSize")) continue;
            GraphConstants.setAutoSize((Map)map, (boolean)"true".equals((String)linkedList.get(0)));
        }
    }

    protected static void readGXLAttributeValues(Node node, LinkedList linkedList) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            String string = node2.getNodeName();
            if (string.equals("tup") || string.equals("set") || string.equals("enum") || string.equals("seq") || string.equals("bag")) {
                JGraphGXLCodec.readGXLAttributeValues(node2, linkedList);
                continue;
            }
            if (!string.equals("int") && !string.equals("bool") && !string.equals("float") && !string.equals("string") && !string.equals("locator")) continue;
            try {
                Node node3 = node2.getFirstChild();
                if (null == node3) {
                    if (!string.equals("string")) continue;
                    linkedList.add(new String(""));
                    continue;
                }
                linkedList.add(node2.getFirstChild().getNodeValue());
                continue;
            }
            catch (DOMException dOMException) {
                // empty catch block
            }
        }
    }

    protected static void decodeEdge(Node node, Map map) {
        JGraphGXLCodec.decodeCell(node, map);
    }

    private static void manageDTDLookup(DocumentBuilder documentBuilder) {
        documentBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                InputSource inputSource = null;
                try {
                    URL uRL = new URL(string2);
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.connect();
                    int n = httpURLConnection.getResponseCode();
                    httpURLConnection.disconnect();
                    inputSource = n != 404 ? new InputSource(string2) : new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                catch (IOException iOException) {
                    inputSource = new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes()));
                }
                return inputSource;
            }
        });
    }

    public static void decode(InputStream inputStream, JGraph jGraph) throws Exception {
        String string = null;
        GraphModel graphModel = jGraph.getModel();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (!validateDTD) {
            JGraphGXLCodec.manageDTDLookup(documentBuilder);
        }
        Document document = documentBuilder.parse(inputStream);
        ArrayList<String> arrayList = new ArrayList<String>();
        ConnectionSet connectionSet = new ConnectionSet();
        decodeHash = new Hashtable();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() == 0) {
            return;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("graph")) continue;
            Element element2 = (Element)node;
            NodeList nodeList2 = element2.getChildNodes();
            boolean bl = "directed".equals(element2.getAttribute("edgemode")) || "defaultdirected".equals(element2.getAttribute("edgemode"));
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Object object;
                String string2;
                Node node2;
                Object object2;
                Node node3 = nodeList2.item(j);
                String string3 = JGraphGXLCodec.getLabel(node3);
                if (node3.getAttributes() == null || node3.getNodeName() == null) continue;
                String string4 = node3.getNodeName().toString().toLowerCase();
                if (string4.equals("node")) {
                    object2 = null;
                    node2 = node3.getAttributes().getNamedItem("id");
                    if (node2 != null) {
                        object2 = node2.getNodeValue();
                    }
                    if (object2 == null || decodeHash.keySet().contains(object2)) continue;
                    string2 = new DefaultGraphCell((Object)string3);
                    string2.add((MutableTreeNode)new DefaultPort());
                    decodeHash.put(object2, string2);
                    object = new Hashtable();
                    JGraphGXLCodec.decodeCell(node3, (Map)object);
                    hashtable.put(string2, object);
                    arrayList.add(string2);
                    continue;
                }
                if (string4.equals("edge")) {
                    DefaultGraphCell defaultGraphCell;
                    object2 = (Element)node3;
                    node2 = node3.getAttributes().getNamedItem("from");
                    string2 = null;
                    if (node2 != null) {
                        string2 = node2.getNodeValue();
                    }
                    node2 = node3.getAttributes().getNamedItem("to");
                    object = null;
                    if (node2 != null) {
                        object = node2.getNodeValue();
                    }
                    DefaultEdge defaultEdge = new DefaultEdge((Object)string3);
                    if (string2 != null && (defaultGraphCell = (DefaultGraphCell)decodeHash.get(string2)) != null) {
                        connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), true);
                    }
                    if (object != null && (defaultGraphCell = (DefaultGraphCell)decodeHash.get(object)) != null) {
                        connectionSet.connect((Object)defaultEdge, (Object)defaultGraphCell.getChildAt(0), false);
                    }
                    boolean bl2 = ("true".equals(object2.getAttribute("isdirected")) || bl) && !"false".equals(object2.getAttribute("isdirected"));
                    Hashtable hashtable2 = new Hashtable();
                    if (bl2) {
                        GraphConstants.setLineEnd(hashtable2, (int)1);
                        GraphConstants.setEndFill(hashtable2, (boolean)true);
                    }
                    JGraphGXLCodec.decodeEdge((Node)object2, hashtable2);
                    hashtable.put((String)defaultEdge, hashtable2);
                    arrayList.add((String)defaultEdge);
                    continue;
                }
                if (!string4.equals("view")) continue;
                string = ((Element)node3).getAttribute("defaultlayout");
            }
        }
        graphModel.insert(arrayList.toArray(), hashtable, connectionSet, null, null);
    }

    protected static Map createDefaultAttributes(Map map) {
        GraphConstants.setBorderColor((Map)map, (Color)Color.black);
        return map;
    }

    protected static String getLabel(Node node) {
        String string = null;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!node2.getNodeName().equals("attr") || !node2.getAttributes().getNamedItem("name").getNodeValue().equals("Label")) continue;
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3;
                if (!nodeList2.item(j).getNodeName().equals("string") || (node3 = nodeList2.item(j).getFirstChild()) == null) continue;
                string = node3.getNodeValue();
            }
        }
        return string != null ? string : new String("");
    }

    public static void setValidateDTD(boolean bl) {
        validateDTD = bl;
    }

    public static boolean getValidateDTD() {
        return validateDTD;
    }

    static {
        validateDTD = false;
    }
}

