/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputAdapter;
import org.jgraph.JGraph;
import org.jgraph.cellview.JGraphHeavyweightView;
import org.jgraph.graph.CellView;

public class JGraphHeavyweightRedirector
extends MouseInputAdapter {
    protected boolean heavyweightOnly = false;
    protected boolean selectedOnly = true;

    public JGraphHeavyweightRedirector() {
        this(false, true);
    }

    public JGraphHeavyweightRedirector(boolean bl, boolean bl2) {
        this.heavyweightOnly = bl;
        this.selectedOnly = bl2;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.redispatchMouseEvent(mouseEvent);
    }

    private void redispatchMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JGraph) {
            Point point;
            final JGraph jGraph = (JGraph)mouseEvent.getSource();
            Object object = jGraph.getFirstCellForLocation((double)((int)(point = mouseEvent.getPoint()).getX()), (double)((int)point.getY()));
            if (object != null && (!this.selectedOnly || jGraph.isCellSelected(object))) {
                CellView cellView = jGraph.getGraphLayoutCache().getMapping(object, false);
                if (!this.heavyweightOnly || cellView instanceof JGraphHeavyweightView) {
                    Component component = cellView.getRendererComponent(jGraph, false, false, false);
                    final Rectangle2D rectangle2D = cellView.getBounds();
                    point.x = (int)((double)point.x - rectangle2D.getX());
                    point.y = (int)((double)point.y - rectangle2D.getY());
                    boolean bl = false;
                    if (component instanceof Container) {
                        boolean bl2 = bl = ((Container)component).getComponentCount() > 1;
                    }
                    if (bl) {
                        component.setBounds(new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
                        if (component instanceof JComponent) {
                            ((JComponent)component).setPreferredSize(new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
                        }
                        if ((component = SwingUtilities.getDeepestComponentAt(component, point.x, point.y)) != null) {
                            point.x = (int)((double)point.x - component.getLocation().getX());
                            point.y = (int)((double)point.y - component.getLocation().getY());
                        }
                    }
                    if (component != null) {
                        final Component component2 = component;
                        final MouseEvent mouseEvent2 = new MouseEvent(component2, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), (int)point.getX(), (int)point.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                component2.dispatchEvent(mouseEvent2);
                                jGraph.repaint(new Rectangle((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
                            }
                        });
                    }
                }
            }
            mouseEvent.consume();
        }
    }
}

