/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.trident.api.swing;

import java.awt.Component;
import java.awt.Rectangle;
import org.pushingpixels.trident.api.Timeline;
import org.pushingpixels.trident.api.swing.SwingRepaintCallback;

public class SwingRepaintTimeline
extends Timeline {
    private SwingRepaintCallback repaintCallback;

    public static Builder repaintBuilder(Component component) {
        return new Builder(component);
    }

    private SwingRepaintTimeline(Component mainTimelineComp, Rectangle toRepaint) {
        super(mainTimelineComp);
        this.repaintCallback = new SwingRepaintCallback(mainTimelineComp, toRepaint);
        this.addCallback(this.repaintCallback);
    }

    public void forceRepaintOnNextPulse() {
        this.repaintCallback.forceRepaintOnNextPulse();
    }

    @Override
    public void play() {
        throw new UnsupportedOperationException("Only infinite looping is supported");
    }

    @Override
    public void playReverse() {
        throw new UnsupportedOperationException("Only infinite looping is supported");
    }

    @Override
    public void replay() {
        throw new UnsupportedOperationException("Only infinite looping is supported");
    }

    @Override
    public void replayReverse() {
        throw new UnsupportedOperationException("Only infinite looping is supported");
    }

    @Override
    public void playLoop(int loopCount, Timeline.RepeatBehavior repeatBehavior) {
        if (loopCount >= 0) {
            throw new UnsupportedOperationException("Only infinite looping is supported");
        }
        super.playLoop(loopCount, repeatBehavior);
    }

    public static class Builder
    extends Timeline.BaseBuilder<SwingRepaintTimeline, Builder, Component> {
        private Rectangle toRepaint;
        private boolean autoRepaintMode = true;

        public Builder(Component mainObject) {
            super(mainObject);
        }

        public Builder setRepaintRectangle(Rectangle toRepaint) {
            this.toRepaint = toRepaint;
            return this;
        }

        public Builder setAutoRepaintMode(boolean autoRepaintMode) {
            this.autoRepaintMode = autoRepaintMode;
            return this;
        }

        @Override
        public SwingRepaintTimeline build() {
            SwingRepaintTimeline timeline = new SwingRepaintTimeline((Component)this.mainObject, this.toRepaint);
            this.configureBaseTimeline(timeline);
            timeline.repaintCallback.setAutoRepaintMode(this.autoRepaintMode);
            return timeline;
        }
    }
}

