/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.discovery.PortInfo;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphXMLConstants;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.CustomerNode;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.EthernetInterface;
import com.sysuptime.common.model.NetworkInterface;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.RrpGroup;
import com.sysuptime.common.model.RrpInterface;
import com.sysuptime.common.model.SubnetNode;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.CompactProperties;
import com.sysuptime.common.util.ComparablePair;
import com.sysuptime.common.util.trap.AesCipher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import util.Base64;

public class GraphXMLWriter
implements GraphXMLConstants {
    private static Logger _logger = Logger.getLogger((String)GraphXMLWriter.class.getName());

    private GraphXMLWriter() {
    }

    public static List createBeansDocumetnsList(TopologyData topologyData) {
        ArrayList<Document> arrayList;
        block2: {
            ArrayList<Document> arrayList2 = new ArrayList<Document>();
            Iterator iterator = topologyData.customersIterator();
            int[] nArray = NetworkGraphModel.b();
            while (iterator.hasNext()) {
                CustomerNode customerNode = (CustomerNode)iterator.next();
                arrayList = arrayList2;
                if (nArray != null) {
                    arrayList.add(GraphXMLWriter.createBeansDocument(customerNode));
                    if (nArray != null) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    public static Document createBeansDocument(CustomerNode customerNode) {
        Document document = DocumentHelper.createDocument();
        Element element = document.addElement("beans");
        document.setRootElement(element);
        if (customerNode != null) {
            Element element2 = GraphXMLWriter.a(element, customerNode);
            if (customerNode.hasChildren()) {
                Iterator iterator = customerNode.childrenIterator();
                while (iterator.hasNext()) {
                    TopoNode topoNode = (TopoNode)iterator.next();
                    if (topoNode instanceof SubnetNode && element2 != null) {
                        SubnetNode subnetNode = (SubnetNode)topoNode;
                        Element element3 = GraphXMLWriter.a(element2, subnetNode);
                        if (!subnetNode.hasChildren()) continue;
                        Iterator iterator2 = subnetNode.childrenIterator();
                        while (iterator2.hasNext()) {
                            topoNode = (DeviceNode)iterator2.next();
                            if (element3 == null) continue;
                            GraphXMLWriter.a(element3, topoNode);
                        }
                        continue;
                    }
                    GraphXMLWriter.a(element2, topoNode);
                }
            }
            return document;
        }
        return null;
    }

    public static String asBeansXML(CustomerNode customerNode) {
        Document document = GraphXMLWriter.createBeansDocument(customerNode);
        if (document == null) {
            return null;
        }
        String string = document.asXML();
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static Element a(Element var0, TopoNode var1_1) {
        block9: {
            var2_2 = null;
            try {
                block12: {
                    block10: {
                        var3_3 = var1_1.getBean();
                        if (var3_3.getViewGraphCount() > 0) ** GOTO lbl11
                        try {
                            block11: {
                                if (var3_3.getTopoGraphCount() <= 0) break block9;
                                break block11;
                                catch (Exception v0) {
                                    throw GraphXMLWriter.a(v0);
                                }
                            }
                            if (!(var1_1 instanceof CustomerNode)) break block10;
                        }
                        catch (Exception v1) {
                            throw GraphXMLWriter.a(v1);
                        }
                        var2_2 = var0.addElement("customer");
                        break block12;
                    }
                    var2_2 = var1_1 instanceof SubnetNode != false ? var0.addElement("subnet") : var0.addElement("device");
                }
                var2_2.addAttribute("customerId", var1_1.getCustomerID());
                var4_5 = var3_3.getDedicated();
                var2_2.addAttribute("type", var4_5[0]);
                var5_6 = var3_3.getDisplayName();
                var2_2.addAttribute("displayName", GraphXMLWriter.a(var5_6));
                var2_2.addAttribute("manuallyAdded", Boolean.toString(var3_3.isManuallyAdded()));
                var6_7 = var3_3.getInterfaces();
                GraphXMLWriter.a(var2_2, var6_7);
                GraphXMLWriter.a(var2_2, var3_3);
                var7_8 = var3_3.getOtherProperties();
                GraphXMLWriter.a(var2_2, var7_8);
                var8_9 = var3_3.getSysObjectIdValue();
                GraphXMLWriter.a(var2_2, var8_9);
                var9_10 = var3_3.getScanServices();
                GraphXMLWriter.a(var2_2, var9_10);
                if (!var3_3.isSnmpEnabled()) break block9;
                var10_11 = var3_3.getReadCommunity();
                try {
                    if (var10_11 != null) {
                        GraphXMLWriter.a(var2_2, var10_11);
                    }
                }
                catch (Exception v2) {
                    throw GraphXMLWriter.a(v2);
                }
            }
            catch (Exception var3_4) {
                GraphXMLWriter._logger.error((Object)"writeNodeBeanAttr", (Throwable)var3_4);
            }
        }
        return var2_2;
    }

    private static void a(Element element, List list) {
        if (list != null && !list.isEmpty()) {
            Element element2 = element.addElement("scanServices");
            for (int i2 = 0; i2 < list.size(); ++i2) {
                PortInfo portInfo = (PortInfo)list.get(i2);
                Element element3 = element2.addElement("scanService");
                element3.addAttribute("name", portInfo.getName());
                element3.addAttribute("port", "" + portInfo.getPort());
                element3.addAttribute("isAlive", "" + portInfo.isAlive());
            }
        }
    }

    private static void a(Element element, ReadCommunity readCommunity) {
        Element element2 = element.addElement("SNMPParams");
        element2.addAttribute("Port", "" + readCommunity.getPort());
        String string = readCommunity.getCommunity();
        if (string == null || string.length() < 1 || string.equalsIgnoreCase("public")) {
            element2.addAttribute("Community", "");
        } else {
            element2.addAttribute("Community", GraphXMLWriter.a("Community", string));
        }
        int n2 = readCommunity.getVersion();
        element2.addAttribute("Version", "" + n2);
        if (3 == n2) {
            GraphXMLWriter.a(element2, readCommunity.getV3Params());
        }
    }

    private static void a(Element element, V3Params v3Params) {
        Element element2 = element.addElement("V3Params");
        if (v3Params != null) {
            element2.addAttribute("User", v3Params.getUserName());
            element2.addAttribute("Auth", v3Params.getAuthProtocol());
            element2.addAttribute("AuthPwd", GraphXMLWriter.a("AuthPwd", v3Params.getAuthPassword()));
            element2.addAttribute("Privacy", "" + v3Params.getPrivProtocol());
            element2.addAttribute("PrivacyPwd", GraphXMLWriter.a("PrivacyPwd", v3Params.getPrivPassword()));
        }
    }

    private static String a(String string, String string2) {
        if (string2.length() == 0) {
            return "";
        }
        AesCipher aesCipher = new AesCipher(string);
        return aesCipher.encrypt(string2);
    }

    private static void a(Element element, NetworkNodeBean networkNodeBean) {
        GraphID graphID;
        Element element2;
        int n2;
        Element element3;
        if (networkNodeBean.getViewGraphCount() > 0) {
            element3 = element.addElement("viewGraphIDs");
            for (n2 = 0; n2 < networkNodeBean.getViewGraphCount(); ++n2) {
                element2 = element3.addElement("graphID");
                graphID = networkNodeBean.getViewGraphIDIndex(n2);
                element2.addAttribute("customerId", graphID.getCustomerID());
                element2.addAttribute("graphName", graphID.getGraphName());
            }
        }
        if (networkNodeBean.getTopoGraphCount() > 0) {
            element3 = element.addElement("topoGraphIDs");
            for (n2 = 0; n2 < networkNodeBean.getTopoGraphCount(); ++n2) {
                element2 = element3.addElement("graphID");
                graphID = networkNodeBean.getTopoGraphIDIndex(n2);
                element2.addAttribute("customerId", graphID.getCustomerID());
                element2.addAttribute("graphName", graphID.getGraphName());
            }
        }
    }

    private static void a(Element element, String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        element.addElement("sysObjectIdValue").addText(string);
    }

    private static void a(Element element, NetworkInterface[] networkInterfaceArray) {
        if (networkInterfaceArray == null) {
            return;
        }
        Element element2 = element.addElement("interfaces");
        for (int i2 = 0; i2 < networkInterfaceArray.length; ++i2) {
            RrpInterface rrpInterface;
            RrpGroup[] rrpGroupArray;
            Element element3 = element2.addElement("interface");
            EthernetInterface ethernetInterface = (EthernetInterface)networkInterfaceArray[i2];
            element3.addAttribute("type", ethernetInterface.getDedicated()[0]);
            element3.addAttribute("ip", ethernetInterface.getIpAddress());
            element3.addAttribute("MAC", ethernetInterface.getMacAddress());
            element3.addAttribute("status", "" + ethernetInterface.isUsed());
            element3.addAttribute("index", "" + ethernetInterface.getIfIndex());
            element3.addAttribute("virtual", "" + ethernetInterface.isVirtual());
            element3.addAttribute("speed", String.valueOf(ethernetInterface.getIfSpeed()));
            element3.addAttribute("name", GraphXMLWriter.a(ethernetInterface.getIfName()));
            if (!(ethernetInterface instanceof RrpInterface) || (rrpGroupArray = (rrpInterface = (RrpInterface)ethernetInterface).getRrpGroups()) == null) continue;
            for (int i3 = 0; i3 < rrpGroupArray.length; ++i3) {
                Element element4 = element3.addElement("RrpGroup");
                element4.addAttribute("RrpId", rrpGroupArray[i3].getRrpId());
                element4.addAttribute("state", "" + rrpGroupArray[i3].getState());
            }
        }
    }

    private static void a(Element element, CompactProperties compactProperties) {
        if (compactProperties == null) {
            return;
        }
        Element element2 = element.addElement("otherProperties");
        LinkedList linkedList = compactProperties.getProperties();
        if (linkedList != null) {
            for (int i2 = 0; i2 < linkedList.size(); ++i2) {
                Object object;
                Object object2;
                ComparablePair comparablePair = (ComparablePair)linkedList.get(i2);
                Element element3 = element2.addElement("comp");
                element3.addAttribute("key", comparablePair.name.toString());
                if (comparablePair.value instanceof List) {
                    element3.addAttribute("type", "List");
                    object2 = (List)comparablePair.value;
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        object = iterator.next();
                        Element element4 = element3.addElement("a");
                        element4.addAttribute("value", object.toString());
                    }
                    continue;
                }
                if (comparablePair.value instanceof Object[]) {
                    object2 = (Element)comparablePair.value;
                    for (int i3 = 0; i3 < ((Object)object2).length; ++i3) {
                        object = element3.addElement("a");
                        object.addAttribute("value", GraphXMLWriter.a(object2[i3].toString()));
                    }
                    continue;
                }
                object2 = element3.addElement("a");
                object2.addAttribute("value", GraphXMLWriter.a(comparablePair.value.toString()));
            }
        }
    }

    public static String asCustomersXML(List list) {
        String string;
        String string2;
        block3: {
            int[] nArray = NetworkGraphModel.b();
            if (list == null) {
                return "";
            }
            Document document = DocumentHelper.createDocument();
            Element element = document.addElement("customers");
            document.setRootElement(element);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                string2 = element.addElement("customer");
                string = (String)iterator.next();
                if (nArray != null) {
                    String string3 = string;
                    string2.addAttribute("id", string3);
                    if (nArray != null) continue;
                }
                break block3;
            }
            string = document.asXML();
        }
        string2 = string;
        return string2;
    }

    private static String a(String string) {
        return Base64.encodeToString((byte[])string.getBytes(), (boolean)true);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

