/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.graph;

import com.sysuptime.common.graph.GraphUserObject;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.graph.PadGraphUI;
import java.awt.Color;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.Edge;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;
import org.jgraph.plaf.GraphUI;

public class PadGraph
extends JGraph {
    protected boolean pagevisible = false;
    protected transient PageFormat pageFormat = new PageFormat();
    protected Image background;
    protected transient Color defaultBorderColor = Color.BLACK;
    protected boolean isParent;

    public PadGraph() {
    }

    public PadGraph(GraphModel graphModel) {
        this(graphModel, null);
    }

    public PadGraph(GraphModel graphModel, GraphLayoutCache graphLayoutCache) {
        super(graphModel, graphLayoutCache);
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((GraphUI)new PadGraphUI());
        this.invalidate();
    }

    public static GraphUserObject getGPUserObject(Object object) {
        Object object2;
        if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof GraphUserObject) {
            return (GraphUserObject)object2;
        }
        return null;
    }

    public static void addSampleData(GraphModel graphModel) {
    }

    public void setPageFormat(PageFormat pageFormat) {
        this.pageFormat = pageFormat;
    }

    public PageFormat getPageFormat() {
        return this.pageFormat;
    }

    public void setPageVisible(boolean bl2) {
        this.pagevisible = bl2;
    }

    public boolean isPageVisible() {
        return this.pagevisible;
    }

    public boolean isGroup(Object object) {
        CellView cellView = this.getGraphLayoutCache().getMapping(object, false);
        if (cellView != null) {
            return !cellView.isLeaf();
        }
        return false;
    }

    public boolean isVertex(Object object) {
        if (!(object instanceof Port) && !(object instanceof Edge)) {
            return !this.isGroup(object) && object != null;
        }
        return false;
    }

    public boolean isPort(Object object) {
        return object instanceof Port;
    }

    public boolean isEdge(Object object) {
        return object instanceof Edge;
    }

    public Object[] getSelectionVertices() {
        Object[] objectArray = this.getSelectionCells();
        Object[] objectArray2 = DefaultGraphModel.getDescendants((GraphModel)this.getModel(), (Object[])objectArray).toArray();
        return this.getVertices(objectArray2);
    }

    public Object[] getVertices(Object[] objectArray) {
        int[] nArray = NetworkGraphModel.b();
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!this.isVertex(objectArray[i2])) continue;
                arrayList.add(objectArray[i2]);
                if (nArray != null) continue;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object[] getSelectionEdges() {
        return this.getEdges(this.getSelectionCells());
    }

    public Object[] getAll() {
        return this.getDescendants(this.getRoots());
    }

    public Object[] getEdges(Object[] objectArray) {
        int[] nArray = NetworkGraphModel.b();
        if (objectArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (!this.isEdge(objectArray[i2])) continue;
                arrayList.add(objectArray[i2]);
                if (nArray != null) continue;
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Object getNeighbour(Object object, Object object2) {
        Object object3 = this.getSourceVertex(object);
        if (object2 == object3) {
            return this.getTargetVertex(object);
        }
        return object3;
    }

    public Object getSourceVertex(Object object) {
        Object object2 = this.graphModel.getSource(object);
        return this.graphModel.getParent(object2);
    }

    public Object getTargetVertex(Object object) {
        Object object2 = this.graphModel.getTarget(object);
        return this.graphModel.getParent(object2);
    }

    public CellView getSourceView(Object object) {
        Object object2 = this.getSourceVertex(object);
        return this.getGraphLayoutCache().getMapping(object2, false);
    }

    public CellView getTargetView(Object object) {
        Object object2 = this.getTargetVertex(object);
        return this.getGraphLayoutCache().getMapping(object2, false);
    }

    public Object[] getEdgesBetween(Object object, Object object2) {
        ArrayList arrayList = new ArrayList();
        int[] nArray = NetworkGraphModel.b();
        Set set = DefaultGraphModel.getEdges((GraphModel)this.graphModel, (Object[])new Object[]{object});
        for (Object e10 : set) {
            Object object3 = this.getSourceVertex(e10);
            Object object4 = this.getTargetVertex(e10);
            if (object3 == object && object4 == object2 || object3 == object2 && object4 == object) {
                arrayList.add(e10);
            }
            if (nArray != null) continue;
        }
        return arrayList.toArray();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent != null && (object = this.getFirstCellForLocation(mouseEvent.getX(), mouseEvent.getY())) != null) {
            String string = this.convertValueToString(object);
            Object object2 = "<html>";
            if (string != null && string.length() > 0) {
                object2 = (String)object2 + "<strong>" + string + "</strong><br>";
            }
            return (String)object2 + "</html>";
        }
        return null;
    }

    protected String a(Object object) {
        return "";
    }

    public boolean isNeighbour(Object object, Object object2) {
        return DefaultGraphModel.containsEdgeBetween((GraphModel)this.getModel(), (Object)object, (Object)object2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pageFormat = new PageFormat();
    }

    public void setIsParent(boolean bl2) {
        this.isParent = bl2;
        this.setMoveable(bl2);
        this.setDragEnabled(bl2);
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setBackgroundImage(Image image) {
        this.background = image;
        this.repaint();
    }

    public Image getBackgroundImage() {
        return this.background;
    }

    public JPopupMenu createPopupMenu(Point point, Object object) {
        return new JPopupMenu();
    }
}

