/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.model;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.model.CIM_UnitaryComputerSystemBeanSupport;
import com.sysuptime.common.model.DeviceBean;
import com.sysuptime.common.model.DeviceNode;
import com.sysuptime.common.model.ParentBean;
import com.sysuptime.common.model.TopoNode;
import com.sysuptime.server.msp.Command;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ParentNode
extends TopoNode {
    protected transient Map<String, TopoNode> _subNodes;

    public ParentNode(ParentBean parentBean) {
        super(parentBean);
    }

    public void addSubNode(TopoNode topoNode) {
        if (this._subNodes == null) {
            this._subNodes = new Hashtable<String, TopoNode>();
        }
        this._subNodes.put(topoNode.getPrivateID(), topoNode);
        topoNode.setParentNode(this);
    }

    public void removeSubNode(String string) {
        if (this._subNodes != null) {
            TopoNode topoNode = this.getSubNode(string);
            if (topoNode != null) {
                topoNode.setParentNode(null);
            }
            this._subNodes.remove(string);
        }
    }

    public TopoNode getSubNode(String string) {
        if (this._subNodes != null) {
            return this._subNodes.get(string);
        }
        return null;
    }

    public boolean includesSubBean(String string) {
        return this.getSubNode(string) != null;
    }

    public boolean hasChildren() {
        return this._subNodes != null && !this._subNodes.isEmpty();
    }

    public Iterator childrenIterator() {
        if (this._subNodes != null) {
            return this._subNodes.values().iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public List<TopoNode> getChildren() {
        if (this._subNodes == null) {
            return new ArrayList<TopoNode>();
        }
        return new ArrayList<TopoNode>(this._subNodes.values());
    }

    public static Set<TopoNode> getDescendants(ParentNode parentNode) {
        HashSet<TopoNode> hashSet = new HashSet<TopoNode>();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        if (parentNode.hasChildren()) {
            List<TopoNode> list = parentNode.getChildren();
            hashSet.addAll(list);
            for (TopoNode topoNode : list) {
                if (topoNode instanceof ParentNode) {
                    hashSet.addAll(ParentNode.getDescendants((ParentNode)topoNode));
                }
                if (commandArray == null) continue;
            }
        }
        return hashSet;
    }

    public synchronized Set<DeviceBean> getDescendantDevices() {
        HashSet<DeviceBean> hashSet = new HashSet<DeviceBean>();
        Set<TopoNode> set = ParentNode.getDescendants(this);
        Iterator<TopoNode> iterator = set.iterator();
        Command[] commandArray = CIM_UnitaryComputerSystemBeanSupport.b();
        while (iterator.hasNext()) {
            TopoNode topoNode = iterator.next();
            if (topoNode instanceof DeviceNode) {
                hashSet.add((DeviceBean)topoNode.getBean());
            }
            if (commandArray == null) continue;
        }
        return hashSet;
    }

    public GraphID getSubGraphID() {
        return new GraphID(this._bean.getCustomerID(), this._bean.getPrivateID());
    }
}

