/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.common.trapreceiver;

import com.ireasoning.util.bl;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.common.trapreceiver.TrapEventObject;
import com.sysuptime.common.trapreceiver.TrapIpInfo;
import com.sysuptime.common.util.StringUtil;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class TrapObject
implements Serializable {
    private double _trapId;
    private String _beanId;
    private String _receiveTimeText = "";
    private String _customerName;
    private String _ipAddress;
    private String _trapOid;
    private String _enterprise;
    private Timestamp _ackTime;
    private boolean _isAcked;
    private String _ackUser;
    private String _message;
    private int _correlation;
    private boolean _isCleared;
    private Timestamp _clearTime;
    private String _clearUser;
    private long _timestamp;
    private String _timestampText;
    private int _specific;
    private String _generic;
    private List<bl> _varbinds;
    private String _versionNumber;
    private short _severity;
    private String _severityText;
    private String _ackComment;
    private String _clearComment;
    private TrapEventObject _event;
    private int _series;
    private TrapIpInfo _tii;
    private long _probeID;
    private static final SimpleDateFormat FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    public void setSeries(int n2) {
        this._series = n2;
    }

    public String getEnterprise() {
        return this._enterprise;
    }

    public void setEnterprise(String string) {
        this._enterprise = string;
    }

    public String getVersionNumber() {
        return this._versionNumber;
    }

    public TrapIpInfo getTrapIpInfo() {
        if (this._tii == null) {
            this._tii = new TrapIpInfo(this._ipAddress, this._series, this._severity);
        }
        return this._tii;
    }

    public void setTrapIpInfo(TrapIpInfo trapIpInfo) {
        this._tii = trapIpInfo;
    }

    public void setVersionNumber(String string) {
        this._versionNumber = string;
    }

    public short getSeverity() {
        return this._severity;
    }

    public void setSeverity(short s2) {
        if (s2 >= ITrapConstants.SEVERITY_STRINGS.length) {
            s2 = 0;
        }
        this._severity = s2;
        this._severityText = ITrapConstants.SEVERITY_STRINGS[s2];
    }

    public String getSeverityText() {
        return this._severityText;
    }

    public Integer getSeverityInInteger() {
        return this._severity;
    }

    public String getAckComment() {
        return this._ackComment;
    }

    public void setAckComment(String string) {
        this._ackComment = string;
    }

    public String getClearComment() {
        return this._clearComment;
    }

    public void setClearComment(String string) {
        this._clearComment = string;
    }

    public List<bl> getVarbinds() {
        return this._varbinds;
    }

    public void setVarbinds(List list) {
        this._varbinds = list;
    }

    public TrapEventObject getEvent() {
        return this._event;
    }

    public void setEvent(TrapEventObject trapEventObject) {
        this._event = trapEventObject;
    }

    public void setTrapId(double d10) {
        this._trapId = d10;
        if (d10 != 0.0) {
            this._receiveTimeText = FORMAT.format(new Date((long)d10));
        }
    }

    public double getTrapId() {
        return this._trapId;
    }

    public void setCustomerName(String string) {
        this._customerName = string;
    }

    public String getCustomerName() {
        return this._customerName;
    }

    public void setIpAddress(String string) {
        this._ipAddress = string;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public void setTrapOid(String string) {
        this._trapOid = string;
    }

    public String getTrapOid() {
        return this._trapOid;
    }

    public long getOccurTime() {
        return (long)this._trapId;
    }

    public void setAckTime(Timestamp timestamp) {
        this._ackTime = timestamp;
    }

    public Timestamp getAckTime() {
        return this._ackTime;
    }

    public void setAcked(String string) {
        this._isAcked = StringUtil.getBool(string);
    }

    public void setAcked(boolean bl2) {
        this._isAcked = bl2;
    }

    public Boolean getAcked() {
        return this._isAcked;
    }

    public void setAckUser(String string) {
        this._ackUser = string;
    }

    public String getAckUser() {
        return this._ackUser;
    }

    public void setMessage(String string) {
        this._message = string;
    }

    public String getMessage() {
        return this._message;
    }

    public void setCorrelation(int n2) {
        this._correlation = n2;
    }

    public int getCorrelation() {
        return this._correlation;
    }

    public void setClearing(String string) {
        this._isCleared = StringUtil.getBool(string);
    }

    public Boolean getClearing() {
        return this._isCleared;
    }

    public void setClearTime(Timestamp timestamp) {
        this._clearTime = timestamp;
    }

    public Timestamp getClearTime() {
        return this._clearTime;
    }

    public void setClearUser(String string) {
        this._clearUser = string;
    }

    public String getClearUser() {
        return this._clearUser;
    }

    public void setTimestamp(long l2) {
        this._timestamp = l2;
        if (this._timestamp != 0L) {
            long l3 = this._timestamp / 1000L;
            long l4 = l3 / 3600L;
            long l5 = l3 % 3600L / 60L;
            long l6 = l3 % 60L;
            StringBuffer stringBuffer = new StringBuffer();
            if (l4 != 0L) {
                stringBuffer.append(l4).append(" ").append(ITrapConstants.HOURS).append(" ");
            }
            if (l4 != 0L || l5 != 0L) {
                stringBuffer.append(l5).append(" ").append(ITrapConstants.MINUTES).append(" ");
            }
            stringBuffer.append(l6).append(" ").append(ITrapConstants.SECONDS).append(" ");
            this._timestampText = stringBuffer.toString();
        }
    }

    public String getTimeStampText() {
        return this._timestampText;
    }

    public String getReceiveTimeText() {
        return this._receiveTimeText;
    }

    public long getTimestamp() {
        return this._timestamp;
    }

    public void setSpecific(int n2) {
        this._specific = n2;
    }

    public long getSpecific() {
        return (long)this._specific & 0xFFFFFFFFL;
    }

    public void setBeanId(String string) {
        this._beanId = string;
    }

    public String getBeanId() {
        return this._beanId;
    }

    public void setGeneric(String string) {
        this._generic = string;
    }

    public String getGeneric() {
        return this._generic;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TrapObject)) {
            return false;
        }
        TrapObject trapObject = (TrapObject)object;
        return this._trapId == trapObject._trapId && this._probeID == trapObject.getProbeID();
    }

    public int hashCode() {
        return 0;
    }

    public long getProbeID() {
        return this._probeID;
    }

    public void setProbeID(long l2) {
        this._probeID = l2;
    }
}

