/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.discovery;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.discovery.DiscoveryFilter;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.mainframe.discovery.DiscoveryFilterDialog$1;
import com.sysuptime.mainframe.discovery.DiscoveryFilterDialog$DeviceTypeTableModel;
import com.sysuptime.mainframe.discovery.MediationDialog;
import com.sysuptime.mainframe.util.ConfirmDialog;
import com.sysuptime.mainframe.util.FormUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class DiscoveryFilterDialog
extends ConfirmDialog
implements FocusListener {
    public static final String DEFAULT_EXAMPLE = DiscoveryFilterDialog.a("IpRangeExample");
    private JRadioButton _ignoreRadio;
    private JRadioButton _mustRadio;
    private JTextField _ipRangeField;
    private JTextField _sysNameField;
    private JTextField _sysDescrField;
    private JTable _deviceTypeTable;
    private DiscoveryFilterDialog$DeviceTypeTableModel _deviceTypeModel;
    private boolean _isOK;

    public DiscoveryFilterDialog(Dialog dialog, DiscoveryFilter discoveryFilter) {
        super(dialog, "", true);
        this.setTitle(DiscoveryFilterDialog.a("DiscoveryFilterDialog_title"));
        this.a(discoveryFilter);
    }

    private void d() {
        ButtonGroup buttonGroup = new ButtonGroup();
        this._ignoreRadio = new JRadioButton(DiscoveryFilterDialog.a("DiscoveryFilterDialog_radio_ignore"));
        this._mustRadio = new JRadioButton(DiscoveryFilterDialog.a("DiscoveryFilterDialog_radio_must"), true);
        buttonGroup.add(this._mustRadio);
        buttonGroup.add(this._ignoreRadio);
        this._ipRangeField = new JTextField();
        this._ipRangeField.addFocusListener(this);
        this._ipRangeField.setText(DEFAULT_EXAMPLE);
        this._ipRangeField.setCaretPosition(0);
        this._sysNameField = new JTextField();
        this._sysDescrField = new JTextField();
        this._deviceTypeModel = new DiscoveryFilterDialog$DeviceTypeTableModel();
        this._deviceTypeTable = this.a(this._deviceTypeModel);
        this._ipRangeField.setToolTipText(DiscoveryFilterDialog.a("filter_ipRange_tip"));
        this._sysNameField.setToolTipText(DiscoveryFilterDialog.a("filter_sysName_tip"));
        this._sysDescrField.setToolTipText(DiscoveryFilterDialog.a("filter_sysDescr_tip"));
        this._deviceTypeTable.setToolTipText(DiscoveryFilterDialog.a("filter_sysTypes_tip"));
        this._mustRadio.setToolTipText(DiscoveryFilterDialog.a("filter_mode_tip"));
        this._ignoreRadio.setToolTipText(DiscoveryFilterDialog.a("filter_mode_tip"));
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        String string = this._ipRangeField.getText();
        if (string.indexOf(DEFAULT_EXAMPLE) >= 0) {
            this._ipRangeField.setText("");
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        String string = this._ipRangeField.getText();
        if (string.length() == 0 && this._mustRadio.isSelected()) {
            this._ipRangeField.setText(DEFAULT_EXAMPLE);
        }
    }

    private void a(DiscoveryFilter discoveryFilter) {
        block4: {
            block6: {
                block5: {
                    int n2 = MediationDialog.x();
                    if (discoveryFilter == null) break block4;
                    if (!"IGNORE".equals(discoveryFilter.getMode())) break block5;
                    this._ignoreRadio.setSelected(true);
                    if (n2 == 0) break block6;
                }
                this._mustRadio.setSelected(true);
            }
            this._ipRangeField.setText(discoveryFilter.getIpRange());
            this._sysNameField.setText(discoveryFilter.getSysName());
            this._sysDescrField.setText(discoveryFilter.getSysDescr());
            String[] stringArray = discoveryFilter.getSystemTypes();
            List<String> list = null;
            if (stringArray != null) {
                list = Arrays.asList(stringArray);
            }
            ((DiscoveryFilterDialog$DeviceTypeTableModel)this._deviceTypeTable.getModel()).setSelectedTypes(list);
        }
    }

    @Override
    protected JPanel getCenterPane() {
        return this.createPanel();
    }

    public JPanel createPanel() {
        this.d();
        JPanel jPanel = new JPanel();
        FormLayout formLayout = new FormLayout("FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:NONE,FILL:DEFAULT:GROW(1.0),FILL:DEFAULT:NONE,FILL:DEFAULT:NONE", "CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE,CENTER:DEFAULT:NONE");
        CellConstraints cellConstraints = new CellConstraints();
        jPanel.setLayout((LayoutManager)formLayout);
        JLabel jLabel = new JLabel();
        jLabel.setText(DiscoveryFilterDialog.a("DiscoveryFilterDialog_label_mode"));
        jPanel.add((Component)jLabel, cellConstraints.xy(3, 3));
        jPanel.add((Component)this._mustRadio, cellConstraints.xywh(5, 3, 2, 1));
        jPanel.add((Component)this._ignoreRadio, cellConstraints.xywh(5, 4, 2, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText(DiscoveryFilterDialog.a("DiscoveryFilterDialog_label_IPRange"));
        jPanel.add((Component)jLabel2, cellConstraints.xy(3, 6));
        jPanel.add((Component)this._ipRangeField, cellConstraints.xywh(5, 6, 2, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(DiscoveryFilterDialog.a("DiscoveryFilterDialog_label_sysName"));
        jPanel.add((Component)jLabel3, cellConstraints.xy(3, 8));
        jPanel.add((Component)this._sysNameField, cellConstraints.xywh(5, 8, 2, 1));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(DiscoveryFilterDialog.a("DiscoveryFilterDialog_label_sysDescr"));
        jPanel.add((Component)jLabel4, cellConstraints.xy(3, 10));
        jPanel.add((Component)this._sysDescrField, cellConstraints.xywh(5, 10, 2, 1));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText(DiscoveryFilterDialog.a("DiscoveryFilterDialog_label_deviceTypes"));
        jPanel.add((Component)jLabel5, cellConstraints.xy(3, 12));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.setViewportView(this._deviceTypeTable);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(30);
        jPanel.add((Component)jScrollPane, cellConstraints.xywh(5, 12, 2, 1));
        FormUtils.addFillComponents(jPanel, new int[]{1, 2, 3, 4, 5, 6, 7, 8}, new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14});
        return jPanel;
    }

    @Override
    protected void doOK() {
        if (this.e()) {
            this._isOK = true;
            this.dispose();
        }
    }

    private boolean e() {
        return this.f();
    }

    private boolean f() {
        block7: {
            block6: {
                String string = this._ipRangeField.getText();
                int n2 = MediationDialog.x();
                if (string.length() == 0) break block6;
                if (string.indexOf(DEFAULT_EXAMPLE) >= 0) {
                    JOptionPane.showMessageDialog(this, DiscoveryFilterDialog.a("msg_invalidIp"), ICommonBundle.ERROR, 0);
                    return false;
                }
                if (!"MUST".equals(this.g()) || string.indexOf("/") == -1) break block7;
                int n3 = Integer.parseInt(StringUtil.getLastToken(string, "/"));
                if (n3 < 24) {
                    JOptionPane.showMessageDialog(this, DiscoveryFilterDialog.a("msg_invalidCIDRip"), ICommonBundle.ERROR, 0);
                    return false;
                }
                if (n2 == 0) break block7;
            }
            if ("MUST".equals(this.g())) {
                JOptionPane.showMessageDialog(this, DiscoveryFilterDialog.a("msg_invalidNullMustIp"), ICommonBundle.ERROR, 0);
                return false;
            }
        }
        return true;
    }

    private static String a(String string) {
        return NbBundle.getMessage(DiscoveryFilterDialog.class, (String)string);
    }

    public boolean isOK() {
        return this._isOK;
    }

    public DiscoveryFilter getFilter() {
        String string = this._ipRangeField.getText();
        String string2 = this._sysNameField.getText();
        String string3 = this._sysDescrField.getText();
        String[] stringArray = null;
        List list = this._deviceTypeModel.getSelectedTypes();
        if (list != null) {
            stringArray = StringUtil.toStringArray(list.toArray());
        }
        String string4 = this.g();
        return new DiscoveryFilter(string, string2, string3, stringArray, string4);
    }

    private String g() {
        if (this._mustRadio.isSelected()) {
            return "MUST";
        }
        return "IGNORE";
    }

    private JTable a(DiscoveryFilterDialog$DeviceTypeTableModel discoveryFilterDialog$DeviceTypeTableModel) {
        JTable jTable = new JTable(discoveryFilterDialog$DeviceTypeTableModel);
        jTable.setTableHeader(null);
        jTable.getColumnModel().getColumn(0).setMaxWidth(20);
        jTable.setRowSelectionAllowed(false);
        jTable.getCellEditor(0, 0).addCellEditorListener(new DiscoveryFilterDialog$1(this, jTable, discoveryFilterDialog$DeviceTypeTableModel));
        return jTable;
    }

    @Override
    public void showCenterOnOwner() {
        this.setSize(550, 380);
        super.showCenterOnOwner();
    }
}

