/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.nodes.editors;

import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.mainframe.ConsoleComponent;
import com.sysuptime.mainframe.graph.GraphLoader;
import com.sysuptime.mainframe.graph.NetworkGraphLayoutCache;
import com.sysuptime.mainframe.nodes.TreeNode;
import com.sysuptime.mainframe.nodes.editors.DeviceIconProperty$1;
import com.sysuptime.mainframe.nodes.editors.DeviceIconProperty$2;
import com.sysuptime.mainframe.nodes.editors.DeviceIconProperty$3;
import com.sysuptime.mainframe.util.FunctionManager;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jgraph.graph.GraphConstants;
import org.openide.nodes.PropertySupport;

public class DeviceIconProperty
extends PropertySupport.ReadWrite {
    private NetworkNode _graphNode;

    public DeviceIconProperty(String string, NetworkNode networkNode) {
        super(string, File.class, string, string);
        this.setValue("directories", Boolean.FALSE);
        this.setValue("filter", new DeviceIconProperty$1(this));
        this._graphNode = networkNode;
    }

    public Object getValue() {
        File file = null;
        ImageIcon imageIcon = this._graphNode.getCurrentDefaultIcon();
        if (imageIcon != null) {
            String string = ((Object)imageIcon).toString();
            file = string.indexOf("file:/") == 0 ? new File(string.substring("file:/".length() - 1)) : new File(string);
        }
        return file;
    }

    public boolean canWrite() {
        return FunctionManager.getInstance().isEditGraphEnabled();
    }

    public void setValue(Object object) {
        File file = (File)object;
        ImageIcon imageIcon = new ImageIcon(file.getPath());
        this._graphNode.setCurrentDefaultIcon(imageIcon);
        Hashtable hashtable = new Hashtable();
        GraphConstants.setIcon(hashtable, (Icon)imageIcon);
        NetworkGraphLayoutCache networkGraphLayoutCache = (NetworkGraphLayoutCache)ConsoleComponent.getInstance().getCurrentGraph().getGraphLayoutCache();
        networkGraphLayoutCache.editCell(this._graphNode, hashtable);
        ConsoleComponent.getInstance().updateGraphStatus();
        if (GraphLoader.isExternalIcon(file.getPath())) {
            TreeNode.addIcon(this._graphNode, file);
        }
    }

    public PropertyEditor getPropertyEditor() {
        if (!FunctionManager.getInstance().isEditGraphEnabled()) {
            return new DeviceIconProperty$2(this);
        }
        return new DeviceIconProperty$3(this);
    }

    public String toString() {
        return this.getValue().toString();
    }
}

