/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.ComponentElement;
import com.sysuptime.mainframe.performance.ComponentProvider;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.OperationDialog;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;

public abstract class AbstractProtocolParametersDialog
extends OperationDialog {
    private List _parameterValues;
    private List _parameterNames;
    private Map _parameterNamesToValues;
    private ComponentProvider _componentProvider;

    public AbstractProtocolParametersDialog() {
    }

    public AbstractProtocolParametersDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
    }

    protected JComponent getTitlePanel(List list) {
        return this.getTitlePanel(list, false);
    }

    protected JComponent getTitlePanel(List list, boolean bl2) {
        this._componentProvider = new ComponentProvider();
        FormLayout formLayout = null;
        formLayout = !bl2 ? new FormLayout("p,5dlu,p:g,5dlu,p,3dlu,p", "") : new FormLayout("p,3dlu,p:g,3dlu,p,7dlu,p,3dlu,p:g,3dlu,p", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        int n2 = list.size();
        this._parameterValues = new ArrayList(n2);
        this._parameterNames = new ArrayList(n2);
        this._parameterNamesToValues = new HashMap(n2);
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            QueryParameterElement queryParameterElement = (QueryParameterElement)list.get(n3);
            n4 = this.appendParameterCompenent(defaultFormBuilder, cellConstraints, queryParameterElement, n4);
            if (!bl2) {
                defaultFormBuilder.nextLine();
            } else if (n4 % 2 == 1) {
                defaultFormBuilder.nextLine();
            }
            ++n3;
            ++n4;
        }
        return defaultFormBuilder.getPanel();
    }

    protected String getLineEnd(QueryParameterElement queryParameterElement) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = queryParameterElement.getUnit();
        if (string != null) {
            stringBuffer.append(Snippet.getBundledString(string));
            stringBuffer.append(" ");
        }
        if (queryParameterElement.isOptional()) {
            stringBuffer.append(DialogConstants.LABEL_ISOPTIONAL);
        }
        return stringBuffer.toString();
    }

    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        JLabel jLabel = new JLabel(string2);
        defaultFormBuilder.append((Component)jLabel);
        jLabel.setVisible(queryParameterElement.isVisible());
        defaultFormBuilder.append((Component)this.getParameterComponent(queryParameterElement, string2));
        defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
        return n2;
    }

    protected JComponent getParameterComponent(QueryParameterElement queryParameterElement, String string) {
        JComponent jComponent = this._componentProvider.getComponent(queryParameterElement);
        jComponent.setPreferredSize(new Dimension((int)jComponent.getPreferredSize().getWidth(), 23));
        jComponent.setEnabled(queryParameterElement.isEnabled());
        jComponent.setVisible(queryParameterElement.isVisible());
        jComponent.setToolTipText(queryParameterElement.getTooltip() != null ? Snippet.getBundledString(queryParameterElement.getTooltip()) : null);
        String string2 = queryParameterElement.getValidation();
        boolean bl2 = queryParameterElement.getIdPostfix() != null;
        ComponentElement componentElement = new ComponentElement(jComponent, queryParameterElement.getName(), string, bl2, string2);
        this._parameterValues.add(componentElement);
        this._parameterNames.add(queryParameterElement.getName());
        this._parameterNamesToValues.put(queryParameterElement.getName(), componentElement);
        return jComponent;
    }

    protected void initParameterData(QueryParameter queryParameter) {
        this.initParameterData(queryParameter, 0, queryParameter.size());
    }

    protected final void initParameterData(QueryParameter queryParameter, int n2, int n3) {
        List list = queryParameter.getList();
        Object[] objectArray = this._parameterValues.toArray();
        int n4 = objectArray.length;
        int n5 = queryParameter.size();
        int n6 = n2 >= 0 ? n2 : 0;
        int n7 = n4 <= n5 ? n4 : n5;
        int n8 = n3 <= n7 ? n3 : n7;
        for (int i2 = n6; i2 < n8; ++i2) {
            ComponentElement componentElement = (ComponentElement)objectArray[i2];
            JComponent jComponent = componentElement.getComponent();
            String string = list.get(i2).toString();
            this._componentProvider.setInput(jComponent, componentElement.getName(), string);
        }
    }

    protected List getValidatedParametersValues() {
        return this.getValidatedParametersValues(0);
    }

    protected List getValidatedParametersValues(int n2) {
        return this.getValidatedParametersValues(n2, this._parameterValues.size());
    }

    protected final List getUnValidatedParametersValues(int n2, int n3) {
        return this.getInputParametersValues(n2, n3, false);
    }

    protected final List getValidatedParametersValues(int n2, int n3) {
        return this.getInputParametersValues(n2, n3, true);
    }

    private List getInputParametersValues(int n2, int n3, boolean bl2) {
        int n4 = this._parameterValues.size();
        Object[] objectArray = this._parameterValues.toArray();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n5 = n2 >= 0 ? n2 : 0;
        int n6 = n3 <= n4 ? n3 : n4;
        for (int i2 = n5; i2 < n6; ++i2) {
            ComponentElement componentElement = (ComponentElement)objectArray[i2];
            JComponent jComponent = componentElement.getComponent();
            String string = this._componentProvider.getInput(componentElement.getName(), jComponent);
            String string2 = componentElement.getValidation();
            String string3 = componentElement.getLocaleName();
            if (string3.equals("Instances")) continue;
            if (bl2) {
                Object object = SingletonValidator.checkAllDialog(this, string3, string, string2);
                if (object == null) {
                    return null;
                }
                arrayList.add(object);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    protected JComponent getComponent(String string) {
        ComponentElement componentElement = (ComponentElement)this._parameterNamesToValues.get(string);
        return componentElement.getComponent();
    }

    protected List getParameterValue() {
        return this._parameterValues;
    }

    protected List getParameterName() {
        return this._parameterNames;
    }

    protected ComponentProvider getComponentProvider() {
        return this._componentProvider;
    }
}

