/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.AgentProperties;
import com.sysuptime.common.expression.IExpression;
import com.sysuptime.common.expression.NormalExpressionConstants;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.MonitorTestRun;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.CheckProcessStateMonitorPane;
import com.sysuptime.mainframe.performance.ConciseSnmpMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.SnmpDevicesMonitorPane;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import org.openide.util.NbBundle;

public class ConciseCheckProcessStateMonitorSecondDialog
extends ConciseSnmpMonitorSecondDialog
implements NormalExpressionConstants {
    private SnmpDevicesMonitorPane _checkProcessStatePane;

    public ConciseCheckProcessStateMonitorSecondDialog(AgentProperties agentProperties, SnmpDevicesMonitorPane snmpDevicesMonitorPane, DefaultTableModel defaultTableModel) {
        super(true, ConciseCheckProcessStateMonitorSecondDialog.fromBundle("Check_process_state_title"), snmpDevicesMonitorPane, agentProperties, defaultTableModel);
        this._checkProcessStatePane = snmpDevicesMonitorPane;
        this._checkProcessStatePane.setThresholdCondition(DialogConstants.EXCLUDE);
        this._checkProcessStatePane.setResultUnitLabelVisible(false);
    }

    @Override
    protected IExpression createNormalExpression(String string) {
        try {
            if (string.equals("Check Process State")) {
                String string2 = "Processes";
                String string3 = "Check if a process is running. Enter the name of the process in the threshod screen and its condition is `Excludes`. Valid if the SNMP agent supports HOST-RESOURCES-MIB.";
                Vector vector = new Vector();
                Vector<String> vector2 = new Vector<String>();
                vector2.addElement("Processes");
                vector2.addElement(".1.3.6.1.2.1.25.4.2.1.2.s");
                vector.add(vector2);
                return ClientProxy.getInstance().updateExpression(string, string2, string3, vector);
            }
            if (string.equals("Check Process State from NET-SNMP agent")) {
                String string4 = "prNames+prErrorFlag";
                String string5 = "Check if a process is running. Enter the name of the process (in processName<>0 format, where 0 means the process is running) in the threshod screen and its condition is `Excludes`. Valid if the SNMP agent is NET-SNMP agent and prTable is not empty.";
                Vector vector = new Vector();
                Vector<String> vector3 = new Vector<String>();
                vector3.addElement("prNames");
                vector3.addElement(".1.3.6.1.4.1.2021.2.1.2.s");
                vector.add(vector3);
                vector3 = new Vector();
                vector3.addElement("prErrorFlag");
                vector3.addElement(".1.3.6.1.4.1.2021.2.1.100.s");
                vector.add(vector3);
                return ClientProxy.getInstance().updateExpression(string, string4, string5, vector);
            }
        }
        catch (Exception exception) {
            _logger.error((Object)"create expression Error:", (Throwable)exception);
        }
        return null;
    }

    @Override
    protected String getExpressionName() {
        return ((CheckProcessStateMonitorPane)this._checkProcessStatePane).getExpressionName();
    }

    @Override
    protected IExpression getSubExpressin(IExpression iExpression, int n2) {
        return this.getSpecialExpression(this.getExpressionName());
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseCheckProcessStateMonitorSecondDialog.class, (String)string);
    }

    @Override
    protected void formatResult(StringBuffer stringBuffer, MonitorTestRun monitorTestRun) {
        String string = this._checkProcessStatePane.getThresholdResult();
        Iterator iterator = monitorTestRun.getResultMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            Integer n2 = (Integer)entry2.getKey();
            ResultValue resultValue = (ResultValue)entry2.getValue();
            String string2 = MonitorHelper.getConstantLocaleName(n2);
            if (resultValue.isError()) {
                stringBuffer.append("<b>").append(Snippet.getBundledString("errormessage")).append(" ( ").append(string2).append(" ) ").append(":").append("</b>").append("<br>");
                stringBuffer.append(resultValue.getErrorUnknownMessage());
            } else {
                stringBuffer.append("<b>").append("Processes state").append(" ").append(string2).append(" :").append("</b>").append("<br>");
                if (resultValue.isNormal()) {
                    stringBuffer.append("<table><tr><td><pre>").append(this.getRunningProcess(resultValue.getValue().toString(), string)).append("</pre></table>");
                } else if (resultValue.isUnknown()) {
                    stringBuffer.append(resultValue.getErrorUnknownMessage());
                }
            }
            stringBuffer.append("<p>");
        }
        stringBuffer.append("<p>").append(monitorTestRun.getErrorText());
        stringBuffer.append("<br>");
    }

    @Override
    protected String getQueryResultString() {
        return ConciseCheckProcessStateMonitorSecondDialog.fromBundle("process_state_result");
    }

    private String getRunningProcess(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        boolean bl2 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "<>");
            if (stringTokenizer2.countTokens() > 1) {
                int n2 = string3.indexOf("<>");
                String string4 = string3.substring(n2 + "<>".length(), n2 + "<>".length() + 1);
                int n3 = string2.indexOf("<>");
                if (n3 > 0) {
                    string2 = string2.substring(0, n3);
                }
                if (string3.indexOf(string2) < 0) continue;
                bl2 = true;
                stringBuffer.append("<b>").append(string2).append(" ");
                if (string4.equals("1")) {
                    stringBuffer.append(ConciseCheckProcessStateMonitorSecondDialog.fromBundle("MSG_process_stopped")).append("</b>").append("<br>");
                    continue;
                }
                stringBuffer.append(ConciseCheckProcessStateMonitorSecondDialog.fromBundle("MSG_process_is_running")).append("</b>").append("<br>");
                continue;
            }
            if (string3.indexOf(string2) < 0) continue;
            bl2 = true;
            stringBuffer.append("<b>").append(string3).append(" ");
            stringBuffer.append(ConciseCheckProcessStateMonitorSecondDialog.fromBundle("MSG_process_is_running")).append("</b>").append("<br>");
        }
        if (!bl2) {
            stringBuffer.append("<b>").append(string2).append(" ");
            stringBuffer.append(ConciseCheckProcessStateMonitorSecondDialog.fromBundle("MSG_process_stopped")).append("</b>").append("<br>");
        }
        return stringBuffer.toString();
    }

    @Override
    protected int getMonitorType() {
        return this.PROCESS_TYPE;
    }
}

