/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.sysuptime.common.performance.IProtocolHost;
import com.sysuptime.common.performance.Monitor;
import com.sysuptime.common.performance.MonitorHelper;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.ServiceNameElement;
import com.sysuptime.common.performance.TargetFactory;
import com.sysuptime.common.util.NameValuePair;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConciseMonitorSecondDialog;
import com.sysuptime.mainframe.performance.DevicesMonitorPane;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.WmiDevicesMonitorPane;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public abstract class ConciseSshMonitorSecondDialog
extends ConciseMonitorSecondDialog {
    private WmiDevicesMonitorPane _sshMonitorMonitorPane;
    private long _hostId;
    private int _timeout;
    private String _sshCommand;
    private String _sshMonitor;
    private static final Logger _logger = Logger.getLogger((String)ConciseSshMonitorSecondDialog.class.getName());

    public ConciseSshMonitorSecondDialog(boolean bl2, String string, DevicesMonitorPane devicesMonitorPane, DefaultTableModel defaultTableModel, long l2, int n2, String string2, NameValuePair nameValuePair) {
        super(bl2, string, devicesMonitorPane, defaultTableModel);
        this.setMonitorName(string2);
        this._sshMonitorMonitorPane = (WmiDevicesMonitorPane)devicesMonitorPane;
        this._hostId = l2;
        this._timeout = n2;
        this._sshCommand = (String)nameValuePair.getValue();
        this._sshMonitor = String.valueOf(nameValuePair.getName());
        this._sshMonitorMonitorPane.setThresholdCondition(DialogConstants.BELOW);
    }

    @Override
    protected HashMap getTestRunParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        List list = this.createMonitors();
        String string = "";
        hashMap.put("allMonitors", list);
        hashMap.put("showHost", "false");
        hashMap.put("ipAddress", string);
        return hashMap;
    }

    @Override
    protected boolean selectOneCheck() {
        if (this._sshMonitorMonitorPane.getAllSelectedCheckBoxKey2DescrMap() == null || !this._sshMonitorMonitorPane.getAllSelectedCheckBoxKey2DescrMap().isEmpty()) {
            return true;
        }
        JOptionPane.showMessageDialog(this, ConciseSshMonitorSecondDialog.fromBundle("MSG_select_one_device_error"));
        return false;
    }

    @Override
    protected void doOk() {
        List list = this.createMonitors();
        super.doOk(list);
    }

    private List createMonitors() {
        ArrayList<Monitor> arrayList = new ArrayList<Monitor>();
        Map map = this._sshMonitorMonitorPane.getAllSelectedCheckBoxKey2DescrMap();
        if (map != null) {
            ArrayList arrayList2 = new ArrayList(map.keySet());
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = String.valueOf(arrayList2.get(i2));
                String string2 = this.getScheduleName(string);
                Monitor monitor = this.createSingleMonitor(string2, string);
                if (monitor == null) continue;
                arrayList.add(monitor);
            }
        } else {
            String string = this.getMonitorName();
            Monitor monitor = this.createSingleMonitor(string, null);
            if (monitor != null) {
                arrayList.add(monitor);
            }
        }
        return arrayList;
    }

    protected String getScheduleName(String string) {
        return this.getMonitorName() + "-" + string;
    }

    private Monitor createSingleMonitor(String string, String string2) {
        try {
            Monitor monitor = TargetFactory.getSchedule();
            monitor.setScheduleName(string);
            ServiceNameElement serviceNameElement = new ServiceNameElement("server", "SSH", "SSH", "SSH_CUSTOM_COMMAND", "SSH Command");
            short s2 = MonitorHelper.getConstantId("SSH").shortValue();
            this.setMonitorCommonValue(monitor, serviceNameElement, s2);
            this.setMonitorQueryParameter(monitor, string2);
            Long l2 = this.getPollingInterval(monitor);
            if (l2 == null) {
                return null;
            }
            monitor.setPeriod(l2);
            String string3 = this._sshMonitorMonitorPane.getThresholdResult().trim();
            String string4 = "SSH_CONTENT_MATCH";
            QueryParameter queryParameter = MonitorHelper.getConfigThresholdParameterClass(monitor.getProtocolType(), "SSH_CONTENT_MATCH");
            short s3 = Short.parseShort(this._sshMonitorMonitorPane.getAlarmBreakText().trim());
            short s4 = this._sshMonitorMonitorPane.getThresholdConditionIndex();
            this.setFixedThreshold(monitor, string3, string4, queryParameter, s3, s4);
            String string5 = this._sshMonitorMonitorPane.getAction();
            if (string5 != null && string5.trim().length() != 0) {
                monitor.setActions(string5);
            }
            monitor.setSaved(true);
            return monitor;
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return null;
        }
    }

    @Override
    protected List setMetricsParameter() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<ArrayList<String>> arrayList2 = new ArrayList<ArrayList<String>>();
        arrayList.add("0");
        arrayList2.add(arrayList);
        arrayList = new ArrayList();
        boolean bl2 = Pattern.compile("process").matcher(this._sshMonitor).find();
        if (bl2) {
            arrayList.add("1");
        } else {
            arrayList.add("0");
            if (Pattern.compile("Solaris_memory").matcher(this._sshMonitor).find()) {
                arrayList.add("1");
                arrayList.add("1");
            } else {
                arrayList.add("-1");
                arrayList.add("-1");
            }
            arrayList.add("$whitespace");
        }
        arrayList2.add(arrayList);
        return arrayList2;
    }

    private void setMonitorQueryParameter(Monitor monitor, String string) {
        short s2 = monitor.getProtocolType();
        QueryParameter queryParameter = null;
        try {
            queryParameter = MonitorHelper.getMetricsParameterClass(s2);
            queryParameter.add(String.valueOf(this._hostId));
            queryParameter.add(this._sshCommand);
            queryParameter.add(String.valueOf(this._timeout));
            List list = this.getOtherParameter(string);
            if (list != null && list.size() > 0) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    String string2 = (String)list.get(i2);
                    queryParameter.add(string2);
                }
            }
            monitor.setQueryParameters(queryParameter);
            IProtocolHost iProtocolHost = MonitorHelper.getDisableHostClass(monitor.getProtocolType());
            monitor.addScheduleHost(iProtocolHost.getHost(monitor.getQueryParameters(), ClientProxy.getInstance().getProbe().getId()));
        }
        catch (Exception exception) {
            _logger.error((Object)exception.getMessage(), (Throwable)exception);
            return;
        }
    }

    protected List getOtherParameter(String string) {
        return null;
    }

    private static String fromBundle(String string) {
        return NbBundle.getMessage(ConciseSshMonitorSecondDialog.class, (String)string);
    }

    protected void setSshCommand(String string) {
        this._sshCommand = string;
    }
}

