/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.ireasoning.util.MessageParser;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.CommandVarProcessor;
import com.openapi.performance.DefaultProtocolDialog;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.DialogConstants;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FileDialog
extends DefaultProtocolDialog {
    private JTextField _fileComponent;
    private JButton _fileValidator;
    private JButton _savedFileValidator;
    private JComboBox _changes;
    private JLabel _filePath;
    private JPanel _panel;
    private JTextField _saved;
    private ValidatorAction _action = new ValidatorAction();

    public FileDialog(JDialog jDialog, String string, boolean bl2) {
        super(jDialog, string, bl2);
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        String string2 = Snippet.getBundledString(string);
        JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
        if (string.equalsIgnoreCase("file")) {
            this.appendFileValdator(defaultFormBuilder, jComponent, string2);
        } else if (string.equalsIgnoreCase("check_changes")) {
            this.appendSavedFileValidator(defaultFormBuilder, jComponent, string2);
        } else {
            defaultFormBuilder.append(string2, (Component)jComponent);
            defaultFormBuilder.append(this.getLineEnd(queryParameterElement));
        }
        return n2;
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        super.initParameterData(queryParameter);
        if (this._changes.getSelectedIndex() == this._changes.getModel().getSize() - 1) {
            this._saved.setText(queryParameter.get(queryParameter.size() - 1).toString());
            this._saved.setCaretPosition(0);
            this._saved.setToolTipText(_bundle.getString("tooltip_file"));
        }
    }

    private void appendSavedFileValidator(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        defaultFormBuilder.append(string);
        this._changes = (JComboBox)jComponent;
        defaultFormBuilder.append((Component)this._changes);
        this._filePath = new JLabel(_bundle.getString("file_path"));
        defaultFormBuilder.append((Component)this._filePath);
        this._panel = new JPanel(new FlowLayout());
        this._saved = new JTextField();
        this._saved.setPreferredSize(DialogConstants.LONG_SIZE);
        this._panel.add(this._saved);
        this._savedFileValidator = new JButton(_bundle.getString("checkpath"));
        this._savedFileValidator.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._savedFileValidator.addActionListener(this._action);
        this._panel.add(this._savedFileValidator);
        defaultFormBuilder.append((Component)this._panel);
        this.setVisibleChanges(false);
        this._changes.addItemListener(new ChangesItem());
    }

    private void appendFileValdator(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        this._fileComponent = (JTextField)jComponent;
        defaultFormBuilder.append(string);
        defaultFormBuilder.append((Component)this._fileComponent);
        this._fileValidator = new JButton(_bundle.getString("checkpath"));
        this._fileValidator.setPreferredSize(DialogConstants.OPERATE_SIZE);
        this._fileValidator.addActionListener(this._action);
        defaultFormBuilder.append((Component)this._fileValidator);
    }

    @Override
    protected boolean checkParameter() {
        this._tmpParameters.clear();
        List list = this.getValidatedParametersValues();
        if (list == null) {
            return false;
        }
        if (this._changes.getSelectedIndex() == this._changes.getModel().getSize() - 1 && this._saved.getText().length() == 0) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_importsavedfile"));
            return false;
        }
        this._tmpParameters.addAll(list);
        this._tmpParameters.add(this._saved.getText());
        return true;
    }

    private void setVisibleChanges(boolean bl2) {
        this._filePath.setVisible(bl2);
        this._panel.setVisible(bl2);
        this.setSize(this.getPreferredSize());
    }

    private void doSavedValidator() {
        File file = new File(MessageParser.parseMessage(this._saved.getText(), CommandVarProcessor.getVars()));
        if (file.exists()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_comparedfileexist"));
        } else {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_comparedfilenotexist"), "", 2);
        }
    }

    private void doFileValidator() {
        File file = new File(MessageParser.parseMessage(this._fileComponent.getText(), CommandVarProcessor.getVars()));
        if (file.exists()) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_fileexist"));
        } else {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_filenotexist"), "", 2);
        }
    }

    private class ValidatorAction
    implements ActionListener {
        private ValidatorAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(FileDialog.this._fileValidator)) {
                FileDialog.this.doFileValidator();
            } else if (object.equals(FileDialog.this._savedFileValidator)) {
                FileDialog.this.doSavedValidator();
            }
        }
    }

    private class ChangesItem
    implements ItemListener {
        private ChangesItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(FileDialog.this._changes)) {
                if (FileDialog.this._changes.getSelectedIndex() == FileDialog.this._changes.getModel().getSize() - 1) {
                    FileDialog.this.setVisibleChanges(true);
                } else {
                    FileDialog.this.setVisibleChanges(false);
                }
            }
        }
    }
}

