/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.common.performance.Timebucket;
import com.sysuptime.common.performance.TimebucketItem;
import com.sysuptime.common.trapreceiver.ITrapConstants;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.MetricsTimebucketTableCell;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.ReadOnlyTableModel;
import com.sysuptime.mainframe.performance.SelectionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import com.sysuptime.mainframe.performance.TimebucketActionDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class FixedThresholdDialog
extends TimebucketActionDialog {
    private ThresholdPanel[] _severities;
    private String _localeMetrics;
    private int _nonComparedIndex;
    private String _timebucketName;
    private ReadOnlyTableModel _thresholdModel;
    private String _unit;
    private boolean _isClearAlarm;
    private static final String MESSAGE_THRESHOLD_ARM = _bundle.getString("message_armthreshold");
    private static final String MESSAGE_THRESHOLD_REARM = _bundle.getString("message_rearmthreshold");
    private static final String LABEL_THRESHOLD = _bundle.getString("threshold");

    public FixedThresholdDialog(Dialog dialog, String string, boolean bl2, ReadOnlyTableModel readOnlyTableModel, int n2, String string2, String string3, boolean bl3) {
        super(dialog, string, bl2);
        this.initTimebucketThreshold(readOnlyTableModel, n2, string2, string3, bl3);
        this.initComponents();
        this.initUserData();
    }

    public void initTimebucketThreshold(ReadOnlyTableModel readOnlyTableModel, int n2, String string, String string2, boolean bl2) {
        this._localeMetrics = string;
        this._nonComparedIndex = n2;
        this._thresholdModel = readOnlyTableModel;
        this._unit = string2;
        this._isClearAlarm = bl2;
    }

    private void initComponents() {
        this.setResizable(false);
        Container container = this.getContentPane();
        container.add((Component)this.getConfigPanel(), "North");
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getConfigPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g", "p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(this.getConfigLabel(), cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.getConfigBox(), cellConstraints.xy(3, 1));
        return panelBuilder.getPanel();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p:g", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        int n2 = this._thresholdModel.getColumnCount() - 1;
        this._severities = new ThresholdPanel[n2];
        if (this._isClearAlarm) {
            this._severities[0] = new ThresholdPanel(DialogConstants.LABEL_THRESHOLD);
            panelBuilder.add((Component)this._severities[0].getPanel(), cellConstraints.xy(1, 1));
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                this._severities[i2] = new ThresholdPanel(ITrapConstants.SEVERITY_STRINGS[i2]);
                panelBuilder.add((Component)this._severities[i2].getPanel(), cellConstraints.xy(1, 2 * i2 + 1));
            }
        }
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        if (this._nonComparedIndex != -1) {
            this.initSeveritiesData();
        }
    }

    private void initSeveritiesData() {
        Object object = this._thresholdModel.getValueAt(this._nonComparedIndex, 0);
        this.getTimebucketBox().setSelectedItem(object);
        int n2 = this._thresholdModel.getColumnCount();
        for (int i2 = 1; i2 < n2; ++i2) {
            Object object2 = this._thresholdModel.getValueAt(this._nonComparedIndex, i2);
            this.initCell(object2, i2 - 1);
        }
    }

    private void initCell(Object object, int n2) {
        MetricsTimebucketTableCell metricsTimebucketTableCell;
        short s2;
        if (object instanceof MetricsTimebucketTableCell && (s2 = (metricsTimebucketTableCell = (MetricsTimebucketTableCell)object).getConditionId()) != -1) {
            this._severities[n2]._fixedConditions.setSelectedItem(metricsTimebucketTableCell.getCondition());
            this._severities[n2]._fixedThreshold.setText(String.valueOf(metricsTimebucketTableCell.getThreshold()));
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkTimebucketThreshold()) {
            this.operateTimebucketThreshold();
            this.dispose();
        }
    }

    private boolean checkTimebucketThreshold() {
        JComboBox jComboBox = this.getTimebucketBox();
        int n2 = jComboBox.getSelectedIndex();
        Object object = SingletonValidator.checkAllDialog(this, DialogConstants.LABEL_TIMEBUCKET, n2, SelectionValidator.CLASS);
        if (object == null) {
            return false;
        }
        int n3 = this._severities.length;
        String[] stringArray = new String[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            stringArray[i2] = this._severities[i2]._fixedThreshold.getText();
        }
        if (!this.checkFixed(stringArray)) {
            return false;
        }
        this._timebucketName = (String)jComboBox.getItemAt(n2);
        if (!this._isClearAlarm && this.isLapped()) {
            JOptionPane.showMessageDialog(this, DialogConstants.MESSAGE_TIMEBUCKET_LAP);
            return false;
        }
        return true;
    }

    private boolean checkFixed(String[] stringArray) {
        int n2 = 0;
        int n3 = stringArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (stringArray[i2].length() != 0) {
                short s2 = (short)this._severities[i2]._fixedConditions.getSelectedIndex();
                Object object = null;
                if (s2 != 3 && s2 != 6) {
                    object = SingletonValidator.checkAllDialog(this, LABEL_THRESHOLD, stringArray[i2], NumberValidator.CLASS);
                    if (object == null) {
                        return false;
                    }
                } else {
                    object = stringArray[i2];
                }
                this._severities[i2]._fixedConditionId = s2;
                this._severities[i2]._checkedFixedThreshold = String.valueOf(object);
                continue;
            }
            ++n2;
        }
        if (n2 == n3) {
            if (this._isClearAlarm) {
                JOptionPane.showMessageDialog(this, MESSAGE_THRESHOLD_REARM);
            } else {
                JOptionPane.showMessageDialog(this, MESSAGE_THRESHOLD_ARM);
            }
            return false;
        }
        return true;
    }

    private boolean isLapped() {
        Timebucket timebucket = (Timebucket)this._timebucketNameToObject.get(this._timebucketName);
        int n2 = this._thresholdModel.getRowCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string;
            Timebucket timebucket2;
            if (i2 == this._nonComparedIndex || !this.isTimebucketLapped(timebucket2 = (Timebucket)this._timebucketNameToObject.get(string = (String)this._thresholdModel.getValueAt(i2, 0)), timebucket)) continue;
            return true;
        }
        return false;
    }

    private boolean isTimebucketLapped(Timebucket timebucket, Timebucket timebucket2) {
        int n2 = timebucket.getTimebucketItemListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimebucketItem timebucketItem = timebucket.getTimebucketItem(i2);
            if (!this.isTimebucketItemLapped(timebucketItem, timebucket2)) continue;
            return true;
        }
        return false;
    }

    private boolean isTimebucketItemLapped(TimebucketItem timebucketItem, Timebucket timebucket) {
        int n2 = timebucket.getTimebucketItemListSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            TimebucketItem timebucketItem2 = timebucket.getTimebucketItem(i2);
            if (!this.comparedTimebucketItems(timebucketItem2, timebucketItem)) continue;
            return true;
        }
        return false;
    }

    private boolean comparedTimebucketItems(TimebucketItem timebucketItem, TimebucketItem timebucketItem2) {
        short s2 = timebucketItem.getEndDayId();
        if (s2 < timebucketItem2.getStartDayId() || s2 == timebucketItem2.getStartDayId() && timebucketItem.getEndTime() < timebucketItem2.getStartTime()) {
            return false;
        }
        short s3 = timebucketItem.getStartDayId();
        return s3 <= timebucketItem2.getEndDayId() && (s3 != timebucketItem2.getEndDayId() || timebucketItem.getStartTime() <= timebucketItem2.getEndTime());
    }

    private void operateTimebucketThreshold() {
        int n2;
        int n3 = this._thresholdModel.getColumnCount();
        Object[] objectArray = new Object[n3];
        objectArray[0] = this._timebucketName;
        for (n2 = 1; n2 < n3; ++n2) {
            MetricsTimebucketTableCell metricsTimebucketTableCell = null;
            if (this._severities[n2 - 1]._fixedConditionId != -1) {
                metricsTimebucketTableCell = new MetricsTimebucketTableCell(this._severities[n2 - 1]._fixedConditionId, (String)this._severities[n2 - 1]._fixedConditions.getSelectedItem(), this._severities[n2 - 1]._checkedFixedThreshold);
            }
            objectArray[n2] = metricsTimebucketTableCell;
        }
        if (this._nonComparedIndex == -1) {
            this._thresholdModel.addRow(objectArray);
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                this._thresholdModel.setValueAt(objectArray[n2], this._nonComparedIndex, n2);
            }
        }
    }

    private class ThresholdPanel {
        private PanelBuilder _builder;
        private JComboBox _fixedConditions;
        private JTextField _fixedThreshold;
        private short _fixedConditionId = (short)-1;
        private String _checkedFixedThreshold;

        public ThresholdPanel(String string) {
            FormLayout formLayout = new FormLayout("l:p,3dlu,p,3dlu,p,3dlu,p", "p");
            this._builder = new PanelBuilder(formLayout);
            this._builder.setBorder((Border)new TitledBorder(string));
            CellConstraints cellConstraints = new CellConstraints();
            this._builder.addLabel(FixedThresholdDialog.this._localeMetrics, cellConstraints.xy(1, 1));
            this._fixedConditions = new JComboBox<String>(DialogConstants.COMBOBOX_FIXED_CONDITION);
            this._fixedConditions.setPreferredSize(DialogConstants.SHORT_SIZE);
            this._builder.add((Component)this._fixedConditions, cellConstraints.xy(3, 1));
            this._fixedThreshold = new JTextField();
            this._fixedThreshold.setPreferredSize(DialogConstants.LONG_SIZE);
            this._builder.add((Component)this._fixedThreshold, cellConstraints.xy(5, 1));
            this._builder.addLabel(FixedThresholdDialog.this._unit, cellConstraints.xy(7, 1));
        }

        public JPanel getPanel() {
            return this._builder.getPanel();
        }
    }
}

