/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.ContentMatchParameterDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.LineTokenCell;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.RepetitionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class LineTokenDialog
extends ConfirmDialog {
    private ContentMatchParameterDialog _owner;
    private JTextField _var;
    private JTextField _line;
    private JTextField _token;
    private JTextField _delimiter;
    private boolean _isAdded;

    public LineTokenDialog(JDialog jDialog, String string, boolean bl2, boolean bl3) {
        super(jDialog, string, bl2);
        this.initFormItem(jDialog, bl3);
        this.initComponents();
        this.initUserData();
    }

    private void initFormItem(JDialog jDialog, boolean bl2) {
        this._owner = (ContentMatchParameterDialog)jDialog;
        this._isAdded = bl2;
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g", "p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(_bundle.getString("variable"), cellConstraints.xy(1, 1));
        this._var = new JTextField();
        this._var.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._var, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(_bundle.getString("line"), cellConstraints.xy(1, 3));
        this._line = new JTextField("-1");
        this._line.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._line, cellConstraints.xy(3, 3));
        panelBuilder.addLabel(_bundle.getString("token") + DialogConstants.LABEL_ISOPTIONAL, cellConstraints.xy(1, 5));
        this._token = new JTextField("-1");
        this._token.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._token, cellConstraints.xy(3, 5));
        panelBuilder.addLabel(_bundle.getString("delimiter"), cellConstraints.xy(1, 7));
        this._delimiter = new JTextField("$whitespace");
        this._delimiter.setPreferredSize(DialogConstants.LONG_SIZE);
        this._delimiter.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
        this._line.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_line_tooltip"));
        this._token.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_token_tooltip"));
        panelBuilder.add((Component)this._delimiter, cellConstraints.xy(3, 7));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        if (!this._isAdded) {
            Object[] objectArray = this._owner.getExprSelectedLineToken();
            this._var.setText(String.valueOf(objectArray[0]));
            LineTokenCell lineTokenCell = (LineTokenCell)objectArray[1];
            this._line.setText(lineTokenCell.getLine());
            this._token.setText(lineTokenCell.getToken());
            this._delimiter.setText(lineTokenCell.getDelimiter());
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkLineToken()) {
            this._owner.operateExpr(new LineTokenCell(this._line.getText(), this._token.getText(), this._delimiter.getText(), 0, null), this._var.getText(), this._isAdded);
            this.dispose();
        }
    }

    private boolean checkLineToken() {
        Object object = SingletonValidator.checkAllDialog(this, _bundle.getString("variable"), this._var.getText(), NonNullValidator.CLASS);
        if (object == null) {
            return false;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, _bundle.getString("line"), this._line.getText(), RepetitionValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        Object object3 = SingletonValidator.checkAllDialog(this, _bundle.getString("token"), this._token.getText(), RepetitionValidator.CLASS);
        if (object3 == null) {
            return false;
        }
        Object object4 = SingletonValidator.checkAllDialog(this, _bundle.getString("delimiter"), this._delimiter.getText(), NonNullValidator.CLASS);
        if (object4 == null) {
            return false;
        }
        if (this._owner.isLappedExpr(this._var.getText(), this._isAdded)) {
            JOptionPane.showMessageDialog(this, _bundle.getString("message_exprlap"));
            return false;
        }
        return true;
    }
}

