/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.ContentMatchParameterDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.LineTokenCell;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.NumberValidator;
import com.sysuptime.mainframe.performance.RepetitionValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.NbBundle;

public class MultiConditionDialog
extends ConfirmDialog {
    private ContentMatchParameterDialog _owner;
    private JTextField _line;
    private JTextField _token;
    private JTextField _delimiter;
    private JComboBox _conditionsBox;
    private JTextField _threshold;
    private boolean _isAdded;
    private int _checkedCondition;

    public MultiConditionDialog(JDialog jDialog, String string, boolean bl2, boolean bl3) {
        super(jDialog, string, bl2);
        this.initFormItem(jDialog, bl3);
        this.initComponents();
        this.initUserData();
    }

    private void initFormItem(JDialog jDialog, boolean bl2) {
        this._owner = (ContentMatchParameterDialog)jDialog;
        this._isAdded = bl2;
    }

    private void initComponents() {
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel(_bundle.getString("line"), cellConstraints.xy(1, 1));
        this._line = new JTextField("-1");
        this._line.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._line, cellConstraints.xy(3, 1));
        panelBuilder.addLabel(_bundle.getString("token") + DialogConstants.LABEL_ISOPTIONAL, cellConstraints.xy(1, 3));
        this._token = new JTextField("-1");
        this._token.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._token, cellConstraints.xy(3, 3));
        panelBuilder.addLabel(_bundle.getString("delimiter"), cellConstraints.xy(1, 5));
        this._delimiter = new JTextField("$whitespace");
        this._delimiter.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_delimiter_tooltip"));
        this._line.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_line_tooltip"));
        this._token.setToolTipText(NbBundle.getMessage(ContentMatchParameterDialog.class, (String)"content_match_token_tooltip"));
        this._delimiter.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._delimiter, cellConstraints.xy(3, 5));
        panelBuilder.addLabel(_bundle.getString("condition"), cellConstraints.xy(1, 7));
        this._conditionsBox = new JComboBox<String>(DialogConstants.COMBOBOX_FIXED_CONDITION);
        this._conditionsBox.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._conditionsBox, cellConstraints.xy(3, 7));
        this._conditionsBox.setSelectedItem(DialogConstants.INCLUDE);
        panelBuilder.addLabel(_bundle.getString("column_value"), cellConstraints.xy(1, 9));
        this._threshold = new JTextField();
        this._threshold.setPreferredSize(DialogConstants.LONG_SIZE);
        panelBuilder.add((Component)this._threshold, cellConstraints.xy(3, 9));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        if (!this._isAdded) {
            LineTokenCell lineTokenCell = this._owner.getMultiSelectedLineToken();
            this._line.setText(lineTokenCell.getLine());
            this._token.setText(lineTokenCell.getToken());
            this._delimiter.setText(lineTokenCell.getDelimiter());
            this._conditionsBox.setSelectedIndex(lineTokenCell.getCondition());
            this._threshold.setText(lineTokenCell.getThreshold());
        }
    }

    @Override
    protected void okDialog() {
        if (this.checkMultiCondition()) {
            this._owner.operateMulti(new LineTokenCell(this._line.getText(), this._token.getText(), this._delimiter.getText(), this._checkedCondition, this._threshold.getText()), this._isAdded);
            this.dispose();
        }
    }

    private boolean checkMultiCondition() {
        Object object;
        Object object2;
        Object object3 = SingletonValidator.checkAllDialog(this, _bundle.getString("line"), this._line.getText(), RepetitionValidator.CLASS);
        if (object3 == null) {
            return false;
        }
        Object object4 = SingletonValidator.checkAllDialog(this, _bundle.getString("token"), this._token.getText(), RepetitionValidator.CLASS);
        if (object4 == null) {
            return false;
        }
        Object object5 = SingletonValidator.checkAllDialog(this, _bundle.getString("delimiter"), this._delimiter.getText(), NonNullValidator.CLASS);
        if (object5 == null) {
            return false;
        }
        int n2 = this._conditionsBox.getSelectedIndex();
        if (n2 != 3 && n2 != 6 ? (object2 = SingletonValidator.checkAllDialog(this, _bundle.getString("threshold"), this._threshold.getText(), NumberValidator.CLASS)) == null : (object = SingletonValidator.checkAllDialog(this, _bundle.getString("threshold"), this._threshold.getText(), NonNullValidator.CLASS)) == null) {
            return false;
        }
        this._checkedCondition = n2;
        return true;
    }
}

