/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.sysuptime.mainframe.msp.ClientProxy;
import com.sysuptime.mainframe.performance.ConfirmDialog;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.NonNullValidator;
import com.sysuptime.mainframe.performance.PositiveIntValidator;
import com.sysuptime.mainframe.performance.SingletonValidator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PerformanceConfigDialog
extends ConfirmDialog {
    private static final String TITLE = _bundle.getString("title_performanceconfigdialog");
    private static final String TITLE_RECORD = _bundle.getString("title_calculatestddev");
    private static final String MIN_RECORD = _bundle.getString("label_minrecord");
    private static final String MAX_RECORD = _bundle.getString("label_maxrecord");
    private static final String USER_AGENT = _bundle.getString("label_useragent");
    private static final String PROXY_HOST = _bundle.getString("label_proxyhost");
    private static final String PROXY_PORT = _bundle.getString("label_proxyport");
    private static final String MESSAGE_RECORD = _bundle.getString("message_record");
    private static final String MESSAGE_MINMAXRECORD = _bundle.getString("message_minmaxrecord");
    private JCheckBox _keepConnOpen;
    private JTextField _minRecords;
    private JTextField _maxRecords;
    private JTextField _userAgent;
    private JTextField _proxyHost;
    private JTextField _proxyPort;
    private Map _configProperties;

    public PerformanceConfigDialog(Frame frame, boolean bl2) {
        super(frame, TITLE, bl2);
        this.initComponents();
        this.initUserData();
    }

    public PerformanceConfigDialog(JDialog jDialog, boolean bl2) {
        super(jDialog, TITLE, bl2);
        this.initComponents();
        this.initUserData();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.add((Component)this.getBodyPanel(), "Center");
        container.add((Component)this.getConfirmPanel(), "South");
        this.pack();
    }

    private JPanel getBodyPanel() {
        FormLayout formLayout = new FormLayout("p,3dlu,p:g,5dlu,p,3dlu,p", "p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p,3dlu,p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        CellConstraints cellConstraints = new CellConstraints();
        this._keepConnOpen = new JCheckBox(_bundle.getString("label_keep_conn_open"));
        panelBuilder.add((Component)this._keepConnOpen, cellConstraints.xyw(1, 1, 7));
        panelBuilder.addLabel(USER_AGENT, cellConstraints.xy(1, 3));
        this._userAgent = new JTextField();
        this._userAgent.setPreferredSize(DialogConstants.URL_SIZE);
        panelBuilder.add((Component)this._userAgent, cellConstraints.xyw(3, 3, 5));
        panelBuilder.addLabel(PROXY_HOST, cellConstraints.xy(1, 5));
        this._proxyHost = new JTextField();
        this._proxyHost.setPreferredSize(DialogConstants.XLONG_SIZE);
        panelBuilder.add((Component)this._proxyHost, cellConstraints.xy(3, 5));
        panelBuilder.addLabel(PROXY_PORT, cellConstraints.xy(5, 5));
        this._proxyPort = new JTextField();
        this._proxyPort.setPreferredSize(DialogConstants.SHORT_SIZE);
        panelBuilder.add((Component)this._proxyPort, cellConstraints.xy(7, 5));
        panelBuilder.addSeparator("", cellConstraints.xyw(1, 7, 7));
        panelBuilder.addLabel(TITLE_RECORD, cellConstraints.xyw(1, 9, 7));
        panelBuilder.addLabel(MIN_RECORD, cellConstraints.xy(1, 11));
        this._minRecords = new JTextField();
        this._minRecords.setPreferredSize(DialogConstants.SHORT_SIZE);
        panelBuilder.add((Component)this._minRecords, cellConstraints.xyw(3, 11, 5));
        panelBuilder.addLabel(MAX_RECORD, cellConstraints.xy(1, 13));
        this._maxRecords = new JTextField();
        this._maxRecords.setPreferredSize(DialogConstants.SHORT_SIZE);
        panelBuilder.add((Component)this._maxRecords, cellConstraints.xyw(3, 13, 5));
        return panelBuilder.getPanel();
    }

    private void initUserData() {
        try {
            this._configProperties = ClientProxy.getInstance().getPerformanceConfig();
            this._keepConnOpen.setSelected("T".equals(this._configProperties.get("performance.keepConnectionOpen").toString().toUpperCase()));
            this._minRecords.setText(this._configProperties.get("performance.minRecords").toString());
            this._maxRecords.setText(this._configProperties.get("performance.maxRecords").toString());
            this._userAgent.setText(this._configProperties.get("performance.userAgent").toString());
            this._userAgent.setCaretPosition(0);
            this._proxyHost.setText(this._configProperties.get("performance.proxyHost").toString());
            this._proxyHost.setCaretPosition(0);
            this._proxyPort.setText(this._configProperties.get("performance.proxyPort").toString());
            this._proxyPort.setCaretPosition(0);
        }
        catch (Exception exception) {
            this._logger.error((Object)"performanceConfigDialog initUserData", (Throwable)exception);
        }
    }

    @Override
    protected void okDialog() {
        long l2 = ClientProxy.getInstance().getProbe().getId();
        if (!ClientProxy.getInstance().isActive(l2)) {
            return;
        }
        if (this.checkQueryResult()) {
            this._configProperties.put("performance.keepConnectionOpen", String.valueOf(this._keepConnOpen.isSelected()).substring(0, 1).toUpperCase());
            this._configProperties.put("performance.minRecords", this._minRecords.getText());
            this._configProperties.put("performance.maxRecords", this._maxRecords.getText());
            this._configProperties.put("performance.userAgent", this._userAgent.getText());
            this._configProperties.put("performance.proxyHost", this._proxyHost.getText());
            this._configProperties.put("performance.proxyPort", this._proxyPort.getText());
            try {
                ClientProxy.getInstance().updatePerformanceConfig(this._configProperties);
            }
            catch (Exception exception) {
                this._logger.error((Object)"performanceConfigDialog updatePerformanceConfig", (Throwable)exception);
            }
            this.dispose();
        }
    }

    private boolean checkQueryResult() {
        Object object;
        Number number = (Number)SingletonValidator.checkAllDialog(this, MIN_RECORD, this._minRecords.getText(), PositiveIntValidator.CLASS);
        if (number == null) {
            return false;
        }
        if (number.intValue() < 2) {
            JOptionPane.showMessageDialog(this, MESSAGE_RECORD);
            return false;
        }
        Number number2 = (Number)SingletonValidator.checkAllDialog(this, MAX_RECORD, this._maxRecords.getText(), PositiveIntValidator.CLASS);
        if (number2 == null) {
            return false;
        }
        if (number2.intValue() < 2) {
            JOptionPane.showMessageDialog(this, MESSAGE_RECORD);
            return false;
        }
        if (number.intValue() > number2.intValue()) {
            JOptionPane.showMessageDialog(this, MESSAGE_MINMAXRECORD);
            return false;
        }
        Object object2 = SingletonValidator.checkAllDialog(this, USER_AGENT, this._userAgent.getText(), NonNullValidator.CLASS);
        if (object2 == null) {
            return false;
        }
        return this._proxyPort.getText().trim().length() == 0 || (object = SingletonValidator.checkAllDialog(this, PROXY_PORT, this._proxyPort.getText(), PositiveIntValidator.CLASS)) != null;
    }
}

