/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.performance;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.openapi.performance.QueryParameterElement;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.WinEventLogHost;
import com.sysuptime.common.util.monitor.Snippet;
import com.sysuptime.mainframe.performance.DialogConstants;
import com.sysuptime.mainframe.performance.WmiDialog;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class WinEventLogDialog
extends WmiDialog {
    private JComboBox _logNames;
    private JTextField _userLog;

    @Override
    protected int getRemoteProtocol() {
        return WinEventLogHost.WIN_EVENT_LOG_ID;
    }

    public WinEventLogDialog(JDialog jDialog, String string, boolean bl2, long l2) {
        super(jDialog, string, bl2, l2);
    }

    @Override
    protected int appendParameterCompenent(DefaultFormBuilder defaultFormBuilder, CellConstraints cellConstraints, QueryParameterElement queryParameterElement, int n2) {
        String string = queryParameterElement.getName();
        if (string.equalsIgnoreCase("log_name")) {
            String string2 = Snippet.getBundledString(string);
            JComponent jComponent = this.getParameterComponent(queryParameterElement, string2);
            this.appendLog(defaultFormBuilder, jComponent, string2);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(Snippet.getBundledString("event_filter"));
            return n2;
        }
        super.appendParameterCompenent(defaultFormBuilder, cellConstraints, queryParameterElement, n2);
        return n2;
    }

    private void appendLog(DefaultFormBuilder defaultFormBuilder, JComponent jComponent, String string) {
        defaultFormBuilder.append(string);
        this._logNames = (JComboBox)jComponent;
        defaultFormBuilder.append((Component)this._logNames);
        this._userLog = new JTextField();
        this._userLog.setPreferredSize(DialogConstants.LONG_SIZE);
        defaultFormBuilder.append((Component)this._userLog);
        this.setVisibleChanges(false);
        this._logNames.addItemListener(new ChangesItem());
    }

    @Override
    protected void initParameterData(QueryParameter queryParameter) {
        super.initParameterData(queryParameter);
        if (this._logNames != null && this._logNames.getSelectedIndex() == this._logNames.getModel().getSize() - 1) {
            this._userLog.setText(queryParameter.get(queryParameter.size() - 1).toString());
            this._userLog.setCaretPosition(0);
        }
    }

    @Override
    protected boolean checkParameter() {
        boolean bl2 = super.checkRemoteHost();
        if (!bl2) {
            this._tmpParameters.clear();
            return false;
        }
        if (this._logNames != null) {
            if (this._logNames.getSelectedIndex() == this._logNames.getModel().getSize() - 1 && this._userLog.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, _bundle.getString("message_usertype"));
                return false;
            }
            this._tmpParameters.add(this._userLog.getText());
        }
        return true;
    }

    private void setVisibleChanges(boolean bl2) {
        this._userLog.setVisible(bl2);
        this.setSize(this.getPreferredSize());
    }

    private class ChangesItem
    implements ItemListener {
        private ChangesItem() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            ItemSelectable itemSelectable = itemEvent.getItemSelectable();
            if (itemEvent.getStateChange() == 1 && itemSelectable.equals(WinEventLogDialog.this._logNames)) {
                if (WinEventLogDialog.this._logNames.getSelectedIndex() == WinEventLogDialog.this._logNames.getModel().getSize() - 1) {
                    WinEventLogDialog.this.setVisibleChanges(true);
                } else {
                    WinEventLogDialog.this.setVisibleChanges(false);
                }
            }
        }
    }
}

