/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.mainframe.util;

import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.mainframe.util.TimeStampConstants;
import com.sysuptime.mainframe.util.TimeStampXMLReader;
import com.sysuptime.mainframe.util.TimeStampXMLWriter;
import java.io.File;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public final class GraphProperties
implements TimeStampConstants {
    private static GraphProperties _instance = new GraphProperties();
    private Map _graphProperties = null;

    private GraphProperties() {
        File file = new File(TOPO_PROPERTIES);
        String string = null;
        if (file.exists()) {
            string = FileUtil.readFile(TOPO_PROPERTIES);
            this._graphProperties = TimeStampXMLReader.read(string);
        } else {
            this._graphProperties = new HashMap();
            this.saveGraphProperties();
        }
    }

    public static GraphProperties getInstance() {
        return _instance;
    }

    public Map getGraphProperties() {
        return this._graphProperties;
    }

    public Timestamp getTimeStamp(GraphID graphID) {
        String string = (String)this._graphProperties.get(graphID);
        if (string != null) {
            return Timestamp.valueOf(string);
        }
        return null;
    }

    public void setTimestamp(GraphID graphID, Timestamp timestamp) {
        this._graphProperties.put(graphID, timestamp.toString());
    }

    public Object remove(GraphID graphID) {
        return this._graphProperties.remove(graphID);
    }

    public String getClientIconTimeStamp() {
        Object object = this._graphProperties.get("icontimestamp");
        if (object == null) {
            object = "";
        }
        return String.valueOf(object);
    }

    public void setClientIconTimeStamp(String string) {
        this._graphProperties.put("icontimestamp", string);
    }

    public boolean saveGraphProperties() {
        return TimeStampXMLWriter.write(this._graphProperties);
    }
}

