/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.discovery;

import com.ireasoning.protocol.snmp.SnmpSession;
import com.ireasoning.protocol.snmp.m;
import com.sysuptime.common.discovery.DeviceOption;
import com.sysuptime.common.discovery.NodeOption;
import com.sysuptime.common.discovery.ReadCommunity;
import com.sysuptime.common.discovery.V3Params;
import com.sysuptime.common.graph.GraphID;
import com.sysuptime.common.graph.GraphModelXMLReader;
import com.sysuptime.common.graph.NetworkGraphModel;
import com.sysuptime.common.model.ModelUtil;
import com.sysuptime.common.model.NetworkNode;
import com.sysuptime.common.model.NetworkNodeBean;
import com.sysuptime.common.model.TopologyData;
import com.sysuptime.common.util.callback.CallbackServer;
import com.sysuptime.server.discovery.ActiveDeviceChecker;
import com.sysuptime.server.discovery.DeviceInfoParse;
import com.sysuptime.server.discovery.DiscoveryOptions;
import com.sysuptime.server.discovery.GraphDao;
import com.sysuptime.server.discovery.NetworkNodeFactory;
import com.sysuptime.server.discovery.NodeUpdater;
import com.sysuptime.server.util.SystemStatus;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.jgraph.graph.AttributeMap;

public class DeviceUpdater
implements NodeUpdater {
    private static final Logger _logger = Logger.getLogger((String)NodeUpdater.class.getName());

    @Override
    public boolean update(NodeOption nodeOption) {
        DeviceOption deviceOption = (DeviceOption)nodeOption;
        DeviceInfoParse.getInstance().parseDataFile();
        NetworkNodeFactory networkNodeFactory = new NetworkNodeFactory(nodeOption);
        NetworkNodeBean networkNodeBean = networkNodeFactory.createNetworkNode(this.a(deviceOption));
        ActiveDeviceChecker activeDeviceChecker = new ActiveDeviceChecker();
        activeDeviceChecker.completeMac(networkNodeBean);
        TopologyData topologyData = GraphDao.createData();
        NetworkNodeBean networkNodeBean2 = topologyData.getBean(deviceOption.getId());
        NetworkGraphModel[] networkGraphModelArray = this.a(topologyData, networkNodeBean2, networkNodeBean, deviceOption);
        if (!deviceOption.isCleanDiscovery()) {
            ModelUtil.updateBean(networkNodeBean2, networkNodeBean);
        }
        topologyData.setBean(networkNodeBean);
        GraphDao.saveData(topologyData);
        this.a(networkGraphModelArray);
        CallbackServer.getInstance().notifyAllClients(SystemStatus.getCurrentClient(), "GraphLoaderProxy", "askToLoadNewData", null, null);
        return true;
    }

    private void a(NetworkGraphModel[] networkGraphModelArray) {
        boolean bl2 = DiscoveryOptions.d();
        for (int i2 = 0; i2 < networkGraphModelArray.length; ++i2) {
            if (networkGraphModelArray[i2] == null) continue;
            GraphDao.saveGraph(networkGraphModelArray[i2], ModelUtil.getGraphType(networkGraphModelArray[i2]));
            if (!bl2) continue;
        }
    }

    private NetworkGraphModel[] a(TopologyData topologyData, NetworkNodeBean networkNodeBean, NetworkNodeBean networkNodeBean2, DeviceOption deviceOption) {
        List<GraphID> list = networkNodeBean.getAttachedGraphs();
        NetworkGraphModel[] networkGraphModelArray = new NetworkGraphModel[list.size()];
        boolean bl2 = DiscoveryOptions.c();
        int n2 = networkGraphModelArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            NetworkNode networkNode;
            GraphID graphID = list.get(i2);
            NetworkGraphModel networkGraphModel = this.a(topologyData, graphID);
            if (networkGraphModel != null && (networkNode = networkGraphModel.getNodeByBean(networkNodeBean)) != null) {
                ModelUtil.updateConnections(networkGraphModel, networkNode, networkNodeBean2);
                networkGraphModel.remove(new Object[]{networkNode});
                AttributeMap attributeMap = networkNode.getAttributes();
                NetworkNode networkNode2 = new NetworkNode(networkNodeBean2);
                networkNode2.setAttributes(attributeMap);
                if (!deviceOption.isCleanDiscovery()) {
                    networkNode2.setCurrentDefaultIcon(networkNode.getCurrentDefaultIcon());
                }
                networkGraphModel.insert(new Object[]{networkNode2}, null, null, null, null);
            }
            networkGraphModelArray[i2] = networkGraphModel;
            if (bl2) continue;
        }
        return networkGraphModelArray;
    }

    private NetworkGraphModel a(TopologyData topologyData, GraphID graphID) {
        String string = GraphDao.getGraph(graphID);
        if (string != null) {
            NetworkGraphModel networkGraphModel = GraphModelXMLReader.read(string, topologyData);
            networkGraphModel.setID(graphID);
            return networkGraphModel;
        }
        return null;
    }

    private SnmpSession a(DeviceOption deviceOption) {
        SnmpSession snmpSession;
        block4: {
            snmpSession = null;
            ReadCommunity readCommunity = deviceOption.getReadCommunity();
            m m2 = new m(deviceOption.getIP(), 161);
            try {
                snmpSession = new SnmpSession(m2);
                try {
                    snmpSession.setRetries(0);
                    snmpSession.setTimeout(deviceOption.getTimeout());
                    if (readCommunity == null) break block4;
                    ((m)snmpSession.getTarget()).setPort(readCommunity.getPort());
                    ((m)snmpSession.getTarget()).setReadCommunity(readCommunity.getCommunity());
                    snmpSession.setVersion(readCommunity.getVersion());
                    if (readCommunity.getVersion() != 3) break block4;
                }
                catch (IOException iOException) {
                    throw DeviceUpdater.a(iOException);
                }
                V3Params v3Params = readCommunity.getV3Params();
                snmpSession.setV3Params(v3Params.getUserName(), v3Params.getAuthProtocol(), v3Params.getAuthPassword(), v3Params.getPrivProtocol(), v3Params.getPrivPassword());
            }
            catch (IOException iOException) {
                _logger.error((Object)"createSession", (Throwable)iOException);
            }
        }
        return snmpSession;
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

