/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.server.performance.SharedReader;
import com.sysuptime.server.util.DefaultConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class RemoteHostWriter {
    private static long _pk = -1L;
    private static Logger _logger = Logger.getLogger((String)RemoteHostWriter.class.getName());

    private RemoteHostWriter() {
    }

    private static void a() {
        if (++_pk >= Long.MAX_VALUE) {
            _pk = 0L;
        }
    }

    private static long b() {
        return _pk;
    }

    public static void storeRemoteHost(Connection connection, RemoteHost remoteHost) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "INSERT INTO PM_REMOTE_HOST (HOST_ID_C, HOST_NAME_C, PROTOCOL_C, USER_NAME_C, PARAMETER_C) VALUES (?,?,?,?,?)";
            preparedStatement = connection.prepareStatement(string);
            RemoteHostWriter.a();
            remoteHost.setHostId(RemoteHostWriter.b());
            preparedStatement.setLong(1, RemoteHostWriter.b());
            preparedStatement.setString(2, remoteHost.getHostName());
            preparedStatement.setInt(3, remoteHost.getProtocol());
            preparedStatement.setString(4, remoteHost.getUser());
            preparedStatement.setString(5, remoteHost.getParaToText());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Store pm_schedule data " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void updateRemoteHost(Connection connection, RemoteHost remoteHost) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "UPDATE PM_REMOTE_HOST SET HOST_NAME_C=?, USER_NAME_C=?, PARAMETER_C=? WHERE HOST_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setString(1, remoteHost.getHostName());
            preparedStatement.setString(2, remoteHost.getUser());
            preparedStatement.setString(3, remoteHost.getParaToText());
            preparedStatement.setLong(4, remoteHost.getHostId());
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Update pm_remote_host" + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    public static void deleteRemoteHost(Connection connection, long l2) throws SQLException {
        PreparedStatement preparedStatement = null;
        try {
            String string = "DELETE FROM PM_REMOTE_HOST WHERE HOST_ID_C=?";
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, l2);
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            try {
                throw new SQLException("Delete pm_remote_host one record " + sQLException.toString());
            }
            catch (Throwable throwable) {
                DefaultConnection.closeStatement(preparedStatement);
                throw throwable;
            }
        }
        DefaultConnection.closeStatement(preparedStatement);
    }

    static {
        Connection connection = null;
        try {
            connection = DefaultConnection.getConnection();
            String string = "SELECT MAX(HOST_ID_C) FROM PM_REMOTE_HOST";
            _pk = SharedReader.getId(connection, string);
        }
        catch (Exception exception) {
            _logger.error((Object)("Init remote host to get primary key. " + exception));
        }
        finally {
            DefaultConnection.closeConnection(connection);
        }
    }
}

