/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.performance;

import com.openapi.performance.IExecutorParameter;
import com.openapi.performance.IQueryExecutor;
import com.openapi.performance.ResultTypeValue;
import com.sysuptime.common.performance.QueryParameter;
import com.sysuptime.common.performance.RemoteHost;
import com.sysuptime.common.performance.ResultValue;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.performance.AbstractExecutor;
import com.sysuptime.server.performance.ExecutorHelper;
import com.sysuptime.server.performance.OpenConnectionsCache;
import com.sysuptime.server.performance.PerformanceServerUtil;
import com.sysuptime.server.performance.QueryFactory;
import com.sysuptime.server.performance.RemoteHostProcessor;
import com.sysuptime.server.util.ServerBundle;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.log4j.Logger;

public class TelnetExecutor
extends AbstractExecutor
implements IQueryExecutor {
    protected static Logger _logger = Logger.getLogger((String)TelnetExecutor.class.getName());
    private static final long TELNET_NOT_SUPPORTTED = ServerBundle.getParsedMessage("TELNET_NOT_SUPPORTTED");
    private static final long TELNET_HOST_ERROR = ServerBundle.getParsedMessage("TELNET_HOST_ERROR");
    private static final long USER_LOGIN_ERROR = ServerBundle.getParsedMessage("USER_LOGIN_ERROR");
    private static final long TELNET_ILLEGAL_COMMAND = ServerBundle.getParsedMessage("TELNET_ILLEGAL_COMMAND");
    private static int TELNET_RESPONSE_TIME;
    private static int TELNET_CONTENT_MATCH;
    protected static int[] RESULT_TYPES_1;
    private int _totalDelay = 0;

    @Override
    public ResultValue[] startExecuting(IExecutorParameter iExecutorParameter) {
        QueryParameter queryParameter = iExecutorParameter.getQueryParameter();
        List<ResultTypeValue> list = iExecutorParameter.getResultTypeValues();
        int[] nArray = PerformanceServerUtil.getResultTypes(list);
        if (PerformanceServerUtil.isOurCategory(nArray, RESULT_TYPES_1)) {
            long l2 = Long.parseLong(queryParameter.get(0).toString());
            String string = queryParameter.get(1).toString();
            return this.a(l2, string, nArray, list, iExecutorParameter.getMonitorId());
        }
        throw new IllegalArgumentException("No such result types " + Arrays.toString(nArray));
    }

    /*
     * Loose catch block
     */
    private ResultValue[] a(long l2, String string, int[] nArray, List list, int n2) {
        boolean bl2;
        ResultValue resultValue;
        long l3;
        HashMap<Integer, ResultValue> hashMap;
        block14: {
            hashMap = new HashMap<Integer, ResultValue>();
            int n3 = ExecutorHelper.b();
            RemoteHost remoteHost = null;
            try {
                remoteHost = RemoteHostProcessor.getRemoteHostByHostId(l2);
            }
            catch (Exception exception) {
                _logger.error((Object)exception);
            }
            try {
                if (remoteHost == null) {
                    throw new IllegalArgumentException("Telnet remote host is not found, please validate the pm_remote_host table");
                }
            }
            catch (Exception exception) {
                throw TelnetExecutor.a(exception);
            }
            l3 = System.currentTimeMillis();
            resultValue = null;
            for (int i2 = 0; i2 < 3; ++i2) {
                block15: {
                    this._totalDelay = 0;
                    resultValue = this.getTelnetResult(remoteHost, string.trim(), n2);
                    bl2 = resultValue.isNormal();
                    if (n3 == 0) break block14;
                    try {
                        block16: {
                            if (!bl2) break block15;
                            break block16;
                            catch (Exception exception) {
                                throw TelnetExecutor.a(exception);
                            }
                        }
                        if (n3 != 0) break;
                    }
                    catch (Exception exception) {
                        throw TelnetExecutor.a(exception);
                    }
                }
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n3 != 0) continue;
            }
            bl2 = resultValue.isNormal();
        }
        if (bl2) {
            PerformanceServerUtil.putResults(hashMap, (String)resultValue.getValue(), list, TELNET_CONTENT_MATCH);
            long l4 = System.currentTimeMillis() - l3 - (long)this._totalDelay;
            hashMap.put(TELNET_RESPONSE_TIME, QueryFactory.createResultValueObject(TELNET_RESPONSE_TIME, "N", l4));
        } else {
            hashMap.put(TELNET_RESPONSE_TIME, QueryFactory.createResultValueObject(TELNET_RESPONSE_TIME, resultValue.getResultState(), resultValue.getValue()));
            hashMap.put(TELNET_CONTENT_MATCH, QueryFactory.createResultValueObject(TELNET_CONTENT_MATCH, resultValue.getResultState(), resultValue.getValue()));
        }
        return PerformanceServerUtil.getResultValues(nArray, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public ResultValue getTelnetResult(RemoteHost var1_1, String var2_2, int var3_3) {
        block28: {
            var5_4 = QueryFactory.createResultValueObject();
            var6_5 = null;
            var4_6 = ExecutorHelper.b();
            try {
                var6_5 = (TelnetClient)OpenConnectionsCache.getConnection(var1_1, 0, var3_3);
                var6_5.setReaderThread(false);
                var7_7 = var6_5.getInputStream();
                var8_11 = var6_5.getOutputStream();
                if (this.a(var7_7, ":", null) == null) {
                    var5_4.setResultState("E");
                    var5_4.setValue(TelnetExecutor.TELNET_HOST_ERROR);
                    var9_12 = var5_4;
                    return var9_12;
                }
                if (this.a(var7_7, var8_11, var1_1.getUser(), ":") == null) {
                    var5_4.setResultState("E");
                    var5_4.setValue(TelnetExecutor.USER_LOGIN_ERROR);
                    var9_13 = var5_4;
                    return var9_13;
                }
                if (this.a(var7_7, var8_11, var1_1.getValue("password").toString(), var1_1.getValue("prompt").toString()) == null) {
                    var5_4.setResultState("E");
                    var5_4.setValue(TelnetExecutor.USER_LOGIN_ERROR);
                    var9_14 = var5_4;
                    return var9_14;
                }
                var9_15 = this.a(var7_7, var8_11, var2_2, var1_1.getValue("prompt").toString(), true);
                if (var9_15 == null) {
                    var9_15 = "";
                }
                if (var9_15.indexOf("command not found") == -1) ** GOTO lbl36
                try {
                    block29: {
                        var5_4.setResultState("E");
                        var5_4.setValue(TelnetExecutor.TELNET_ILLEGAL_COMMAND);
                        if (var4_6 != 0) break block28;
                        break block29;
                        catch (Exception v0) {
                            throw TelnetExecutor.a(v0);
                        }
                    }
                    var5_4.setResultState("N");
                    var5_4.setValue(var9_15);
                }
                catch (Exception v1) {
                    throw TelnetExecutor.a(v1);
                }
            }
            catch (Exception var7_9) {
                TelnetExecutor._logger.warn((Object)"Get telent result error occurred");
                var5_4.setResultState("E");
                this._errorbuf.append(var7_9);
                var5_4.setValue(TelnetExecutor.TELNET_NOT_SUPPORTTED);
            }
            finally {
                try {
                    OpenConnectionsCache.removeConnection(var1_1, var3_3, false);
                }
                catch (Exception var7_10) {}
            }
        }
        return var5_4;
    }

    private String a(InputStream inputStream, OutputStream outputStream, String string, String string2) {
        return this.a(inputStream, outputStream, string, string2, false);
    }

    private String a(InputStream inputStream, OutputStream outputStream, String string, String string2, boolean bl2) {
        this.a(outputStream, string);
        return this.a(inputStream, string2, string, bl2);
    }

    private void a(long l2) {
        try {
            Thread.sleep(l2);
            this._totalDelay = (int)((long)this._totalDelay + l2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void a(OutputStream outputStream, String string) {
        try {
            outputStream.write(StringUtil.toBytes(string + "\n"));
            outputStream.flush();
            this.a(150L);
        }
        catch (Exception exception) {
            _logger.warn((Object)"send telnet command error occurred", (Throwable)exception);
        }
    }

    private String a(InputStream inputStream, String string, String string2) {
        return this.a(inputStream, string, string2, false);
    }

    /*
     * Loose catch block
     */
    private String a(InputStream inputStream, String string, String string2, boolean bl2) {
        int n2 = ExecutorHelper.b();
        try {
            boolean bl3;
            StringBuffer stringBuffer;
            block12: {
                stringBuffer = new StringBuffer();
                boolean bl4 = false;
                int n3 = 0;
                byte[] byArray = new byte[4096];
                boolean bl5 = true;
                while ((n3 = inputStream.read(byArray)) > 0) {
                    int n4;
                    String string3;
                    block13: {
                        string3 = new String(byArray, 0, n3, "ISO-8859-1");
                        bl3 = bl5;
                        if (n2 == 0) break block12;
                        try {
                            block14: {
                                if (!bl3) break block13;
                                break block14;
                                catch (Exception exception) {
                                    throw TelnetExecutor.a(exception);
                                }
                            }
                            if (string2 == null) break block13;
                        }
                        catch (Exception exception) {
                            throw TelnetExecutor.a(exception);
                        }
                        n4 = string3.indexOf("\n");
                        if (n4 <= 0) break block13;
                        bl5 = false;
                        String string4 = string3.substring(0, n4);
                        try {
                            if (!string2.trim().equals(string4.trim())) break block13;
                            if (n4 >= string3.length() - 1) continue;
                        }
                        catch (Exception exception) {
                            throw TelnetExecutor.a(exception);
                        }
                        string3 = string3.substring(n4 + 1);
                        string3 = PerformanceServerUtil.removeTerminalEmulationCharacters(string3);
                        stringBuffer.append(string3);
                        if (n2 != 0) continue;
                    }
                    if (string3.length() <= 0) continue;
                    n4 = (string3 = PerformanceServerUtil.removeTerminalEmulationCharacters(string3)).indexOf(string);
                    if (n4 >= 0) {
                        bl4 = true;
                        if (bl2) {
                            string3 = string3.substring(0, n4);
                        }
                    }
                    stringBuffer.append(string3);
                    if (!bl4) continue;
                }
                bl3 = bl4;
            }
            if (bl3) {
                return stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            _logger.warn((Object)"Read telnet result error occurred", (Throwable)exception);
        }
        return null;
    }

    static {
        try {
            TELNET_RESPONSE_TIME = ExecutorHelper.getId("TELNET_RESPONSE_TIME");
            TELNET_CONTENT_MATCH = ExecutorHelper.getId("TELNET_CONTENT_MATCH");
            RESULT_TYPES_1 = new int[]{TELNET_RESPONSE_TIME, TELNET_CONTENT_MATCH};
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

