/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.reportschedule;

import com.sysuptime.common.util.CommonUtil;
import com.sysuptime.common.util.ICommonBundle;
import com.sysuptime.server.reportschedule.CommonDrawableRenderer;
import com.sysuptime.server.reportschedule.Graph$Renderer;
import com.sysuptime.server.reportschedule.TimeSeriesItem;
import com.sysuptime.server.reportschedule.TimeSeriesItem$ValueWithState;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRRenderable;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.Drawable;
import org.jfree.ui.RectangleInsets;

public class Graph
implements Serializable {
    private static NumberFormat NUMBERFORMAT = NumberFormat.getNumberInstance();

    public static JRRenderable getImage(ArrayList arrayList, String string) {
        JFreeChart jFreeChart = Graph.a(arrayList, string);
        return new CommonDrawableRenderer((Drawable)jFreeChart);
    }

    private static JFreeChart a(ArrayList arrayList, String string) {
        TimeSeriesItem timeSeriesItem;
        DateAxis dateAxis = new DateAxis();
        dateAxis.setDateFormatOverride((DateFormat)CommonUtil.getDateFormat());
        dateAxis.setVerticalTickLabels(true);
        int n2 = TimeSeriesItem$ValueWithState.c();
        dateAxis.setTickLabelInsets(new RectangleInsets(20.0, 1.0, 1.0, 1.0));
        int n3 = n2;
        NumberAxis numberAxis = null;
        numberAxis = string != null ? new NumberAxis(ICommonBundle.VALUE + " ( " + string + " )") : new NumberAxis(ICommonBundle.VALUE);
        numberAxis.setNumberFormatOverride(NUMBERFORMAT);
        TimeSeries timeSeries = new TimeSeries((Comparable)((Object)"time"), Millisecond.class);
        int n4 = arrayList.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            timeSeriesItem = (TimeSeriesItem)arrayList.get(i2);
            timeSeries.add((RegularTimePeriod)timeSeriesItem.getTime(), (Number)timeSeriesItem.getValue());
            if (n3 == 0) continue;
        }
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        Graph$Renderer graph$Renderer = new Graph$Renderer(timeSeries);
        timeSeriesItem = new XYPlot((XYDataset)timeSeriesCollection, (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)graph$Renderer);
        JFreeChart jFreeChart = new JFreeChart("", (Plot)timeSeriesItem);
        jFreeChart.setBackgroundPaint((Paint)Color.white);
        timeSeriesItem.setOrientation(PlotOrientation.VERTICAL);
        timeSeriesItem.setBackgroundPaint(Color.white);
        timeSeriesItem.setRangeGridlinePaint(Color.white);
        jFreeChart.setBorderPaint((Paint)Color.white);
        jFreeChart.removeLegend();
        return jFreeChart;
    }

    static {
        NUMBERFORMAT.setMaximumFractionDigits(3);
    }
}

