/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.trapreceiver;

import com.sysuptime.common.trapreceiver.ClearInfo;
import com.sysuptime.common.trapreceiver.TrapObject;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.Email;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.callback.ICallbackClient;
import com.sysuptime.server.trapreceiver.ListenerSql;
import com.sysuptime.server.trapreceiver.PooledPerformer;
import com.sysuptime.server.trapreceiver.TrapCallbackServer;
import com.sysuptime.server.trapreceiver.TrapReceiverHelper$1;
import com.sysuptime.server.trapreceiver.TrapReceiverHelperMBean;
import com.sysuptime.server.util.mail.SendMail;
import java.io.File;
import java.math.BigDecimal;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class TrapReceiverHelper
implements TrapReceiverHelperMBean {
    private static final Logger log = Logger.getLogger((String)TrapReceiverHelper.class.getName());
    private static final String SOUNDPATH = AppUtil.getAppServerHomeDirectory() + File.separator + "deploy" + File.separator + "app.war" + File.separator + "sound" + File.separator;

    @Override
    public RmiResponse getAlarmCatalogs() throws RemoteException {
        return ListenerSql.getCategory();
    }

    @Override
    public boolean addCategory(String string) {
        return ListenerSql.addCategory(string);
    }

    @Override
    public boolean modifyCategory(Integer n2, String string) {
        return ListenerSql.modifyCategory(n2, string);
    }

    @Override
    public boolean deleteCategory(Integer n2) {
        return ListenerSql.deleteCategory(n2);
    }

    @Override
    public Integer getCategoryNameToId(String string) {
        return ListenerSql.getCategoryNameToId(string);
    }

    @Override
    public RmiResponse setSeverityInTrap(TrapObject trapObject, Short s2) {
        RmiResponse rmiResponse = ListenerSql.setSeverityInTrap(new BigDecimal(trapObject.getTrapId()), s2);
        if (rmiResponse.getValue().equals(Boolean.TRUE)) {
            TrapCallbackServer.getInstance().changeSeverityForTrap(trapObject.getTrapId(), s2);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse getTraps(Boolean bl2, String[] stringArray, String string, Integer n2, Long l2, Long l3, Integer n3) throws RemoteException {
        try {
            if (!bl2.booleanValue()) {
                return ListenerSql.getTraps(bl2, null, null, -1, l2, l3, n3);
            }
            return ListenerSql.getTraps(bl2, stringArray, string, n2, l2, l3, n3);
        }
        catch (Throwable throwable) {
            log.error((Object)"", throwable);
            return null;
        }
    }

    @Override
    public RmiResponse updateTrapForAck(ClearInfo clearInfo) throws RemoteException {
        RmiResponse rmiResponse = ListenerSql.updateTrapForAck(clearInfo);
        try {
            if (rmiResponse.getValue().equals(Boolean.TRUE)) {
                TrapCallbackServer.getInstance().acknowledge(clearInfo);
            }
        }
        catch (RemoteException remoteException) {
            throw TrapReceiverHelper.a(remoteException);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse updateTrapForClear(ClearInfo clearInfo) throws RemoteException {
        RmiResponse rmiResponse = ListenerSql.updateTrapForClear(clearInfo);
        try {
            if (Boolean.TRUE.equals(rmiResponse.getValue())) {
                TrapCallbackServer.getInstance().clear(clearInfo);
            }
        }
        catch (RemoteException remoteException) {
            throw TrapReceiverHelper.a(remoteException);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse sendMail(Email email) throws RemoteException {
        return SendMail.sendMail(email.getSubject(), email.getContent(), email.getTo(), null, "text/html");
    }

    @Override
    public void addClient(ICallbackClient iCallbackClient) {
        log.info((Object)"Added a new trap receiver client");
    }

    @Override
    public void removeClient(ICallbackClient iCallbackClient) {
        log.info((Object)"Remove a trap receiver client");
    }

    @Override
    public RmiResponse deleteTraps(Collection collection) throws RemoteException {
        RmiResponse rmiResponse = ListenerSql.deleteTraps(collection);
        try {
            if (Boolean.TRUE.equals(rmiResponse.getValue())) {
                TrapCallbackServer.getInstance().removeTrapsFromUI(collection);
            }
        }
        catch (RemoteException remoteException) {
            throw TrapReceiverHelper.a(remoteException);
        }
        return rmiResponse;
    }

    @Override
    public RmiResponse getUsedCategoryId() {
        return ListenerSql.getUsedCategory();
    }

    @Override
    public List getSoundList() {
        ArrayList<String> arrayList;
        block2: {
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String[] stringArray = PooledPerformer.b();
            File file = new File(SOUNDPATH);
            File[] fileArray = file.listFiles(new TrapReceiverHelper$1(this));
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                arrayList = arrayList2;
                if (stringArray != null) {
                    arrayList.add(fileArray[i2].getName());
                    if (stringArray != null) continue;
                }
                break block2;
            }
            arrayList = arrayList2;
        }
        return arrayList;
    }

    private static RemoteException a(RemoteException remoteException) {
        return remoteException;
    }
}

