/*
 * Decompiled with CFR 0.152.
 */
package com.sysuptime.server.util;

import com.sysuptime.common.msp.Probe;
import com.sysuptime.common.performance.ScheduledDownTime;
import com.sysuptime.common.util.AppUtil;
import com.sysuptime.common.util.FileUtil;
import com.sysuptime.common.util.RmiResponse;
import com.sysuptime.common.util.StringUtil;
import com.sysuptime.server.performance.MonitorHostWriter;
import com.sysuptime.server.util.DefaultConnection;
import com.sysuptime.server.util.MBeanUtil;
import com.sysuptime.server.util.ServerConfig$Properties2;
import com.sysuptime.server.util.ServerPropertiesFile;
import com.sysuptime.server.util.mail.SendMail;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ServerConfig {
    private static final Logger _logger = Logger.getLogger((String)ServerConfig.class.getName());
    private static ServerConfig$Properties2 _properties = new ServerConfig$Properties2();
    private static Properties _licenseProperties = null;
    private static ScheduledDownTime _scheduledDownTime = null;
    public static final String TRAP_RECEIVER_SNMP_KEEP_DAY = "trapReceiver.snmpKeepDay";
    public static final String TRAP_RECEIVER_PERF_KEEP_DAY = "trapReceiver.performanceKeepDay";
    public static final String DEFAULT_DATA_KEEP_DAYS = "10";
    public static final String TRAP_RECEIVER_SEVERITY_OF_MAIL = "trapReceiver.severityOfMail";
    public static final String TRAP_RECEIVER_GROUP_NAME = "trapReceiver.groupName";
    public static final String TRAP_RECEIVER_PORT = "trapReceiver.port";
    public static final String TRAP_RECEIVER_TEMPLATE_ENABLED = "trapReceiver.templateEnabled";
    public static final String TRAP_RECEIVER_SUBJECT_TEMPLATE_ENABLED = "trapReceiver.subjectTemplateEnabled";
    public static final String TRAP_RECEIVER_TEMPLATE = "trapReceiver.template";
    public static final String TRAP_RECEIVER_SUBJECT_TEMPLATE = "trapReceiver.subjectTemplate";
    public static final String TRAP_RECEIVER_STORE_UNKNOWN_TRAPS = "trapReceiver.storeUnknownTraps";
    public static final String TRAP_RECEIVER_DEDUP_ENABLED = "trapReceiver.dedupEnabled";
    public static final String TRAP_RECEIVER_UNKNOWN_TRAPS_SEVERITY = "trapReceiver.unknownTrapsSeverity";
    public static final String TRAP_RECEIVER_UNKNOWN_TRAPS_MESSAGE = "trapReceiver.unknownTrapsMessage";
    public static final String TRAP_RECEIVER_MAIL_ENABLED = "trapReceiver.mailEnabled";
    public static final String TRAP_RECEIVER_FORWARD_ENABLED = "trapReceiver.forwardEnabled";
    public static final String TRAP_RECEIVER_CLEAR_TRAP_ENABLED = "trapReceiver.clearTrapEnabled";
    public static final String TRAP_RECEIVER_SERVER_ADDRESS = "trapReceiver.serverAddress";
    public static final String TRAP_RECEIVER_SERVER_PORT = "trapReceiver.serverPort";
    public static final String TRAP_RECEIVER_DEDUP_TIME = "trapReceiver.dedupTime";
    public static final String TRAP_RECEIVER_CLEAR_TRAP_TIME = "trapReceiver.clearTrapTime";
    public static final String LICENSE = "license";
    public static final String LICENSE_TIME = "license.applyTime";
    public static final String DATABASE_INITIALIZED = "database.initialized";
    public static final String DISCOVERED = "discovered";
    public static final String TRAP_EVENT_DEFAULT_ACTIONS = "trapEvent.defaultActions";
    public static final String MONITOR_DEFAULT_ACTIONS = "monitor.defaultActions";
    public static final String TRAP_RECEIVER_SHOULD_CONFIG_SMTP = "trapReceiver.shouldConfigSmtp";
    public static final String AUTHENTICATION_SHOULD_CONFIG = "authentication.shouldConfig";
    public static final String MSP_CUSTOMER_NAME = "msp.customerName";
    public static final String MSP_PROBE_ID = "msp.probeID";
    public static final String MSP_MASTER_HOST = "msp.masterHost";
    public static final String MSP_MASTER_PORT = "msp.masterPort";
    public static final String MSP_USERNAME = "msp.username";
    public static final String MSP_PASSWORD = "msp.password";
    public static final String MSP_SERVICE_PUBLIC_PORT = "msp.probeServicePublicPort";
    public static final String MSP_REGISTER_TIME = "msp.registerTime";
    public static final String MSP_TO_SYNC_PROBES = "msp.toSyncProbes";
    public static final String SCHEDULED_DOWN_FROM = "scheduled.down.from";
    public static final String SCHEDULED_DOWN_TO = "scheduled.down.to";
    public static final String SCHEDULED_DOWN_ENABLED = "scheduled.down.enabled";
    private static final XStream X = new XStream((HierarchicalStreamDriver)new DomDriver());

    private static void a() {
        _logger.info((Object)"Version:7.0; Build:7045");
        _logger.info((Object)("OS:" + System.getProperty("os.name") + ". " + System.getProperty("os.version")));
        if (AppUtil.isLinux()) {
            String string = FileUtil.readFile("/etc/issue");
            try {
                if (string != null) {
                    _logger.info((Object)("Linux distro:" + string));
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupProp() {
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        Connection connection;
        block7: {
            _logger.info((Object)"Retrieving properties table data.");
            connection = null;
            preparedStatement = null;
            resultSet = null;
            connection = DefaultConnection.getConnection();
            if (connection != null) break block7;
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            return;
        }
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM properties_t");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string = resultSet.getString("name_c");
                String string2 = resultSet.getString("value_c");
                if (string2 == null) {
                    string2 = "";
                }
                _properties.put(string, string2, false);
            }
            MonitorHostWriter.setupScheduleHostID(connection);
        }
        catch (Exception exception) {
            try {
                _logger.error((Object)("Cannot read properties table. " + exception));
            }
            catch (Throwable throwable) {
                DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
                throw throwable;
            }
            DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
            return;
        }
        DefaultConnection.closeConnection(connection, preparedStatement, resultSet);
        ServerConfig.a();
    }

    public static Properties getProperties() {
        try {
            if (_properties.size() == 0) {
                ServerConfig.setupProp();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ServerConfig.a(numberFormatException);
        }
        return _properties;
    }

    public static String getProperty(String string) {
        try {
            if (_properties.size() == 0) {
                ServerConfig.setupProp();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ServerConfig.a(numberFormatException);
        }
        return _properties.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        String string3;
        block7: {
            try {
                if (_properties.size() == 0) {
                    ServerConfig.setupProp();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
            string3 = _properties.getProperty(string);
            try {
                try {
                    if (string3 != null && string3.length() != 0) break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ServerConfig.a(numberFormatException);
                }
                return string2;
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
        }
        return string3;
    }

    public static String getLicenseProperty(String string) {
        try {
            if (_licenseProperties == null) {
                return null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ServerConfig.a(numberFormatException);
        }
        return _licenseProperties.getProperty(string);
    }

    public static Properties getLicenseProperties() {
        return _licenseProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static RmiResponse updatePropertyForRmi(String var0, String var1_1) {
        block11: {
            var2_2 = new RmiResponse(Boolean.TRUE);
            var3_3 = null;
            var4_4 = null;
            try {
                var3_3 = DefaultConnection.getConnection();
                var5_5 = ServerConfig._properties.getProperty(var0);
                if (var5_5 != null) {
                    var4_4 = var3_3.prepareStatement("UPDATE properties_t SET value_c=? WHERE name_c=?");
                    var4_4.setString(1, var1_1);
                    var4_4.setString(2, var0);
                    var4_4.executeUpdate();
                    var4_4.close();
                } else {
                    var4_4 = var3_3.prepareStatement("INSERT INTO properties_t VALUES(?,?)");
                    var4_4.setString(1, var0);
                    var4_4.setString(2, var1_1);
                    var4_4.executeUpdate();
                    var4_4.close();
                }
                if (var1_1 == null) {
                    var1_1 = "";
                }
                ServerConfig._properties.put(var0, var1_1, true);
                if ("smtp.host".equals(var0)) ** GOTO lbl32
                try {
                    block12: {
                        if (!"smtp.host.2".equals(var0)) break block11;
                        break block12;
                        catch (Exception v0) {
                            throw ServerConfig.a(v0);
                        }
                    }
                    SendMail.resetSession();
                }
                catch (Exception v1) {
                    throw ServerConfig.a(v1);
                }
            }
            catch (Exception var5_6) {
                try {
                    ServerConfig._logger.error((Object)"updateProperty", (Throwable)var5_6);
                    var2_2.setValue(Boolean.FALSE);
                    var2_2.setErrorMessage(var5_6.getMessage());
                }
                catch (Throwable var6_7) {
                    DefaultConnection.closeConnection(var3_3, var4_4, null);
                    throw var6_7;
                }
                DefaultConnection.closeConnection(var3_3, var4_4, null);
            }
        }
        DefaultConnection.closeConnection(var3_3, var4_4, null);
        return var2_2;
    }

    public static boolean updateProperty(String string, String string2) {
        try {
            if (_properties.size() == 0) {
                ServerConfig.setupProp();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ServerConfig.a(numberFormatException);
        }
        try {
            if (ServerConfig.updatePropertyForRmi(string, string2).getValue().equals(Boolean.TRUE)) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw ServerConfig.a(numberFormatException);
        }
        return false;
    }

    public static boolean updateProperties(Properties properties) {
        boolean bl2;
        block7: {
            boolean bl3 = true;
            Set<Object> set = properties.keySet();
            Iterator<Object> iterator = set.iterator();
            String string = MBeanUtil.b();
            while (iterator.hasNext()) {
                block9: {
                    boolean bl4;
                    block8: {
                        Object object = iterator.next();
                        String string2 = object.toString();
                        String string3 = properties.getProperty(string2);
                        try {
                            try {
                                try {
                                    bl2 = bl3;
                                    if (string == null) break block7;
                                    if (!bl2) break block8;
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw ServerConfig.a(numberFormatException);
                                }
                                if (!ServerConfig.updateProperty(string2, string3)) break block8;
                            }
                            catch (NumberFormatException numberFormatException) {
                                throw ServerConfig.a(numberFormatException);
                            }
                            bl4 = true;
                            break block9;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw ServerConfig.a(numberFormatException);
                        }
                    }
                    bl4 = bl3 = false;
                }
                if (string != null) continue;
            }
            bl2 = bl3;
        }
        return bl2;
    }

    public static void updateCache(Object object, Object object2) {
        _properties.put(object, object2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeProperty(String string) {
        boolean bl2 = true;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = DefaultConnection.getConnection();
            preparedStatement = connection.prepareStatement("Delete from properties_t WHERE name_c=?");
            preparedStatement.setString(1, string);
            preparedStatement.executeUpdate();
            _properties.remove(string);
        }
        catch (Exception exception) {
            _logger.error((Object)"removeProperty", (Throwable)exception);
            bl2 = false;
        }
        finally {
            DefaultConnection.closeConnection(connection, preparedStatement, null);
        }
        return bl2;
    }

    public static String getCustomerID() {
        return String.valueOf(ServerConfig.getProbeID());
    }

    public static String getCustomerName() {
        block4: {
            try {
                try {
                    if (!ServerPropertiesFile.isMaster() && ServerPropertiesFile.isMspEdition()) break block4;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ServerConfig.a(numberFormatException);
                }
                return Probe.LOCAL_PROBE.getName();
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
        }
        return ServerConfig.getProperty(MSP_CUSTOMER_NAME);
    }

    public static long getProbeID() {
        block6: {
            try {
                try {
                    if (!ServerPropertiesFile.isMaster() && ServerPropertiesFile.isMspEdition()) break block6;
                }
                catch (NumberFormatException numberFormatException) {
                    throw ServerConfig.a(numberFormatException);
                }
                return 0L;
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
        }
        String string = ServerConfig.getProperty(MSP_PROBE_ID);
        long l2 = -1L;
        if (!StringUtil.isEmpty(string)) {
            l2 = Long.parseLong(string);
        } else {
            _logger.debug((Object)"NOT yet register to master. ");
        }
        return l2;
    }

    public static void setProbeID(long l2) {
        ServerConfig.updateProperty(MSP_PROBE_ID, String.valueOf(l2));
    }

    public static String getLocalServicePort() {
        return ServerConfig.getProperty(MSP_SERVICE_PUBLIC_PORT, "8443");
    }

    public static ScheduledDownTime getScheduledDownTime() {
        try {
            if (_scheduledDownTime == null) {
                long l2 = Long.parseLong(ServerConfig.getProperty(SCHEDULED_DOWN_FROM, "0"));
                long l3 = Long.parseLong(ServerConfig.getProperty(SCHEDULED_DOWN_TO, "0"));
                boolean bl2 = "true".equals(ServerConfig.getProperty(SCHEDULED_DOWN_ENABLED, "false"));
                _scheduledDownTime = new ScheduledDownTime(l2, l3, bl2);
            }
            try {
                if (_scheduledDownTime.getEndTime() < System.currentTimeMillis()) {
                    _scheduledDownTime.setEnabled(false);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw ServerConfig.a(numberFormatException);
            }
            return _scheduledDownTime;
        }
        catch (NumberFormatException numberFormatException) {
            _logger.error((Object)"", (Throwable)numberFormatException);
            return new ScheduledDownTime();
        }
    }

    /*
     * Loose catch block
     */
    public static boolean updateScheduledDownTime(ScheduledDownTime scheduledDownTime) {
        try {
            boolean bl2;
            block17: {
                block14: {
                    boolean bl3;
                    block13: {
                        block12: {
                            block15: {
                                if (!ServerConfig.updateProperty(SCHEDULED_DOWN_FROM, String.valueOf(scheduledDownTime.getStartTime()))) break block12;
                                if (!ServerConfig.updateProperty(SCHEDULED_DOWN_TO, String.valueOf(scheduledDownTime.getEndTime()))) break block12;
                                break block15;
                                catch (Exception exception) {
                                    throw ServerConfig.a(exception);
                                }
                            }
                            try {
                                block16: {
                                    if (!ServerConfig.updateProperty(SCHEDULED_DOWN_ENABLED, String.valueOf(scheduledDownTime.isEnabled()))) break block12;
                                    break block16;
                                    catch (Exception exception) {
                                        throw ServerConfig.a(exception);
                                    }
                                }
                                bl3 = true;
                                break block13;
                            }
                            catch (Exception exception) {
                                throw ServerConfig.a(exception);
                            }
                        }
                        bl3 = false;
                    }
                    bl2 = bl3;
                    if (!bl2) break block17;
                    try {
                        block18: {
                            if (_scheduledDownTime != null) break block14;
                            break block18;
                            catch (Exception exception) {
                                throw ServerConfig.a(exception);
                            }
                        }
                        _scheduledDownTime = ServerConfig.getScheduledDownTime();
                    }
                    catch (Exception exception) {
                        throw ServerConfig.a(exception);
                    }
                }
                _scheduledDownTime.setEnabled(scheduledDownTime.isEnabled());
                _scheduledDownTime.setStartTime(scheduledDownTime.getStartTime());
                _scheduledDownTime.setEndTime(scheduledDownTime.getEndTime());
            }
            return bl2;
        }
        catch (Exception exception) {
            _logger.error((Object)"", (Throwable)exception);
            return false;
        }
    }

    public static void setRegisterTime(long l2) {
        ServerConfig.updateProperty(MSP_REGISTER_TIME, String.valueOf(l2));
    }

    public static long getRegisterTime() {
        return Long.valueOf(ServerConfig.getProperty(MSP_REGISTER_TIME, "-1"));
    }

    private static Set<Long> b() {
        String string = ServerConfig.getProperty(MSP_TO_SYNC_PROBES);
        Set<Long> set = new HashSet<Long>();
        if (string != null) {
            set = (Set)X.fromXML(string);
        }
        return set;
    }

    public static void addToSyncProbe(long l2) {
        Set<Long> set = ServerConfig.b();
        set.add(l2);
        ServerConfig.updateProperty(MSP_TO_SYNC_PROBES, X.toXML(set));
    }

    public static void removeToSyncProbe(long l2) {
        Set<Long> set = ServerConfig.b();
        set.remove(l2);
        ServerConfig.updateProperty(MSP_TO_SYNC_PROBES, X.toXML(set));
    }

    public static boolean containsToSyncProbe(long l2) {
        Set<Long> set = ServerConfig.b();
        return set.contains(l2);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

