/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.extras.api.tabbed;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JTabbedPane;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.substance.extras.api.tabbed.TabPreviewPainter;

public class DefaultTabPreviewPainter
extends TabPreviewPainter {
    @Override
    public boolean hasPreview(JTabbedPane tabPane, int tabIndex) {
        return tabPane.getComponentAt(tabIndex) != null;
    }

    @Override
    public boolean isSensitiveToEvents(JTabbedPane tabPane, int tabIndex) {
        return tabPane.isEnabledAt(tabIndex);
    }

    @Override
    public void previewTab(JTabbedPane tabPane, int tabIndex, BufferedImage bufferedImage, int x, int y, int w, int h) {
        Component tabComponent = tabPane.getComponentAt(tabIndex);
        if (tabComponent == null) {
            return;
        }
        int compWidth = tabComponent.getWidth();
        int compHeight = tabComponent.getHeight();
        if (compWidth > 0 && compHeight > 0) {
            BufferedImage tempCanvas = new BufferedImage(compWidth, compHeight, 2);
            Graphics tempCanvasGraphics = tempCanvas.getGraphics();
            tabComponent.paint(tempCanvasGraphics);
            double coef = Math.min((double)w / (double)compWidth, (double)h / (double)compHeight);
            Graphics2D g2 = bufferedImage.createGraphics();
            if (!tabPane.isEnabledAt(tabIndex)) {
                g2.setComposite(AlphaComposite.getInstance(3, 0.5f));
            }
            if (coef < 1.0) {
                int sdWidth = (int)(coef * (double)compWidth);
                int sdHeight = (int)(coef * (double)compHeight);
                int dx = (w - sdWidth) / 2;
                int dy = (h - sdHeight) / 2;
                BufferedImage thumbnail = NeonCortex.createThumbnail((BufferedImage)tempCanvas, (int)sdWidth);
                NeonCortex.drawImage((Graphics)g2, (Image)thumbnail, (int)dx, (int)dy);
            } else {
                g2.drawImage((Image)tempCanvas, 0, 0, null);
            }
            g2.dispose();
        }
    }

    @Override
    public boolean hasPreviewWindow(JTabbedPane tabPane, int tabIndex) {
        return true;
    }

    @Override
    public boolean hasOverviewDialog(JTabbedPane tabPane) {
        return true;
    }
}

