/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.CLIHandler;
import org.netbeans.Main;

public abstract class CLIHandler {
    private static final int KEY_LENGTH = 10;
    private static final int REPLY_OK = 1;
    private static final int REPLY_EXIT = 2;
    private static final int REPLY_FAIL = 0;
    private static final int REPLY_DELAY = 3;
    private static final int REPLY_READ = 10;
    private static final int REPLY_WRITE = 11;
    private static final int REPLY_AVAILABLE = 12;
    public static final int WHEN_BOOT = 1;
    public static final int WHEN_INIT = 2;
    private static Server server;
    private static StringBuffer OUTPUT;
    private int when;
    private static List doLater;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected CLIHandler(int when) {
        this.when = when;
    }

    protected abstract int cli(Args var1);

    private static void showHelp(PrintWriter w, List handlers) {
        Iterator it = handlers.iterator();
        while (it.hasNext()) {
            ((CLIHandler)it.next()).usage(w);
        }
    }

    protected abstract void usage(PrintWriter var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void enterState(int state, Integer block) {
        Comparable<StringBuffer> comparable;
        StringBuffer output = OUTPUT;
        if (output != null) {
            comparable = output;
            synchronized (comparable) {
                output.append("state: ");
                output.append(state);
                output.append(" thread: ");
                output.append(Thread.currentThread());
                if (block == null) {
                    output.append('\n');
                }
            }
        }
        if (block == null) {
            return;
        }
        comparable = block;
        synchronized (comparable) {
            if (state == block) {
                if (output != null) {
                    output.append(" blocked\n");
                }
                block.notifyAll();
                try {
                    block.wait();
                }
                catch (InterruptedException ex) {
                    throw new IllegalStateException();
                }
            } else if (output != null) {
                output.append(" not blocked\n");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int notifyHandlers(Args args, List handlers, int when, boolean failOnUnknownOptions, boolean consume) {
        try {
            String[] argv = args.getArguments();
            for (int i = 0; i < argv.length; ++i) {
                if (!$assertionsDisabled && argv[i] == null) {
                    throw new AssertionError();
                }
                if (!argv[i].equals("-?") && !argv[i].equals("--help") && !argv[i].equals("-help")) continue;
                PrintWriter w = new PrintWriter(args.getOutputStream());
                CLIHandler.showHelp(w, handlers);
                w.flush();
                int n = 2;
                return n;
            }
            int r = 0;
            Iterator it = handlers.iterator();
            while (it.hasNext()) {
                CLIHandler h = (CLIHandler)it.next();
                if (h.when != when) continue;
                r = h.cli(args);
                if (r == 0) continue;
                int n = r;
                return n;
            }
            if (failOnUnknownOptions) {
                argv = args.getArguments();
                for (int i = 0; i < argv.length; ++i) {
                    if (argv[i] == null) continue;
                    PrintWriter w = new PrintWriter(args.getOutputStream());
                    w.println("Ignored unknown option: " + argv[i]);
                    w.flush();
                    int n = 2;
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        finally {
            args.reset(consume);
        }
    }

    static Status initialize(String[] args, InputStream is, OutputStream os, Main.BootClassLoader loader, boolean failOnUnknownOptions, boolean cleanLockFile, Runnable runWhenHome) {
        return CLIHandler.initialize(new Args(args, is, os, System.getProperty("user.dir")), null, loader.allCLIs(), failOnUnknownOptions, cleanLockFile, runWhenHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int registerFinishInstallation(Execute run) {
        boolean runNow;
        Class clazz = CLIHandler.class;
        synchronized (clazz) {
            if (doLater != null) {
                doLater.add(run);
                runNow = false;
            } else {
                runNow = true;
            }
        }
        if (runNow) {
            return run.exec();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int finishInitialization(boolean recreate) {
        List toRun;
        Class clazz = CLIHandler.class;
        synchronized (clazz) {
            toRun = doLater;
            List list = doLater = recreate ? new ArrayList() : null;
            if (!recreate) {
                CLIHandler.class.notifyAll();
            }
        }
        if (toRun != null) {
            Iterator it = toRun.iterator();
            while (it.hasNext()) {
                Execute r = (Execute)it.next();
                int result = r.exec();
                if (result == 0) continue;
                return result;
            }
        }
        return 0;
    }

    private static synchronized boolean waitFinishInstallationIsOver(int timeout) {
        if (doLater != null) {
            try {
                CLIHandler.class.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return doLater == null;
    }

    public static synchronized void stopServer() {
        Server s = server;
        if (s != null) {
            s.stopServer();
        }
    }

    static void registerDebug(StringBuffer sb) {
        OUTPUT = sb;
    }

    private static InetAddress localHostAddress() throws IOException {
        NetworkInterface net = NetworkInterface.getByName("lo");
        if (net == null || !net.getInetAddresses().hasMoreElements()) {
            return InetAddress.getLocalHost();
        }
        return net.getInetAddresses().nextElement();
    }

    static Status initialize(final Args args, Integer block, final List handlers, final boolean failOnUnknownOptions, boolean cleanLockFile, Runnable runWhenHome) {
        int r = CLIHandler.notifyHandlers(args, handlers, 1, false, failOnUnknownOptions);
        if (r != 0) {
            return new Status(r);
        }
        String home = System.getProperty("netbeans.user");
        if (home == null) {
            home = System.getProperty("user.home");
            System.setProperty("netbeans.user", home);
        }
        if (runWhenHome != null) {
            runWhenHome.run();
        }
        File lockFile = new File(home, "lock");
        for (int i = 0; i < 5; ++i) {
            try {
                if (lockFile.exists()) {
                    CLIHandler.enterState(5, block);
                    throw new IOException("EXISTS");
                }
                lockFile.getParentFile().mkdirs();
                lockFile.createNewFile();
                lockFile.deleteOnExit();
                try {
                    int chmoded;
                    File chmod = new File("/bin/chmod");
                    if (!chmod.isFile()) {
                        chmod = new File("/usr/bin/chmod");
                    }
                    if (chmod.isFile() && (chmoded = Runtime.getRuntime().exec(new String[]{chmod.getAbsolutePath(), "go-rwx", lockFile.getAbsolutePath()}).waitFor()) != 0) {
                        throw new IOException("could not run " + chmod + " go-rwx " + lockFile);
                    }
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException(e.toString()).initCause(e);
                }
                CLIHandler.enterState(10, block);
                byte[] arr = new byte[10];
                try {
                    SecureRandom.getInstance("SHA1PRNG").nextBytes(arr);
                }
                catch (NoSuchAlgorithmException e) {
                    try {
                        SecureRandom.getInstance("IBMSecureRandom").nextBytes(arr);
                    }
                    catch (NoSuchAlgorithmException e2) {
                        System.err.println("WARNING: remote IDE automation features cannot be cryptographically secured, so disabling; please reopen http://www.netbeans.org/issues/show_bug.cgi?id=36966");
                        e.printStackTrace();
                        return new Status();
                    }
                }
                server = new Server(arr, block, handlers, failOnUnknownOptions);
                DataOutputStream os = new DataOutputStream(new FileOutputStream(lockFile));
                int p = server.getLocalPort();
                os.writeInt(p);
                CLIHandler.enterState(20, block);
                os.write(arr);
                os.close();
                int execCode = CLIHandler.registerFinishInstallation(new Execute(){

                    public int exec() {
                        return CLIHandler.notifyHandlers(args, handlers, 2, failOnUnknownOptions, failOnUnknownOptions);
                    }
                });
                CLIHandler.enterState(0, block);
                return new Status(lockFile, server.getLocalPort(), execCode);
            }
            catch (IOException ex) {
                if (!"EXISTS".equals(ex.getMessage())) {
                    ex.printStackTrace();
                }
                byte[] key = null;
                int port = -1;
                try {
                    DataInputStream is = new DataInputStream(new FileInputStream(lockFile));
                    port = is.readInt();
                    key = new byte[10];
                    is.readFully(key);
                    is.close();
                }
                catch (IOException ex2) {
                    // empty catch block
                }
                if (key != null && port != -1) {
                    block42: {
                        try {
                            CLIHandler.enterState(28, block);
                            Socket socket = new Socket(CLIHandler.localHostAddress(), port);
                            socket.setSoTimeout(5000);
                            DataOutputStream os = new DataOutputStream(socket.getOutputStream());
                            os.write(key);
                            os.flush();
                            CLIHandler.enterState(30, block);
                            DataInputStream replyStream = new DataInputStream(socket.getInputStream());
                            block27: while (true) {
                                CLIHandler.enterState(32, block);
                                int reply = replyStream.read();
                                CLIHandler.enterState(34, block);
                                switch (reply) {
                                    case 0: {
                                        CLIHandler.enterState(36, block);
                                        break block42;
                                    }
                                    case 1: {
                                        CLIHandler.enterState(38, block);
                                        String[] arr = args.getArguments();
                                        os.writeInt(arr.length);
                                        for (int a = 0; a < arr.length; ++a) {
                                            os.writeUTF(arr[a]);
                                        }
                                        os.writeUTF(args.getCurrentDirectory().toString());
                                        os.flush();
                                        break;
                                    }
                                    case 2: {
                                        int exitCode = replyStream.readInt();
                                        if (exitCode == 0) {
                                            exitCode = -1;
                                        }
                                        os.close();
                                        replyStream.close();
                                        CLIHandler.enterState(0, block);
                                        return new Status(lockFile, port, exitCode);
                                    }
                                    case 10: {
                                        CLIHandler.enterState(42, block);
                                        int howMuch = replyStream.readInt();
                                        byte[] byteArr = new byte[howMuch];
                                        int really = args.getInputStream().read(byteArr);
                                        os.write(really);
                                        if (really > 0) {
                                            os.write(byteArr, 0, really);
                                        }
                                        os.flush();
                                        break;
                                    }
                                    case 11: {
                                        CLIHandler.enterState(44, block);
                                        int howMuch = replyStream.readInt();
                                        byte[] byteArr = new byte[howMuch];
                                        replyStream.read(byteArr);
                                        args.getOutputStream().write(byteArr);
                                        break;
                                    }
                                    case 12: {
                                        CLIHandler.enterState(46, block);
                                        os.writeInt(args.getInputStream().available());
                                        os.flush();
                                        break;
                                    }
                                    case 3: {
                                        break;
                                    }
                                    case -1: {
                                        break;
                                    }
                                    default: {
                                        if (!$assertionsDisabled) {
                                            throw new AssertionError(reply);
                                        }
                                        continue block27;
                                    }
                                }
                            }
                        }
                        catch (SocketTimeoutException ex2) {
                            CLIHandler.enterState(33, block);
                        }
                        catch (ConnectException ex2) {
                            CLIHandler.enterState(33, block);
                        }
                        catch (IOException ex2) {
                            ex2.printStackTrace();
                            CLIHandler.enterState(33, block);
                        }
                    }
                    if (cleanLockFile) {
                        lockFile.delete();
                    } else {
                        return new Status(-255);
                    }
                }
                try {
                    CLIHandler.enterState(83, block);
                    Thread.sleep((int)(Math.random() * 1000.0));
                    CLIHandler.enterState(85, block);
                }
                catch (InterruptedException ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        return new Status();
    }

    static {
        $assertionsDisabled = !CLIHandler.class.desiredAssertionStatus();
        doLater = new ArrayList();
    }

    private static final class Server
    extends Thread {
        private byte[] key;
        private ServerSocket socket;
        private Integer block;
        private List handlers;
        private Socket work;
        private static volatile int counter;
        private final boolean failOnUnknownOptions;

        public Server(byte[] key, Integer block, List handlers, boolean failOnUnknownOptions) throws IOException {
            super("CLI Requests Server");
            this.key = key;
            this.setDaemon(true);
            this.block = block;
            this.handlers = handlers;
            this.failOnUnknownOptions = failOnUnknownOptions;
            this.socket = new ServerSocket(0);
            this.start();
        }

        public Server(Socket request, byte[] key, Integer block, List handlers, boolean failOnUnknownOptions) throws IOException {
            super("CLI Handler Thread Handler: " + ++counter);
            this.key = key;
            this.setDaemon(true);
            this.block = block;
            this.handlers = handlers;
            this.work = request;
            this.failOnUnknownOptions = failOnUnknownOptions;
            this.start();
        }

        public int getLocalPort() {
            return this.socket.getLocalPort();
        }

        public void run() {
            if (this.work != null) {
                try {
                    this.handleConnect(this.work);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return;
            }
            while (this.socket != null) {
                try {
                    CLIHandler.enterState(65, this.block);
                    Socket s = this.socket.accept();
                    new Server(s, this.key, this.block, this.handlers, this.failOnUnknownOptions);
                }
                catch (SocketException ex) {
                    if (this.socket == null) continue;
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }

        final void stopServer() {
            try {
                ServerSocket s = this.socket;
                if (s == null) {
                    return;
                }
                this.socket = null;
                s.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private void handleConnect(Socket s) throws IOException {
            byte[] check = new byte[this.key.length];
            DataInputStream is = new DataInputStream(s.getInputStream());
            CLIHandler.enterState(70, this.block);
            is.readFully(check);
            CLIHandler.enterState(90, this.block);
            DataOutputStream os = new DataOutputStream(s.getOutputStream());
            if (Arrays.equals(check, this.key)) {
                while (!CLIHandler.waitFinishInstallationIsOver(2000)) {
                    os.write(3);
                    os.flush();
                }
                CLIHandler.enterState(93, this.block);
                os.write(1);
                os.flush();
                int numberOfArguments = is.readInt();
                String[] args = new String[numberOfArguments];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = is.readUTF();
                }
                String currentDir = is.readUTF();
                Args arguments = new Args(args, new IS(is, os), new OS(is, os), currentDir);
                class ComputingAndNotifying
                extends Thread {
                    public int res;
                    public boolean finished;
                    private final /* synthetic */ Args val$arguments;
                    private final /* synthetic */ DataOutputStream val$os;
                    private final /* synthetic */ Server this$0;

                    public ComputingAndNotifying(Server this$0, Args val$arguments, DataOutputStream val$os) {
                        this.this$0 = this$0;
                        this.val$arguments = val$arguments;
                        this.val$os = val$os;
                        super("Computes values in handlers");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ComputingAndNotifying computingAndNotifying;
                        try {
                            this.res = CLIHandler.access$000(this.val$arguments, Server.access$300(this.this$0), 2, Server.access$400(this.this$0), false);
                            if (this.res == 0) {
                                CLIHandler.access$100(98, Server.access$500(this.this$0));
                            } else {
                                CLIHandler.access$100(99, Server.access$500(this.this$0));
                            }
                            Object var2_1 = null;
                            computingAndNotifying = this;
                        }
                        catch (Throwable throwable) {
                            Object var2_2 = null;
                            ComputingAndNotifying computingAndNotifying2 = this;
                            synchronized (computingAndNotifying2) {
                                this.finished = true;
                                this.notifyAll();
                            }
                            throw throwable;
                        }
                        synchronized (computingAndNotifying) {
                            this.finished = true;
                            this.notifyAll();
                        }
                    }

                    public synchronized void waitForResultAndNotifyOthers() {
                        this.start();
                        while (!this.finished) {
                            try {
                                this.wait(1000L);
                                this.val$os.write(3);
                                this.val$os.flush();
                            }
                            catch (InterruptedException ex) {
                                ex.printStackTrace();
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                    }
                }
                ComputingAndNotifying r = new ComputingAndNotifying(this, arguments, os);
                r.waitForResultAndNotifyOthers();
                os.write(2);
                os.writeInt(r.res);
            } else {
                CLIHandler.enterState(103, this.block);
                os.write(0);
            }
            CLIHandler.enterState(120, this.block);
            os.close();
            is.close();
        }

        static /* synthetic */ List access$300(Server x0) {
            return x0.handlers;
        }

        static /* synthetic */ boolean access$400(Server x0) {
            return x0.failOnUnknownOptions;
        }

        static /* synthetic */ Integer access$500(Server x0) {
            return x0.block;
        }

        private static final class OS
        extends OutputStream {
            private DataOutputStream os;

            public OS(DataInputStream is, DataOutputStream os) {
                this.os = os;
            }

            public void write(int b) throws IOException {
                byte[] arr = new byte[]{(byte)b};
                this.write(arr);
            }

            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            public void close() throws IOException {
                super.close();
            }

            public void flush() throws IOException {
                this.os.flush();
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.os.write(11);
                this.os.writeInt(len);
                this.os.write(b, off, len);
            }
        }

        private static final class IS
        extends InputStream {
            private DataInputStream is;
            private DataOutputStream os;

            public IS(DataInputStream is, DataOutputStream os) {
                this.is = is;
                this.os = os;
            }

            public int read() throws IOException {
                byte[] arr = new byte[1];
                if (this.read(arr) == 1) {
                    return arr[0];
                }
                return -1;
            }

            public void close() throws IOException {
                super.close();
            }

            public int available() throws IOException {
                this.os.write(12);
                this.os.flush();
                return this.is.readInt();
            }

            public int read(byte[] b) throws IOException {
                return this.read(b, 0, b.length);
            }

            public int read(byte[] b, int off, int len) throws IOException {
                this.os.write(10);
                this.os.writeInt(len);
                this.os.flush();
                int really = this.is.read();
                if (really > 0) {
                    return this.is.read(b, off, really);
                }
                return really;
            }
        }
    }

    public static final class Args {
        private String[] args;
        private final String[] argsBackup;
        private InputStream is;
        private OutputStream os;
        private File currentDir;

        Args(String[] args, InputStream is, OutputStream os, String currentDir) {
            this.argsBackup = args;
            this.reset(false);
            this.is = is;
            this.os = os;
            this.currentDir = new File(currentDir);
        }

        void reset(boolean consume) {
            if (consume) {
                String[] a = this.args;
                if (a == null) {
                    a = this.argsBackup;
                }
                ArrayList<String> l = new ArrayList<String>(Arrays.asList(a));
                l.removeAll(Collections.singleton(null));
                this.args = l.toArray(new String[l.size()]);
            } else {
                this.args = (String[])this.argsBackup.clone();
            }
        }

        public String[] getArguments() {
            return this.args;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        public File getCurrentDirectory() {
            return this.currentDir;
        }

        public InputStream getInputStream() {
            return this.is;
        }
    }

    static interface Execute {
        public int exec();
    }

    static final class Status {
        public static final int CANNOT_CONNECT = -255;
        private final File lockFile;
        private final int port;
        private int exitCode;

        Status() {
            this(0);
        }

        Status(int c) {
            this(null, 0, c);
        }

        Status(File l, int p, int c) {
            this.lockFile = l;
            this.port = p;
            this.exitCode = c;
        }

        public File getLockFile() {
            return this.lockFile;
        }

        public int getServerPort() {
            return this.port;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

