/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.pushingpixels.neon.api.NeonCortex;
import org.pushingpixels.neon.internal.contrib.jgoodies.looks.LookUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceComponentPlugin;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.SubstancePluginRepository;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopupFactory;
import org.pushingpixels.substance.internal.ui.SubstanceButtonUI;
import org.pushingpixels.substance.internal.ui.SubstanceCheckBoxMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceCheckBoxUI;
import org.pushingpixels.substance.internal.ui.SubstanceComboBoxUI;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopIconUI;
import org.pushingpixels.substance.internal.ui.SubstanceDesktopPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceEditorPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceFileChooserUI;
import org.pushingpixels.substance.internal.ui.SubstanceFormattedTextFieldUI;
import org.pushingpixels.substance.internal.ui.SubstanceInternalFrameUI;
import org.pushingpixels.substance.internal.ui.SubstanceLabelUI;
import org.pushingpixels.substance.internal.ui.SubstanceListUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuBarUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceMenuUI;
import org.pushingpixels.substance.internal.ui.SubstanceOptionPaneUI;
import org.pushingpixels.substance.internal.ui.SubstancePanelUI;
import org.pushingpixels.substance.internal.ui.SubstancePasswordFieldUI;
import org.pushingpixels.substance.internal.ui.SubstancePopupMenuSeparatorUI;
import org.pushingpixels.substance.internal.ui.SubstancePopupMenuUI;
import org.pushingpixels.substance.internal.ui.SubstanceProgressBarUI;
import org.pushingpixels.substance.internal.ui.SubstanceRadioButtonMenuItemUI;
import org.pushingpixels.substance.internal.ui.SubstanceRadioButtonUI;
import org.pushingpixels.substance.internal.ui.SubstanceRootPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceScrollBarUI;
import org.pushingpixels.substance.internal.ui.SubstanceScrollPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceSeparatorUI;
import org.pushingpixels.substance.internal.ui.SubstanceSliderUI;
import org.pushingpixels.substance.internal.ui.SubstanceSpinnerUI;
import org.pushingpixels.substance.internal.ui.SubstanceSplitPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceTabbedPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceTableHeaderUI;
import org.pushingpixels.substance.internal.ui.SubstanceTableUI;
import org.pushingpixels.substance.internal.ui.SubstanceTextAreaUI;
import org.pushingpixels.substance.internal.ui.SubstanceTextFieldUI;
import org.pushingpixels.substance.internal.ui.SubstanceTextPaneUI;
import org.pushingpixels.substance.internal.ui.SubstanceToggleButtonUI;
import org.pushingpixels.substance.internal.ui.SubstanceToolBarSeparatorUI;
import org.pushingpixels.substance.internal.ui.SubstanceToolBarUI;
import org.pushingpixels.substance.internal.ui.SubstanceToolTipUI;
import org.pushingpixels.substance.internal.ui.SubstanceTreeUI;
import org.pushingpixels.substance.internal.ui.SubstanceViewportUI;
import org.pushingpixels.substance.internal.utils.ImageWrapperIcon;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.MemoryAnalyzer;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceImageCreator;

public abstract class SubstanceLookAndFeel
extends BasicLookAndFeel {
    private SubstanceSkin skin;
    private String name;
    private AWTEventListener awtEventListener;

    protected SubstanceLookAndFeel(SubstanceSkin skin) {
        this.skin = skin;
        this.name = "Substance " + skin.getDisplayName();
    }

    @Override
    public String getDescription() {
        return "Substance Look and Feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        Object[] uiDefaults = new Object[]{"ButtonUI", SubstanceButtonUI.class.getName(), "CheckBoxUI", SubstanceCheckBoxUI.class.getName(), "ComboBoxUI", SubstanceComboBoxUI.class.getName(), "CheckBoxMenuItemUI", SubstanceCheckBoxMenuItemUI.class.getName(), "DesktopIconUI", SubstanceDesktopIconUI.class.getName(), "DesktopPaneUI", SubstanceDesktopPaneUI.class.getName(), "EditorPaneUI", SubstanceEditorPaneUI.class.getName(), "FileChooserUI", SubstanceFileChooserUI.class.getName(), "FormattedTextFieldUI", SubstanceFormattedTextFieldUI.class.getName(), "InternalFrameUI", SubstanceInternalFrameUI.class.getName(), "LabelUI", SubstanceLabelUI.class.getName(), "ListUI", SubstanceListUI.class.getName(), "MenuUI", SubstanceMenuUI.class.getName(), "MenuBarUI", SubstanceMenuBarUI.class.getName(), "MenuItemUI", SubstanceMenuItemUI.class.getName(), "OptionPaneUI", SubstanceOptionPaneUI.class.getName(), "PanelUI", SubstancePanelUI.class.getName(), "PasswordFieldUI", SubstancePasswordFieldUI.class.getName(), "PopupMenuUI", SubstancePopupMenuUI.class.getName(), "PopupMenuSeparatorUI", SubstancePopupMenuSeparatorUI.class.getName(), "ProgressBarUI", SubstanceProgressBarUI.class.getName(), "RadioButtonUI", SubstanceRadioButtonUI.class.getName(), "RadioButtonMenuItemUI", SubstanceRadioButtonMenuItemUI.class.getName(), "RootPaneUI", SubstanceRootPaneUI.class.getName(), "ScrollBarUI", SubstanceScrollBarUI.class.getName(), "ScrollPaneUI", SubstanceScrollPaneUI.class.getName(), "SeparatorUI", SubstanceSeparatorUI.class.getName(), "SliderUI", SubstanceSliderUI.class.getName(), "SpinnerUI", SubstanceSpinnerUI.class.getName(), "SplitPaneUI", SubstanceSplitPaneUI.class.getName(), "TabbedPaneUI", SubstanceTabbedPaneUI.class.getName(), "TableUI", SubstanceTableUI.class.getName(), "TableHeaderUI", SubstanceTableHeaderUI.class.getName(), "TextAreaUI", SubstanceTextAreaUI.class.getName(), "TextFieldUI", SubstanceTextFieldUI.class.getName(), "TextPaneUI", SubstanceTextPaneUI.class.getName(), "ToggleButtonUI", SubstanceToggleButtonUI.class.getName(), "ToolBarUI", SubstanceToolBarUI.class.getName(), "ToolBarSeparatorUI", SubstanceToolBarSeparatorUI.class.getName(), "ToolTipUI", SubstanceToolTipUI.class.getName(), "TreeUI", SubstanceTreeUI.class.getName(), "ViewportUI", SubstanceViewportUI.class.getName()};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        SubstanceCortex.GlobalScope.initFontDefaults(table);
        this.skin.addCustomEntriesToTable(table);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (NeonCortex.getPlatform() != NeonCortex.Platform.MACOS || !LookUtils.IS_OS_MAC_MOJAVE_OR_LATER) {
            Object aaHint;
            Map desktopHints = (Map)toolkit.getDesktopProperty("awt.font.desktophints");
            Object v0 = aaHint = desktopHints == null ? null : desktopHints.get(RenderingHints.KEY_TEXT_ANTIALIASING);
            if (aaHint != null && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_OFF && aaHint != RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT) {
                table.put(RenderingHints.KEY_TEXT_ANTIALIASING, (Object)aaHint);
                table.put(RenderingHints.KEY_TEXT_LCD_CONTRAST, desktopHints.get(RenderingHints.KEY_TEXT_LCD_CONTRAST));
            }
        }
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        SubstancePluginRepository.getInstance().processAllDefaultsEntriesComponentPlugins(table, this.skin);
        return table;
    }

    @Override
    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
        SubstanceCortex.GlobalScope.setSkin(this.skin, false);
        String traceFilename = (String)UIManager.get("substancelaf.internal.traceFile");
        if (traceFilename != null) {
            MemoryAnalyzer.commence(1000L, traceFilename);
            for (SubstanceComponentPlugin plugin : SubstancePluginRepository.getInstance().getComponentPlugins()) {
                MemoryAnalyzer.enqueueUsage("Has plugin '" + plugin.getClass().getName() + "'");
            }
        }
        SubstancePluginRepository.getInstance().initializeAllComponentPlugins();
        this.awtEventListener = event -> {
            List<AWTEventListener> eventListeners = SubstanceCoreUtilities.getAwtEventListeners();
            for (int i = eventListeners.size() - 1; i >= 0; --i) {
                eventListeners.get(i).eventDispatched(event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.awtEventListener, 131096L);
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtEventListener);
        SubstanceCortex.GlobalScope.unsetSkin();
        ShadowPopupFactory.uninstall();
        SubstanceCoreUtilities.stopThreads();
        if (this.skin.getWatermark() != null) {
            this.skin.getWatermark().dispose();
        }
        SubstancePluginRepository.getInstance().uninitializeAllComponentPlugins();
        LazyResettableHashMap.reset();
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    @Override
    public Icon getDisabledIcon(JComponent component, Icon icon) {
        if (icon == null) {
            return null;
        }
        SubstanceColorScheme colorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ComponentState.DISABLED_UNSELECTED);
        BufferedImage result = SubstanceImageCreator.getColorSchemeImage(component, icon, colorScheme, 0.5f);
        float alpha = SubstanceColorSchemeUtilities.getAlpha(component, ComponentState.DISABLED_UNSELECTED);
        if (alpha < 1.0f) {
            BufferedImage intermediate = SubstanceCoreUtilities.getBlankUnscaledImage(result.getWidth(), result.getHeight());
            Graphics2D g2d = intermediate.createGraphics();
            g2d.setComposite(AlphaComposite.SrcOver.derive(alpha));
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2d.drawImage(result, 0, 0, result.getWidth(), result.getHeight(), null);
            g2d.dispose();
            result = intermediate;
        }
        return new ImageWrapperIcon(result);
    }
}

