/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.SubstanceSlices;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.ClassicFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopShadowOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public class SentinelSkin
extends SubstanceSkin {
    public static final String NAME = "Sentinel";

    public SentinelSkin() {
        SubstanceSkin.ColorSchemes schemes = SubstanceSkin.getColorSchemes(this.getClass().getClassLoader().getResourceAsStream("org/pushingpixels/substance/api/skin/sentinel.colorschemes"));
        SubstanceColorScheme activeScheme = schemes.get("Sentinel Active");
        SubstanceColorScheme enabledScheme = schemes.get("Sentinel Enabled");
        SubstanceColorScheme disabledScheme = schemes.get("Sentinel Disabled");
        SubstanceColorScheme disabledSelectedScheme = schemes.get("Sentinel Disabled Selected");
        SubstanceColorSchemeBundle defaultSchemeBundle = new SubstanceColorSchemeBundle(activeScheme, enabledScheme, disabledScheme);
        defaultSchemeBundle.registerAlpha(0.6f, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        defaultSchemeBundle.registerColorScheme(disabledScheme, ComponentState.DISABLED_UNSELECTED);
        defaultSchemeBundle.registerColorScheme(disabledSelectedScheme, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme borderScheme = schemes.get("Sentinel Border");
        defaultSchemeBundle.registerColorScheme(borderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markScheme = schemes.get("Sentinel Mark");
        defaultSchemeBundle.registerColorScheme(markScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        SubstanceColorScheme separatorScheme = schemes.get("Sentinel Separator");
        defaultSchemeBundle.registerColorScheme(separatorScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        defaultSchemeBundle.registerColorScheme(schemes.get("Sentinel Tab Border"), SubstanceSlices.ColorSchemeAssociationKind.TAB_BORDER, ComponentState.getActiveStates());
        SubstanceColorScheme highlightScheme = schemes.get("Sentinel Highlight");
        defaultSchemeBundle.registerHighlightColorScheme(highlightScheme, new ComponentState[0]);
        SubstanceColorScheme backgroundScheme = schemes.get("Sentinel Background");
        this.registerDecorationAreaSchemeBundle(defaultSchemeBundle, backgroundScheme, SubstanceSlices.DecorationAreaType.NONE);
        SubstanceColorScheme activeDecorationsScheme = schemes.get("Sentinel Decorations Active");
        SubstanceColorScheme enabledDecorationsScheme = schemes.get("Sentinel Decorations Enabled");
        SubstanceColorSchemeBundle decorationsSchemeBundle = new SubstanceColorSchemeBundle(activeDecorationsScheme, enabledDecorationsScheme, enabledDecorationsScheme);
        decorationsSchemeBundle.registerAlpha(0.4f, ComponentState.DISABLED_UNSELECTED);
        decorationsSchemeBundle.registerColorScheme(enabledDecorationsScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme borderDecorationsScheme = schemes.get("Sentinel Decorations Border");
        decorationsSchemeBundle.registerColorScheme(borderDecorationsScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markDecorationsScheme = schemes.get("Sentinel Decorations Mark");
        decorationsSchemeBundle.registerColorScheme(markDecorationsScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        SubstanceColorScheme separatorDecorationsScheme = schemes.get("Sentinel Decorations Separator");
        decorationsSchemeBundle.registerColorScheme(separatorDecorationsScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme decorationsBackgroundScheme = schemes.get("Sentinel Decorations Background");
        this.registerDecorationAreaSchemeBundle(decorationsSchemeBundle, decorationsBackgroundScheme, SubstanceSlices.DecorationAreaType.TOOLBAR, SubstanceSlices.DecorationAreaType.FOOTER);
        SubstanceColorScheme activeGeneralScheme = schemes.get("Sentinel General Active");
        SubstanceColorScheme enabledGeneralScheme = schemes.get("Sentinel General Enabled");
        SubstanceColorSchemeBundle generalSchemeBundle = new SubstanceColorSchemeBundle(activeGeneralScheme, enabledGeneralScheme, enabledGeneralScheme);
        generalSchemeBundle.registerAlpha(0.4f, ComponentState.DISABLED_UNSELECTED);
        generalSchemeBundle.registerColorScheme(enabledGeneralScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme borderGeneralScheme = schemes.get("Sentinel General Border");
        generalSchemeBundle.registerColorScheme(borderGeneralScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme markGeneralScheme = schemes.get("Sentinel General Mark");
        generalSchemeBundle.registerColorScheme(markGeneralScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.getActiveStates());
        SubstanceColorScheme separatorGeneralScheme = schemes.get("Sentinel General Separator");
        generalSchemeBundle.registerColorScheme(separatorGeneralScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme generalBackgroundScheme = schemes.get("Sentinel General Background");
        this.registerDecorationAreaSchemeBundle(generalSchemeBundle, generalBackgroundScheme, SubstanceSlices.DecorationAreaType.GENERAL);
        SubstanceColorScheme activeHeaderScheme = schemes.get("Sentinel Header Active");
        SubstanceColorScheme enabledHeaderScheme = schemes.get("Sentinel Header Enabled");
        SubstanceColorScheme disabledHeaderScheme = schemes.get("Sentinel Header Disabled");
        SubstanceColorSchemeBundle headerSchemeBundle = new SubstanceColorSchemeBundle(activeHeaderScheme, enabledHeaderScheme, disabledHeaderScheme);
        headerSchemeBundle.registerAlpha(0.95f, ComponentState.DISABLED_UNSELECTED);
        headerSchemeBundle.registerColorScheme(disabledHeaderScheme, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme headerBorderScheme = schemes.get("Sentinel Header Border");
        headerSchemeBundle.registerColorScheme(headerBorderScheme, SubstanceSlices.ColorSchemeAssociationKind.BORDER, new ComponentState[0]);
        SubstanceColorScheme headerMarkScheme = schemes.get("Sentinel Header Mark");
        headerSchemeBundle.registerColorScheme(headerMarkScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, new ComponentState[0]);
        headerSchemeBundle.registerColorScheme(disabledHeaderScheme, SubstanceSlices.ColorSchemeAssociationKind.MARK, ComponentState.DISABLED_UNSELECTED, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme separatorHeaderScheme = schemes.get("Sentinel Header Separator");
        headerSchemeBundle.registerColorScheme(separatorHeaderScheme, SubstanceSlices.ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        headerSchemeBundle.registerHighlightAlpha(0.85f, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ROLLOVER_ARMED, ComponentState.ARMED);
        headerSchemeBundle.registerHighlightAlpha(0.9f, ComponentState.SELECTED);
        headerSchemeBundle.registerHighlightAlpha(1.0f, ComponentState.ROLLOVER_SELECTED);
        headerSchemeBundle.registerHighlightColorScheme(highlightScheme, new ComponentState[0]);
        SubstanceColorScheme headerBackgroundScheme = schemes.get("Sentinel Header Background");
        this.registerDecorationAreaSchemeBundle(headerSchemeBundle, headerBackgroundScheme, SubstanceSlices.DecorationAreaType.PRIMARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.SECONDARY_TITLE_PANE, SubstanceSlices.DecorationAreaType.HEADER);
        this.setTabFadeStart(0.2);
        this.setTabFadeEnd(0.9);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(100), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(new BottomLineOverlayPainter(scheme -> SubstanceColorUtilities.deriveByBrightness(scheme.getUltraDarkColor(), -0.1f)), SubstanceSlices.DecorationAreaType.TOOLBAR);
        this.addOverlayPainter(TopShadowOverlayPainter.getInstance(15), SubstanceSlices.DecorationAreaType.FOOTER);
        this.addOverlayPainter(new TopLineOverlayPainter(scheme -> SubstanceColorUtilities.deriveByBrightness(scheme.getUltraDarkColor(), -0.1f)), SubstanceSlices.DecorationAreaType.FOOTER);
        this.setTabFadeStart(0.18);
        this.setTabFadeEnd(0.18);
        this.buttonShaper = new ClassicButtonShaper();
        this.watermark = null;
        this.fillPainter = new ClassicFillPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.highlightPainter = new ClassicHighlightPainter();
        this.borderPainter = new ClassicBorderPainter();
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }
}

