/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.plaf.UIResource;
import org.pushingpixels.neon.api.icon.ResizableIcon;
import org.pushingpixels.substance.api.SubstanceCortex;
import org.pushingpixels.substance.api.colorscheme.SubstanceColorScheme;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.DefaultPalettes;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntry;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteEntryCellRenderer;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.PaletteListModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.SubstanceColorChooserPanel;

public class ColorPalettesChooser
extends SubstanceColorChooserPanel
implements UIResource {
    private static int lastSelectedPalette = 0;
    private JComboBox paletteCombo;
    private JLabel paletteLabel;
    private JList paletteList;
    private JScrollPane paletteScrollPane;

    public ColorPalettesChooser() {
        this.initComponents();
        Font font = UIManager.getFont("ColorChooser.font");
        this.paletteLabel.setFont(font);
        this.paletteCombo.setFont(font);
        this.paletteScrollPane.setFont(font);
        this.paletteList.setFont(font);
        this.paletteList.setCellRenderer(new PaletteEntryCellRenderer());
        DefaultComboBoxModel cbm = new DefaultComboBoxModel(this.loadPalettes());
        this.paletteCombo.setModel(cbm);
        this.paletteList.getSelectionModel().addListSelectionListener(e -> {
            PaletteEntry entry = (PaletteEntry)this.paletteList.getSelectedValue();
            if (entry != null) {
                PaletteListModel lm = (PaletteListModel)this.paletteList.getModel();
                lm.setClosestIndex(-1);
                this.setColorToModel(entry.getColor());
            }
        });
        this.paletteCombo.setSelectedIndex(lastSelectedPalette);
        this.loadPalettes();
        this.updatePaletteList();
    }

    protected Vector loadPalettes() {
        int i;
        Vector<PaletteListModel> palettes = new Vector<PaletteListModel>();
        Color[] colors = DefaultPalettes.APPLE_COLORS;
        PaletteEntry[] entries = new PaletteEntry[colors.length];
        for (i = 0; i < colors.length; ++i) {
            entries[i] = new PaletteEntry(UIManager.getString("ColorChooser.apple." + Integer.toHexString(0xFF000000 | colors[i].getRGB()).substring(2)), colors[i]);
        }
        palettes.add(new PaletteListModel(UIManager.getString("ColorChooser.appleColors"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.appleColors"), entries.length), entries));
        colors = DefaultPalettes.CRAYONS;
        entries = new PaletteEntry[colors.length];
        for (i = 0; i < colors.length; ++i) {
            entries[i % 8 + colors.length - i / 8 * 8 - 8] = new PaletteEntry(UIManager.getString("ColorChooser.crayon." + Integer.toHexString(0xFF000000 | colors[i].getRGB()).substring(2)), colors[i]);
        }
        palettes.add(new PaletteListModel(UIManager.getString("ColorChooser.crayons"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.crayons"), entries.length), entries));
        colors = DefaultPalettes.WEB_SAFE_COLORS;
        entries = new PaletteEntry[colors.length];
        for (i = 0; i < colors.length; ++i) {
            entries[i] = new PaletteEntry(Integer.toHexString(0xFF000000 | colors[i].getRGB()).substring(2).toUpperCase(), colors[i]);
        }
        palettes.add(new PaletteListModel(UIManager.getString("ColorChooser.webSafeColors"), MessageFormat.format(UIManager.getString("ColorChooser.profileContainsNColors"), UIManager.getString("ColorChooser.webSafeColors"), entries.length), entries));
        return palettes;
    }

    private void updatePaletteList() {
        PaletteListModel palette = (PaletteListModel)this.paletteCombo.getSelectedItem();
        this.paletteList.setModel(palette);
        this.paletteCombo.setToolTipText(palette.getInfo());
        this.updateChooser();
    }

    @Override
    protected void buildChooser() {
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.colorPalettes");
    }

    @Override
    public ResizableIcon getHiDpiAwareIcon(int size, SubstanceColorScheme colorScheme) {
        return SubstanceCortex.GlobalScope.getIconPack().getColorChooserColorPalettesIcon(size, colorScheme);
    }

    @Override
    public void updateChooser() {
        int i;
        Color color;
        try {
            color = this.getColorFromModel();
        }
        catch (NullPointerException e) {
            return;
        }
        int rgb = color == null ? 0 : color.getRGB() & 0xFFFFFF;
        PaletteEntry entry = (PaletteEntry)this.paletteList.getSelectedValue();
        if (entry != null && (entry.getColor().getRGB() & 0xFFFFFF) == rgb) {
            return;
        }
        PaletteListModel lm = (PaletteListModel)this.paletteList.getModel();
        int n = lm.getSize();
        for (i = 0; i < n && ((entry = (PaletteEntry)lm.getElementAt(i)).getColor().getRGB() & 0xFFFFFF) != rgb; ++i) {
        }
        if (i < n) {
            lm.setClosestIndex(-1);
            this.paletteList.setSelectedIndex(i);
            this.paletteList.scrollRectToVisible(this.paletteList.getCellBounds(i, i));
        } else {
            this.paletteList.clearSelection();
            int closest = lm.computeClosestIndex(color);
            lm.setClosestIndex(closest);
            if (closest != -1) {
                this.paletteList.scrollRectToVisible(this.paletteList.getCellBounds(closest, closest));
            }
        }
    }

    public void setColorToModel(Color color) {
        ColorSelectionModel colorSelectionModel = this.getColorSelectionModel();
        if (colorSelectionModel != null) {
            colorSelectionModel.setSelectedColor(color);
        }
    }

    private void initComponents() {
        this.paletteLabel = new JLabel();
        this.paletteCombo = new JComboBox();
        this.paletteScrollPane = new JScrollPane();
        this.paletteList = new JList();
        this.setLayout(new GridBagLayout());
        this.paletteLabel.setLabelFor(this.paletteCombo);
        this.paletteLabel.setText(UIManager.getString("ColorChooser.list"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.add((Component)this.paletteLabel, gridBagConstraints);
        this.paletteCombo.addItemListener(this::paletteChanged);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.paletteCombo, gridBagConstraints);
        this.paletteScrollPane.setHorizontalScrollBarPolicy(31);
        this.paletteScrollPane.setVerticalScrollBarPolicy(22);
        this.paletteList.setSelectionMode(0);
        this.paletteScrollPane.setViewportView(this.paletteList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.paletteScrollPane, gridBagConstraints);
    }

    private void paletteChanged(ItemEvent evt) {
        this.updatePaletteList();
        lastSelectedPalette = this.paletteCombo.getSelectedIndex();
    }
}

