/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.VisualMargin;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.substance.internal.ui.SubstanceSliderUI;
import org.pushingpixels.substance.internal.utils.RolloverControlListener;

public class ColorSliderUI
extends SubstanceSliderUI
implements TransitionAwareUI {
    private static final Color foreground = new Color(0x949494);
    private static final Color trackBackground = new Color(0xFFFFFF);
    protected Integer componentIndex;
    protected ColorSliderModel colorSliderModel;
    private ButtonModel thumbModel = new DefaultButtonModel();
    private RolloverControlListener substanceRolloverListener;
    private PropertyChangeListener substancePropertyChangeListener;
    protected StateTransitionTracker stateTransitionTracker;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(36, 20);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(26, 100);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 20);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(26, 36);

    public ColorSliderUI(JSlider b) {
        super(b);
        this.thumbModel.setArmed(false);
        this.thumbModel.setSelected(false);
        this.thumbModel.setPressed(false);
        this.thumbModel.setRollover(false);
        this.thumbModel.setEnabled(b.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(b, this.thumbModel);
    }

    public static ComponentUI createUI(JComponent b) {
        return new ColorSliderUI((JSlider)b);
    }

    @Override
    protected void installDefaults(JSlider slider) {
        super.installDefaults(slider);
        this.focusInsets = new Insets(0, 0, 0, 0);
        slider.setOpaque(false);
        if (slider.getOrientation() == 0) {
            slider.setBorder(new VisualMargin(0, 1, -1, 1));
        } else {
            slider.setBorder(new VisualMargin(0, 0, 0, 1));
        }
        slider.setRequestFocusEnabled(true);
    }

    @Override
    protected void installListeners(JSlider slider) {
        super.installListeners(slider);
        this.substanceRolloverListener = new RolloverControlListener(this, this.thumbModel);
        slider.addMouseListener(this.substanceRolloverListener);
        slider.addMouseMotionListener(this.substanceRolloverListener);
        this.substancePropertyChangeListener = evt -> {
            if ("enabled".equals(evt.getPropertyName())) {
                this.thumbModel.setEnabled(slider.isEnabled());
            }
            if ("font".equals(evt.getPropertyName())) {
                SwingUtilities.invokeLater(slider::updateUI);
            }
        };
        this.slider.addPropertyChangeListener(this.substancePropertyChangeListener);
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
    }

    @Override
    protected void uninstallListeners(JSlider slider) {
        super.uninstallListeners(slider);
        slider.removeMouseListener(this.substanceRolloverListener);
        slider.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        slider.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return PREFERRED_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return PREFERRED_VERTICAL_SIZE;
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return MINIMUM_HORIZONTAL_SIZE;
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return MINIMUM_VERTICAL_SIZE;
    }

    @Override
    protected void calculateThumbLocation() {
        super.calculateThumbLocation();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y += 3;
        } else {
            --this.thumbRect.x;
        }
    }

    @Override
    public void paintTrack(Graphics g) {
        int ch;
        int cw;
        int cy;
        int cx;
        Rectangle trackBounds = this.trackRect;
        if (this.slider.getOrientation() == 0) {
            int pad = this.trackBuffer;
            cx = trackBounds.x - pad + 1;
            cy = trackBounds.y;
            cw = trackBounds.width + pad * 2 - 2;
            ch = trackBounds.height;
        } else {
            int pad = this.trackBuffer;
            cx = trackBounds.x;
            cy = this.contentRect.y + 2;
            cw = trackBounds.width - 1;
            ch = trackBounds.height + pad * 2 - 5;
        }
        g.setColor(trackBackground);
        g.fillRect(cx, cy, cw, ch);
        g.setColor(foreground);
        g.drawRect(cx, cy, cw - 1, ch - 1);
        this.paintColorTrack(g, cx + 2, cy + 2, cw - 4, ch - 4, this.trackBuffer);
    }

    @Override
    public void paintTicks(Graphics g) {
        Rectangle tickBounds = this.tickRect;
        g.setColor(foreground);
        if (this.slider.getOrientation() == 0) {
            int xPos;
            int value;
            g.translate(0, tickBounds.y);
            if (this.slider.getMinorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMinorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMinorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (value = this.slider.getMinimum(); value <= this.slider.getMaximum(); value += this.slider.getMajorTickSpacing()) {
                    xPos = this.xPositionForValue(value);
                    this.paintMajorTickForHorizSlider(g, tickBounds, xPos);
                }
            }
            g.translate(0, -tickBounds.y);
        } else {
            int yPos;
            g.translate(tickBounds.x, 0);
            int value = this.slider.getMinimum();
            if (this.slider.getMinorTickSpacing() > 0) {
                int offset = 0;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    offset = tickBounds.width - tickBounds.width / 2;
                    g.translate(offset, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMinorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMinorTickSpacing();
                }
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    g.translate(-offset, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                value = this.slider.getMinimum();
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    g.translate(2, 0);
                }
                while (value <= this.slider.getMaximum()) {
                    yPos = this.yPositionForValue(value);
                    this.paintMajorTickForVertSlider(g, tickBounds, yPos);
                    value += this.slider.getMajorTickSpacing();
                }
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    g.translate(-2, 0);
                }
            }
            g.translate(-tickBounds.x, 0);
        }
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 1);
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics g, Rectangle tickBounds, int x) {
        g.drawLine(x, 0, x, tickBounds.height - 1);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(tickBounds.width / 2, y, tickBounds.width / 2 - 1, y);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics g, Rectangle tickBounds, int y) {
        g.drawLine(0, y, tickBounds.width - 1, y);
    }

    @Override
    public void paintFocus(Graphics g) {
    }

    private void paintColorTrack(Graphics g, int x, int y, int width, int height, int buffer) {
        Color[] colorArray;
        int x2 = x;
        int y2 = y;
        if (this.slider.getOrientation() == 0) {
            x2 += width;
        } else {
            y2 += height;
        }
        if (this.componentIndex == null) {
            this.componentIndex = (Integer)this.slider.getClientProperty("ColorComponentIndex");
        }
        if (this.colorSliderModel == null) {
            this.colorSliderModel = (ColorSliderModel)this.slider.getClientProperty("ColorSliderModel");
        }
        Graphics2D gg = (Graphics2D)g.create();
        Color c1 = new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, 0.0f), true);
        Color c2 = new Color(this.colorSliderModel.getInterpolatedRGB(this.componentIndex, 1.0f));
        float f = x;
        float f2 = y;
        float f3 = x2;
        float f4 = y2;
        float[] fArray = new float[]{0.0f, 1.0f};
        if (this.slider.getOrientation() == 0) {
            Color[] colorArray2 = new Color[2];
            colorArray2[0] = c1;
            colorArray = colorArray2;
            colorArray2[1] = c2;
        } else {
            Color[] colorArray3 = new Color[2];
            colorArray3[0] = c2;
            colorArray = colorArray3;
            colorArray3[1] = c1;
        }
        gg.setPaint(new LinearGradientPaint(f, f2, f3, f4, fArray, colorArray));
        gg.fillRect(x, y, width, height);
        gg.dispose();
    }

    @Override
    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.x = this.contentRect.x + this.trackBuffer + 1;
            this.trackRect.height = 13;
            this.trackRect.y = this.contentRect.y + this.contentRect.height - this.trackRect.height;
            this.trackRect.width = this.contentRect.width - this.trackBuffer * 2 - 1;
        } else {
            this.trackRect.width = 14;
            this.trackRect.x = this.contentRect.x + this.contentRect.width - this.trackRect.width;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.height = this.contentRect.height - this.trackBuffer * 2 + 1;
        }
    }

    @Override
    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y - this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            this.tickRect.width = this.getTickLength();
            this.tickRect.x = this.contentRect.x;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    @Override
    protected int getTickLength() {
        return 4;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider slider) {
        return new CSUIPropertyChangeHandler();
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
        return new QuaquaTrackListener();
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    @Override
    public boolean isInside(MouseEvent me) {
        Rectangle thumbB = this.thumbRect;
        return thumbB != null && thumbB.contains(me.getX(), me.getY());
    }

    public class QuaquaTrackListener
    extends BasicSliderUI.TrackListener {
        public QuaquaTrackListener() {
            super(ColorSliderUI.this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!ColorSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = e.getX();
            this.currentMouseY = e.getY();
            if (ColorSliderUI.this.slider.isRequestFocusEnabled()) {
                ColorSliderUI.this.slider.requestFocus();
            }
            if (ColorSliderUI.this.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                super.mousePressed(e);
            } else {
                switch (ColorSliderUI.this.slider.getOrientation()) {
                    case 1: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForYPosition(this.currentMouseY));
                        break;
                    }
                    case 0: {
                        ColorSliderUI.this.slider.setValue(ColorSliderUI.this.valueForXPosition(this.currentMouseX));
                    }
                }
            }
        }
    }

    public class CSUIPropertyChangeHandler
    extends BasicSliderUI.PropertyChangeHandler {
        public CSUIPropertyChangeHandler() {
            super(ColorSliderUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName;
            switch (propertyName = e.getPropertyName()) {
                case "Frame.active": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorSliderModel": {
                    ColorSliderUI.this.colorSliderModel = (ColorSliderModel)e.getNewValue();
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "snapToTicks": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentIndex": {
                    ColorSliderUI.this.componentIndex = (Integer)e.getNewValue();
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentChange": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "ColorComponentValue": {
                    ColorSliderUI.this.slider.repaint();
                    break;
                }
                case "Orientation": {
                    if (ColorSliderUI.this.slider.getOrientation() == 0) {
                        ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 1, -1, 1));
                        break;
                    }
                    ColorSliderUI.this.slider.setBorder(new VisualMargin(0, 0, 0, 1));
                }
            }
            super.propertyChange(e);
        }
    }
}

