Option Explicit

On Error Resume Next

Const strMgmts = "winmgmts:\\"
Const strNameSpace = "\root\cimv2"
Const wbemFlagReturnImmediately = &H10
Const wbemFlagForwardOnly = &H20

Dim strComputer, strUserName, strPassword, strDomain
Dim strInstance, strClassName, strService, strClass, strDatabase
Dim objSWbemLocator, objWMIService
Dim argLength,argCount

argLength = 4
argCount = WScript.Arguments.Count

If argCount < argLength Then
    Call WrongArguments
End If

Set objSWbemLocator = CreateObject("WbemScripting.SWbemLocator")

strComputer    = WScript.Arguments(0)
strInstance    = WScript.Arguments(1)
strClassName   = WScript.Arguments(2)
strService     = WScript.Arguments(3)

strClass    = GetClassName
If strClassName="Databases" And strService<>"f_databases" Then
    argLength = 5
    If argCount<argLength Then
        Call WrongArguments
    End If
    strDatabase = WScript.Arguments(4)
Else
    strDatabase = vbEmpty
End If

If argCount=argLength Then
    Set objWMIService = objSWbemLocator.ConnectServer( _
        strComputer, _
        strNameSpace)

ElseIf argCount=argLength+2 Then
    strUserName = WScript.Arguments(argLength)
    strPassword = WScript.Arguments(argLength+1)
    Set objWMIService = objSWbemLocator.ConnectServer(_
        strComputer, _
        strNameSpace, _
        strUserName, _
        strPassword)

ElseIf argCount=argLength+3 Then
    strUserName = WScript.Arguments(argLength)
    strPassword = WScript.Arguments(argLengtha+1)
    strDomain   = WScript.Arguments(argLengtha+2)
    Set objWMIService = objSWbemLocator.ConnectServer( _
        strComputer, _
        strNameSpace, _
        strUserName, _
        strPassword, _
        "MS_409", _
        "NTLMDomain:" + strDomain)

Else
    Call WrongArguments
End If

Select Case strService
    Case "f_databases" 'fetch databases created in specified instance
        GetDatabases
    Case Else
        GetExecutorResult
End Select

Call ErrorHandler

Function GetClassName()
    If strInstance = "MSSQLSERVER" Then
        GetClassName = "Win32_PerfRawData_MSSQLSERVER_SqlServer" & strClassName
    Else
        GetClassName = "Win32_PerfRawData_" & "MSSQL" & strInstance & "_MSSQL" & strInstance & strClassName
    End If
End Function

Function GetExecQuery(ByVal strDatabase)
    Dim strQuery
    strQuery = "SELECT * FROM " & strClass
    If strDatabase <> vbEmpty Then
        strQuery = strQuery & " WHERE Name=""" & strDatabase & """"
    End If
    GetExecQuery = strQuery
End Function

Sub GetDatabases()
    Dim colDatabases, colDatabase
    Set colDatabases = objWMIService.ExecQuery("SELECT * FROM " & strClass, "WQL", wbemFlagReturnImmediately + wbemFlagForwardOnly )
    For Each colDatabase In colDatabases
        WScript.Echo colDatabase.Name
    Next
End Sub

Sub GetExecutorResult()
    Dim strQuery, gotValue
    Dim colItems, colItem, colProp

    gotValue = False
    strQuery = GetExecQuery(strDatabase)

    Set colItems = objWMIService.ExecQuery(strQuery, "WQL", wbemFlagReturnImmediately+wbemFlagForwardOnly )
    For Each colItem In colItems
        For Each colProp In colItem.Properties_
            If colprop.Name = strService Then
                gotValue = True
                WScript.Echo colprop.Value
                Exit For
            End If
        Next
        If gotValue Then Exit For
    Next

    If not gotValue Then
        WScript.Quit(-1)
    End If
End Sub

Sub WrongArguments()
    WScript.Echo "Wrong number of arguments!"
    WScript.Quit(1)
End Sub

Sub ErrorHandler()
    If Err.Number <> vbEmpty Then
        WScript.Echo "Error Number:" & Err.Number & ", Description:" & Err.Description
        WScript.Quit(Err.Number)
    End If
End Sub

