/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.beans.PropertyVetoException;
import javax.swing.JLabel;
import javax.swing.border.EmptyBorder;
import org.netbeans.beaninfo.editors.DataObjectPanel;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.view.BeanTreeView;
import org.openide.explorer.view.TreeView;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataObject;
import org.openide.loaders.RepositoryNodeFactory;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.util.NbBundle;

public class DataObjectTreeView
extends DataObjectPanel {
    static final int DEFAULT_INSET = 10;
    private ExplorerPanel expPanel;
    private TreeView reposTree;
    private boolean initialized = false;

    public DataObjectTreeView(PropertyEditorSupport my, PropertyEnv env) {
        super(my, env);
        this.initComponent();
        this.reposTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)DataObjectTreeView.class, (String)"ACSN_DataObjectPanel"));
        this.setDescription(NbBundle.getMessage((Class)DataObjectTreeView.class, (String)"ACSD_DataObjectPanel"));
    }

    public void addNotify() {
        this.completeInitialization();
        super.addNotify();
    }

    private void initComponent() {
        this.expPanel = new ExplorerPanel();
        this.expPanel.setLayout((LayoutManager)new BorderLayout());
        this.reposTree = new BeanTreeView();
        this.reposTree.setSelectionMode(1);
        this.reposTree.setPopupAllowed(false);
        this.reposTree.setDefaultActionAllowed(false);
        this.expPanel.add((Component)this.reposTree, (Object)"Center");
    }

    private void completeInitialization() {
        Node n;
        if (this.initialized) {
            return;
        }
        if (this.insets != null) {
            this.setBorder(new EmptyBorder(this.insets));
        } else {
            this.setBorder(new EmptyBorder(12, 12, 0, 11));
        }
        this.setLayout(new BorderLayout(0, 2));
        if (this.subTitle != null) {
            JLabel l = new JLabel(this.subTitle);
            l.setLabelFor((Component)this.reposTree);
            this.add((Component)l, "North");
        }
        if (this.rootNode == null) {
            if (this.dataFilter != null) {
                if (this.folderFilter != null) {
                    DataFilter dFilter = new DataFilter(){

                        public boolean acceptDataObject(DataObject obj) {
                            if (DataObjectTreeView.this.folderFilter.acceptDataObject(obj)) {
                                return true;
                            }
                            return DataObjectTreeView.this.dataFilter.acceptDataObject(obj);
                        }
                    };
                    this.rootNode = RepositoryNodeFactory.getDefault().repository(dFilter);
                } else {
                    this.rootNode = RepositoryNodeFactory.getDefault().repository(this.dataFilter);
                }
            } else {
                this.rootNode = this.folderFilter != null ? RepositoryNodeFactory.getDefault().repository(this.folderFilter) : RepositoryNodeFactory.getDefault().repository(DataFilter.ALL);
            }
        }
        if (this.nodeFilter != null) {
            DataObjectPanel.FilteredChildren children = new DataObjectPanel.FilteredChildren(this.rootNode, this.nodeFilter, this.dataFilter);
            this.rootNode = n = new FilterNode(this.rootNode, (Children)children);
        }
        Node rNode = this.rootNode;
        if (this.rootObject != null && (n = this.findNodeForObj(this.rootNode, this.rootObject)) != null) {
            NodeAcceptor naccep = this.nodeFilter;
            if (naccep == null) {
                naccep = new NodeAcceptor(){

                    public boolean acceptNodes(Node[] nodes) {
                        return false;
                    }
                };
            }
            DataObjectPanel.FilteredChildren children = new DataObjectPanel.FilteredChildren(n, naccep, this.dataFilter);
            FilterNode filtNode = new FilterNode(n, (Children)children);
            rNode = filtNode;
        }
        this.expPanel.getExplorerManager().setRootContext(rNode);
        Node theNode = null;
        if (this.dObj != null) {
            theNode = this.findNodeForObj(rNode, this.dObj);
        }
        if (theNode != null) {
            try {
                this.expPanel.getExplorerManager().setSelectedNodes(new Node[]{theNode});
            }
            catch (PropertyVetoException pve) {
                ErrorManager.getDefault().notify(1, (Throwable)pve);
            }
            catch (IllegalArgumentException iae) {
                ErrorManager.getDefault().notify(1, (Throwable)iae);
            }
        }
        this.expPanel.getExplorerManager().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("selectedNodes")) {
                    Node[] nodes = (Node[])evt.getNewValue();
                    DataObject d = DataObjectTreeView.this.getDataObject();
                    boolean enableOK = false;
                    if (nodes != null && nodes.length > 0 && DataObjectTreeView.this.dataFilter != null && d != null) {
                        enableOK = DataObjectTreeView.this.dataFilter.acceptDataObject(d);
                    } else {
                        boolean bl = enableOK = d != null;
                    }
                    if (enableOK) {
                        DataObjectTreeView.this.myEditor.setValue(d);
                    }
                    DataObjectTreeView.this.setOkButtonEnabled(enableOK);
                }
            }
        });
        this.add((Component)this.expPanel, "Center");
        if (this.dataFilter != null && this.getDataObject() != null) {
            this.setOkButtonEnabled(this.dataFilter.acceptDataObject(this.getDataObject()));
        } else {
            this.setOkButtonEnabled(this.getDataObject() != null);
        }
        this.initialized = true;
    }

    public void setDescription(String desc) {
        this.getAccessibleContext().setAccessibleDescription(desc);
        this.reposTree.getAccessibleContext().setAccessibleDescription(desc);
    }

    public DataObject getDataObject() {
        DataObject retValue = null;
        Node[] na = this.expPanel.getExplorerManager().getSelectedNodes();
        if (na != null && na.length > 0) {
            retValue = (DataObject)na[0].getCookie(DataObject.class);
        }
        return retValue;
    }

    public Node getNode() {
        Node retValue = null;
        Node[] na = this.expPanel.getExplorerManager().getSelectedNodes();
        if (na != null && na.length > 0) {
            retValue = na[0];
        }
        return retValue;
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getDataObject();
    }
}

