/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.beaninfo.editors;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.netbeans.beaninfo.editors.RectangleEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public class RectangleCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor,
KeyListener {
    static final long serialVersionUID = -9015667991684634296L;
    private HashMap labelMap = new HashMap();
    private PropertyEnv env;
    private JPanel jPanel2;
    private JLabel xLabel;
    private JTextField xField;
    private JLabel yLabel;
    private JTextField yField;
    private JLabel widthLabel;
    private JTextField widthField;
    private JLabel heightLabel;
    private JTextField heightField;
    private RectangleEditor editor;

    public RectangleCustomEditor(RectangleEditor editor, PropertyEnv env) {
        this.env = env;
        this.initComponents();
        this.editor = editor;
        Rectangle rectangle = (Rectangle)editor.getValue();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, 0, 0);
        }
        this.xField.setText("" + rectangle.x);
        this.yField.setText("" + rectangle.y);
        this.widthField.setText("" + rectangle.width);
        this.heightField.setText("" + rectangle.height);
        this.setBorder(new EmptyBorder(new Insets(5, 5, 5, 5)));
        this.jPanel2.setBorder(new CompoundBorder(new TitledBorder(new EtchedBorder(), " " + NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Rectangle") + " "), new EmptyBorder(new Insets(5, 5, 5, 5))));
        this.xLabel.setText(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_X"));
        this.yLabel.setText(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Y"));
        this.widthLabel.setText(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Width"));
        this.heightLabel.setText(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Height"));
        this.xLabel.setLabelFor(this.xField);
        this.yLabel.setLabelFor(this.yField);
        this.widthLabel.setLabelFor(this.widthField);
        this.heightLabel.setLabelFor(this.heightField);
        this.xLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_X_Mnemonic").charAt(0));
        this.yLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Y_Mnemonic").charAt(0));
        this.widthLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Width_mnemonic").charAt(0));
        this.heightLabel.setDisplayedMnemonic(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_Height_mnemonic").charAt(0));
        this.xField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"ACSD_CTL_X"));
        this.yField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"ACSD_CTL_Y"));
        this.widthField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"ACSD_CTL_Width"));
        this.heightField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"ACSD_CTL_Height"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"ACSD_CustomRectangleEditor"));
        this.labelMap.put(this.widthField, this.widthLabel);
        this.labelMap.put(this.xField, this.xLabel);
        this.labelMap.put(this.yField, this.yLabel);
        this.labelMap.put(this.heightField, this.heightLabel);
    }

    public Dimension getPreferredSize() {
        return new Dimension(280, 160);
    }

    public Object getPropertyValue() throws IllegalStateException {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            int width = Integer.parseInt(this.widthField.getText());
            int height = Integer.parseInt(this.heightField.getText());
            if (x < 0 || y < 0 || width < 0 || height < 0) {
                IllegalStateException ise = new IllegalStateException();
                ErrorManager.getDefault().annotate((Throwable)ise, 256, null, NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_NegativeSize"), null, null);
                throw ise;
            }
            return new Rectangle(x, y, width, height);
        }
        catch (NumberFormatException e) {
            IllegalStateException ise = new IllegalStateException();
            ErrorManager.getDefault().annotate((Throwable)ise, 256, null, NbBundle.getMessage((Class)RectangleCustomEditor.class, (String)"CTL_InvalidValue"), null, null);
            throw ise;
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.jPanel2 = new JPanel();
        this.jPanel2.setLayout(new GridBagLayout());
        this.xLabel = new JLabel();
        this.xLabel.setText(null);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.xLabel, gridBagConstraints1);
        this.xField = new JTextField();
        this.xField.addKeyListener(this);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.xField, gridBagConstraints1);
        this.yLabel = new JLabel();
        this.yLabel.setText(null);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.yLabel, gridBagConstraints1);
        this.yField = new JTextField();
        this.yField.addKeyListener(this);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.yField, gridBagConstraints1);
        this.widthLabel = new JLabel();
        this.widthLabel.setText(null);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.widthLabel, gridBagConstraints1);
        this.widthField = new JTextField();
        this.widthField.addKeyListener(this);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.widthField, gridBagConstraints1);
        this.heightLabel = new JLabel();
        this.heightLabel.setText(null);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.anchor = 17;
        this.jPanel2.add((Component)this.heightLabel, gridBagConstraints1);
        this.heightField = new JTextField();
        this.heightField.addKeyListener(this);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(4, 8, 4, 0);
        gridBagConstraints1.weightx = 1.0;
        this.jPanel2.add((Component)this.heightField, gridBagConstraints1);
        this.add((Component)this.jPanel2, "Center");
    }

    private void updateRectangle() {
        try {
            int x = Integer.parseInt(this.xField.getText());
            int y = Integer.parseInt(this.yField.getText());
            int width = Integer.parseInt(this.widthField.getText());
            int height = Integer.parseInt(this.heightField.getText());
            this.editor.setValue(new Rectangle(x, y, width, height));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        if (this.checkValues()) {
            this.updateRectangle();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    private boolean checkValues() {
        Component[] c = this.jPanel2.getComponents();
        boolean valid = true;
        for (int i = 0; i < c.length; ++i) {
            if (!(c[i] instanceof JTextField)) continue;
            valid &= this.validFor((JTextField)c[i]);
        }
        if (this.env != null) {
            this.env.setState(valid ? PropertyEnv.STATE_VALID : PropertyEnv.STATE_INVALID);
        }
        return valid;
    }

    private boolean validFor(JTextField c) {
        String s = c.getText().trim();
        try {
            Integer.parseInt(s);
            this.handleValid(c);
            return true;
        }
        catch (NumberFormatException e) {
            this.handleInvalid(c);
            return false;
        }
    }

    private void handleInvalid(JTextField c) {
        c.setForeground(this.getErrorColor());
        this.findLabelFor(c).setForeground(this.getErrorColor());
    }

    private void handleValid(JTextField c) {
        c.setForeground(this.getForeground());
        this.findLabelFor(c).setForeground(this.getForeground());
    }

    private Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        if (c == null) {
            c = Color.RED;
        }
        return c;
    }

    private JLabel findLabelFor(JTextField c) {
        return (JLabel)this.labelMap.get(c);
    }
}

