/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Locale;
import org.netbeans.CLIHandler;
import org.netbeans.core.NonGui;
import org.netbeans.core.TopLogging;
import org.netbeans.core.perftool.StartLog;
import org.openide.util.NbBundle;

public class CLIOptions
extends CLIHandler {
    private static boolean specifiedBranding = false;

    public CLIOptions() {
        super(1);
    }

    protected int cli(CLIHandler.Args arguments) {
        return this.cli(arguments.getArguments());
    }

    private static boolean isOption(String value, String optionName) {
        if (value == null) {
            return false;
        }
        if (value.startsWith("--")) {
            return value.substring(2).equals(optionName);
        }
        if (value.startsWith("-")) {
            return value.substring(1).equals(optionName);
        }
        return false;
    }

    final int cli(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (args[i] == null) continue;
            boolean used = true;
            if (CLIOptions.isOption(args[i], "nogui")) {
                System.getProperties().put("org.openide.TopManager", "org.netbeans.core.NonGui");
            } else if (CLIOptions.isOption(args[i], "nosplash")) {
                NonGui.noSplash = true;
            } else if (!CLIOptions.isOption(args[i], "noinfo")) {
                if (CLIOptions.isOption(args[i], "nologging")) {
                    NonGui.noLogging = true;
                } else {
                    if (CLIOptions.isOption(args[i], "userdir")) {
                        args[i] = null;
                        try {
                            System.setProperty("netbeans.user", args[++i]);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println(NonGui.getString("ERR_UserDirExpected"));
                            return 2;
                        }
                    }
                    if (CLIOptions.isOption(args[i], "ui") || CLIOptions.isOption(args[i], "laf")) {
                        args[i] = null;
                        try {
                            String ui = args[++i];
                            if ("com.sun.java.swing.plaf.gtk.GTKLookAndFeel".equals(ui) && System.getProperty("java.version").indexOf("1.4.2") != -1) {
                                System.err.println(NonGui.getString("MSG_GTKNotSupported"));
                            }
                            NonGui.uiClass = Class.forName(ui);
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            System.err.println(NonGui.getString("ERR_UIExpected"));
                            return 2;
                        }
                        catch (ClassNotFoundException e2) {
                            System.err.println(NonGui.getString("ERR_UINotFound"));
                        }
                    } else {
                        if (CLIOptions.isOption(args[i], "fontsize")) {
                            args[i] = null;
                            try {
                                NonGui.uiFontSize = Integer.parseInt(args[++i]);
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                System.err.println(NonGui.getString("ERR_FontSizeExpected"));
                                return 2;
                            }
                            catch (NumberFormatException e2) {
                                System.err.println(NonGui.getString("ERR_BadFontSize"));
                                return 1;
                            }
                        }
                        if (CLIOptions.isOption(args[i], "locale")) {
                            String language;
                            args[i] = null;
                            String localeParam = args[++i];
                            String country = "";
                            String variant = "";
                            int index1 = localeParam.indexOf(":");
                            if (index1 == -1) {
                                language = localeParam;
                            } else {
                                language = localeParam.substring(0, index1);
                                int index2 = localeParam.indexOf(":", index1 + 1);
                                if (index2 != -1) {
                                    country = localeParam.substring(index1 + 1, index2);
                                    variant = localeParam.substring(index2 + 1);
                                } else {
                                    country = localeParam.substring(index1 + 1);
                                }
                            }
                            Locale.setDefault(new Locale(language, country, variant));
                        } else if (CLIOptions.isOption(args[i], "branding")) {
                            args[i] = null;
                            if (++i == args.length) {
                                System.err.println(NonGui.getString("ERR_BrandingNeedsArgument"));
                                return 2;
                            }
                            String branding = args[i];
                            if (branding.equals("-")) {
                                branding = null;
                            }
                            try {
                                NbBundle.setBranding((String)branding);
                            }
                            catch (IllegalArgumentException iae) {
                                iae.printStackTrace();
                                return 1;
                            }
                            specifiedBranding = true;
                        } else {
                            used = false;
                        }
                    }
                }
            }
            if (!used) continue;
            args[i] = null;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize() {
        File branding;
        if (!specifiedBranding && (branding = new File(new File(NonGui.getHomeDir(), "lib"), "branding")).exists()) {
            try {
                FileInputStream is = new FileInputStream(branding);
                try {
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is));
                    String line = rd.readLine();
                    if (line == null || line.equals("")) {
                        throw new IOException("empty branding file");
                    }
                    if (rd.readLine() != null) {
                        throw new IOException("branding file more than one line");
                    }
                    if ((line = line.trim()).equals("-")) {
                        line = null;
                    }
                    try {
                        NbBundle.setBranding((String)line);
                    }
                    catch (IllegalArgumentException iae) {
                        iae.printStackTrace();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        if (!NonGui.noLogging) {
            try {
                NonGui.logger = new TopLogging(NonGui.getLogDir());
            }
            catch (IOException e) {
                System.err.println("Cannot create log file. Logging disabled.");
                e.printStackTrace();
            }
        }
        StartLog.logProgress("TopLogging initialized");
    }

    protected void usage(PrintWriter w) {
        w.println("Core options:");
        w.println("  --laf <LaF classname> use given LookAndFeel class instead of the default");
        w.println("  --fontsize <size>     set the base font size of the user interface, in points");
        w.println("  --locale <language[:country[:variant]]> use specified locale");
        w.println("  --userdir <path>      use specified directory to store user settings");
        w.println("");
    }
}

