/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.perftool.StartLog;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

class LookupCache {
    private static final boolean ENABLED = Boolean.valueOf(System.getProperty("netbeans.cache.lookup", "true"));
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.LookupCache");

    LookupCache() {
    }

    public static Lookup load() {
        err.log("enabled=" + ENABLED);
        if (ENABLED && LookupCache.cacheHit()) {
            try {
                return LookupCache.loadCache();
            }
            catch (Exception e) {
                err.notify(1, (Throwable)e);
            }
        }
        return LookupCache.loadDirect();
    }

    private static Lookup loadDirect() {
        FileObject services = Repository.getDefault().getDefaultFileSystem().findResource("Services");
        if (services != null) {
            DataFolder servicesF;
            StartLog.logProgress("Got Services folder");
            try {
                servicesF = DataFolder.findFolder((FileObject)services);
            }
            catch (RuntimeException e) {
                err.notify(1, (Throwable)e);
                return Lookup.EMPTY;
            }
            FolderLookup f = new FolderLookup((DataObject.Container)servicesF, "SL[");
            StartLog.logProgress("created FolderLookup");
            err.log("loadDirect from Services");
            return f.getLookup();
        }
        err.log("loadDirect, but no Services");
        return Lookup.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean cacheHit() {
        boolean hit;
        File f = LookupCache.cacheFile();
        if (f == null || !f.exists()) {
            err.log("no cache file");
            return false;
        }
        File stampFile = LookupCache.stampFile();
        if (stampFile == null || !stampFile.exists()) {
            err.log("no stamp file");
            return false;
        }
        StartLog.logStart("check for lookup cache hit");
        List files = LookupCache.relevantFiles();
        if (err.isLoggable(1)) {
            err.log("checking against " + stampFile + " for files " + files);
        }
        try {
            Stamp stamp = new Stamp(files);
            long newHash = stamp.getHash();
            BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(stampFile), "UTF-8"));
            try {
                long oldHash;
                String line = r.readLine();
                try {
                    oldHash = Long.parseLong(line);
                }
                catch (NumberFormatException nfe) {
                    throw new IOException(nfe.toString());
                }
                if (oldHash == newHash) {
                    err.log("Cache hit! with hash " + oldHash);
                    hit = true;
                } else {
                    err.log("Cache miss, " + oldHash + " -> " + newHash);
                    hit = false;
                }
            }
            finally {
                r.close();
            }
        }
        catch (IOException ioe) {
            err.notify(1, (Throwable)ioe);
            hit = false;
        }
        StartLog.logEnd("check for lookup cache hit");
        return hit;
    }

    private static File cacheFile() {
        String ud = System.getProperty("netbeans.user");
        if (ud != null) {
            File cachedir = new File(new File(ud, "var"), "cache");
            cachedir.mkdirs();
            return new File(cachedir, "folder-lookup.ser");
        }
        return null;
    }

    private static File stampFile() {
        String ud = System.getProperty("netbeans.user");
        if (ud != null) {
            File cachedir = new File(new File(ud, "var"), "cache");
            cachedir.mkdirs();
            return new File(cachedir, "lookup-stamp.txt");
        }
        return null;
    }

    private static List relevantFiles() {
        final ArrayList files = new ArrayList(250);
        final ModuleManager mgr = NbTopManager.get().getModuleSystem().getManager();
        mgr.mutex().readAccess(new Runnable(){

            public void run() {
                Iterator it = mgr.getEnabledModules().iterator();
                while (it.hasNext()) {
                    Module m = (Module)((Object)it.next());
                    String layer = (String)m.getAttribute("OpenIDE-Module-Layer");
                    if (layer == null) continue;
                    if (!m.isFixed()) {
                        files.add(m.getJarFile());
                        continue;
                    }
                    URL layerURL = m.getClassLoader().getResource(layer);
                    if (layerURL != null) {
                        String s = layerURL.toExternalForm();
                        if (s.startsWith("jar:")) {
                            int bangSlash = s.lastIndexOf("!/");
                            if (bangSlash != -1) {
                                try {
                                    URI layerJarURL = new URI(s.substring(4, bangSlash));
                                    if ("file".equals(layerJarURL.getScheme())) {
                                        files.add(new File(layerJarURL));
                                        continue;
                                    }
                                    err.log(16, "Weird jar: URL: " + layerJarURL);
                                }
                                catch (URISyntaxException e) {
                                    err.notify(1, (Throwable)e);
                                }
                                continue;
                            }
                            err.log(16, "Malformed jar: URL: " + s);
                            continue;
                        }
                        err.log(16, "Not a jar: URL: " + s);
                        continue;
                    }
                    err.log(16, "Could not find " + layer + " in " + (Object)((Object)m));
                }
            }
        });
        LookupCache.relevantFilesFromInst(files, System.getProperty("netbeans.home"));
        LookupCache.relevantFilesFromInst(files, System.getProperty("netbeans.user"));
        String nbdirs = System.getProperty("netbeans.dirs");
        if (nbdirs != null) {
            StringTokenizer tok = new StringTokenizer(nbdirs, File.pathSeparator);
            while (tok.hasMoreTokens()) {
                LookupCache.relevantFilesFromInst(files, tok.nextToken());
            }
        }
        return files;
    }

    private static void relevantFilesFromInst(List files, String instDir) {
        if (instDir == null) {
            return;
        }
        LookupCache.relevantFilesFrom(files, new File(new File(new File(instDir), "system"), "Services"));
    }

    private static void relevantFilesFrom(List files, File dir) {
        File[] kids = dir.listFiles();
        if (kids != null) {
            for (int i = 0; i < kids.length; ++i) {
                File f = kids[i];
                if (f.isFile()) {
                    files.add(f);
                    continue;
                }
                LookupCache.relevantFilesFrom(files, f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Lookup loadCache() throws Exception {
        StartLog.logStart("load lookup cache");
        File f = LookupCache.cacheFile();
        err.log("loading from " + f);
        FileInputStream is = new FileInputStream(f);
        try {
            NbObjectInputStream ois = new NbObjectInputStream((InputStream)new BufferedInputStream(is));
            Lookup l = (Lookup)ois.readObject();
            StartLog.logEnd("load lookup cache");
            Lookup lookup = l;
            return lookup;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void store(Lookup l) throws IOException {
        if (!ENABLED) {
            return;
        }
        File f = LookupCache.cacheFile();
        if (f == null) {
            return;
        }
        File stampFile = LookupCache.stampFile();
        if (stampFile == null) {
            return;
        }
        StartLog.logStart("store lookup cache");
        err.log("storing to " + f + " with stamp in " + stampFile);
        FileOutputStream os = new FileOutputStream(f);
        try {
            try {
                NbObjectOutputStream oos = new NbObjectOutputStream((OutputStream)new BufferedOutputStream(os));
                oos.writeObject(l);
                oos.flush();
            }
            finally {
                ((OutputStream)os).close();
            }
            Stamp stamp = new Stamp(LookupCache.relevantFiles());
            OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(stampFile), "UTF-8");
            try {
                wr.write(Long.toString(stamp.getHash()));
                wr.write("\nLine above is identifying hash key, do not edit!\nBelow is metadata about folder lookup cache, for debugging purposes.\n");
                wr.write(stamp.toString());
            }
            finally {
                ((Writer)wr).close();
            }
            StartLog.logEnd("store lookup cache");
        }
        catch (IOException ioe) {
            if (f.exists()) {
                f.delete();
            }
            if (stampFile.exists()) {
                stampFile.delete();
            }
            throw ioe;
        }
    }

    private static final class Stamp {
        private final List files;
        private final long[] times;
        private final long hash;

        public Stamp(List files) throws IOException {
            this.files = new ArrayList(files);
            Collections.sort(this.files);
            this.times = new long[this.files.size()];
            long x = 17L;
            Iterator it = this.files.iterator();
            int i = 0;
            while (it.hasNext()) {
                File f = (File)it.next();
                x ^= (long)f.hashCode();
                x += 98679245L;
                String name = f.getName().toLowerCase(Locale.US);
                long m = name.endsWith(".jar") || name.equals(".nbattrs") ? f.lastModified() : 0L;
                int n = i++;
                long l = m;
                this.times[n] = l;
                x ^= l;
            }
            this.hash = x;
        }

        public long getHash() {
            return this.hash;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            Iterator it = this.files.iterator();
            int i = 0;
            while (it.hasNext()) {
                long t;
                if ((t = this.times[i++]) != 0L) {
                    buf.append(new Date(t));
                } else {
                    buf.append("<ignoring file contents>");
                }
                buf.append('\t');
                buf.append(it.next());
                buf.append('\n');
            }
            return buf.toString();
        }
    }
}

