/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import org.netbeans.core.CLIOptions;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.NonGui;
import org.netbeans.core.ShortcutsFolder;
import org.netbeans.core.Splash;
import org.netbeans.core.TopThreadGroup;
import org.netbeans.core.WarmUpSupport;
import org.netbeans.core.perftool.StartLog;
import org.netbeans.core.xml.DOMFactoryImpl;
import org.netbeans.core.xml.SAXFactoryImpl;
import org.netbeans.swing.plaf.Startup;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class Main
extends NonGui {
    private static Splash.SplashOutput splash;
    private static final boolean noBar;
    static /* synthetic */ Class class$org$netbeans$core$NbTopManager$WindowSystem;

    public static void setSplashMaxSteps(int maxSteps) {
        if (noBar || noSplash || splash == null) {
            return;
        }
        splash.setMaxSteps(maxSteps);
    }

    public static void addToSplashMaxSteps(int steps) {
        if (noBar || noSplash || splash == null) {
            return;
        }
        splash.addToMaxSteps(steps);
    }

    public static void addAndSetSplashMaxSteps(int steps) {
        if (noBar || noSplash || splash == null) {
            return;
        }
        splash.addAndSetMaxSteps(steps);
    }

    public static void incrementSplashProgressBar() {
        Main.incrementSplashProgressBar(1);
    }

    public static void incrementSplashProgressBar(int steps) {
        if (noBar || noSplash || splash == null) {
            return;
        }
        splash.increment(steps);
    }

    public static void main(String[] argv) throws Exception {
        TopThreadGroup tg = new TopThreadGroup("IDE Main", argv);
        StartLog.logStart("Forwarding to topThreadGroup");
        tg.start();
        StartLog.logProgress("Main.main finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initUICustomizations() {
        block14: {
            URL themeURL = null;
            boolean wantTheme = Boolean.getBoolean("netbeans.useTheme") || uiClass != null && uiClass.getName().indexOf("MetalLookAndFeel") >= 0;
            try {
                if (wantTheme) {
                    FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource("themes.xml");
                    if (fo == null) {
                        themeURL = this.getClass().getResource("resources/themes.xml");
                    } else {
                        try {
                            themeURL = fo.getURL();
                        }
                        catch (FileStateInvalidException fsie) {
                            // empty catch block
                        }
                    }
                }
                if (uiFontSize != 0) break block14;
                String key = "";
                try {
                    key = NbBundle.getMessage((Class)Main.class, (String)"CTL_globalFontSize");
                }
                catch (MissingResourceException mre) {
                    // empty catch block
                }
                if (key.length() > 0) {
                    try {
                        uiFontSize = Integer.parseInt(key);
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                }
            }
            finally {
                Startup.run((Class)uiClass, (int)uiFontSize, themeURL);
            }
        }
        if (uiFontSize > 0 && "GTK".equals(UIManager.getLookAndFeel().getID())) {
            ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)Main.class, (String)"GTK_FONTSIZE_UNSUPPORTED"));
        }
        StartLog.logProgress("Fonts updated");
    }

    public void run() {
        SAXFactoryImpl.install();
        DOMFactoryImpl.install();
        StartLog.logStart("TopManager initialization (org.netbeans.core.Main.run())");
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (InternalError exc) {
            String s = NbBundle.getMessage((Class)Main.class, (String)"EXC_GraphicsStartFails1", (Object)exc.getMessage());
            System.out.println(s);
            s = NbBundle.getMessage((Class)Main.class, (String)"EXC_GraphicsStartFails2", (Object)(Main.getUserDir() + "/var/log/messages.log"));
            System.out.println(s);
            throw exc;
        }
        this.initUICustomizations();
        super.run();
        StartLog.logProgress("NonGui part done");
        StartLog.logEnd("TopManager initialization (org.netbeans.core.Main.run())");
    }

    protected void initializeMainWindow() {
        StartLog.logStart("Main window initialization");
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(Main.this.getModuleSystem().getManager().getClassLoader());
                    Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)Main.class, (String)"MSG_MainWindowInit"));
        Timer timerInit = new Timer(0, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        timerInit.setRepeats(false);
        timerInit.start();
        Main.incrementSplashProgressBar(10);
        StartLog.logProgress("Timer initialized");
        ShortcutsFolder.initShortcuts();
        Main.incrementSplashProgressBar();
        StartLog.logProgress("Shortcuts initialized");
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage((Class)Main.class, (String)"MSG_WindowShowInit"));
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NbTopManager.WindowSystem windowSystem;
                StartLog.logProgress("Window system initialization");
                if (System.getProperty("netbeans.warmup.skip") == null && System.getProperty("netbeans.close") == null) {
                    Frame mainWindow = WindowManager.getDefault().getMainWindow();
                    mainWindow.addComponentListener(new ComponentAdapter(this, mainWindow){
                        private final /* synthetic */ Frame val$mainWindow;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$mainWindow = val$mainWindow;
                        }

                        public void componentShown(ComponentEvent evt) {
                            this.val$mainWindow.removeComponentListener(this);
                            WarmUpSupport.warmUp();
                        }
                    });
                }
                if ((windowSystem = (NbTopManager.WindowSystem)Lookup.getDefault().lookup(class$org$netbeans$core$NbTopManager$WindowSystem == null ? (class$org$netbeans$core$NbTopManager$WindowSystem = Main.class$("org.netbeans.core.NbTopManager$WindowSystem")) : class$org$netbeans$core$NbTopManager$WindowSystem)) != null) {
                    windowSystem.load();
                    StartLog.logProgress("Window system loaded");
                    if (StartLog.willLog()) {
                        Main.waitForMainWindowPaint();
                    }
                    windowSystem.show();
                } else {
                    ErrorManager.getDefault().notify(1, (Throwable)new NullPointerException("\n\n\nWindowSystem is not supplied!!!\\n\n"));
                }
                StatusDisplayer.getDefault().setStatusText("");
                StartLog.logProgress("Window system shown");
                if (!StartLog.willLog()) {
                    Main.maybeDie(null);
                }
            }
        });
        StartLog.logEnd("Main window initialization");
    }

    static void start(String[] args) throws SecurityException {
        StartLog.logEnd("Forwarding to topThreadGroup");
        StartLog.logStart("Preparation");
        if (System.getProperties().get("org.openide.TopManager") == null) {
            System.getProperties().put("org.openide.TopManager", "org.netbeans.core.Main");
        }
        CLIOptions.initialize();
        StartLog.logProgress("Command line parsed");
        StartLog.logStart("Creation of TopManager");
        NbTopManager.get();
        StartLog.logEnd("Creation of TopManager");
        if (splash != null) {
            Splash.hideSplash(splash);
            splash = null;
        }
        StartLog.logProgress("Splash hidden");
        StartLog.logEnd("Preparation");
    }

    private static void endOfStartupMeasuring(Object o) {
        StartLog.logProgress("Startup memory and time measured");
        Main.maybeDie(o);
    }

    private static void maybeDie(Object o) {
        if (System.getProperty("netbeans.kill") != null) {
            Main.doExit(5);
        }
        if (System.getProperty("netbeans.close") != null) {
            if (Boolean.getBoolean("netbeans.warm.close")) {
                new WarmUpSupport().run();
            }
            if (o != null) {
                StartLog.logMeasuredStartupTime((Long)o);
            }
            LifecycleManager.getDefault().exit();
        }
    }

    private static void waitForMainWindowPaint() {
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Class<?> clz = Class.forName("org.netbeans.performance.test.guitracker.LoggingRepaintManager");
                    Method m = clz.getMethod("measureStartup", new Class[0]);
                    Object o = m.invoke(null, null);
                    Main.endOfStartupMeasuring(o);
                }
                catch (ClassNotFoundException e) {
                    StartLog.logProgress(e.toString());
                }
                catch (NoSuchMethodException e) {
                    StartLog.logProgress(e.toString());
                }
                catch (IllegalAccessException e) {
                    StartLog.logProgress(e.toString());
                }
                catch (InvocationTargetException e) {
                    StartLog.logProgress(e.toString());
                }
            }
        };
        new Thread(r).start();
    }

    protected Splash.SplashOutput getSplash() {
        return splash;
    }

    protected void showSplash() {
        if (!noSplash) {
            if (splash != null) {
                if (Splash.isVisible(splash)) {
                    return;
                }
                splash = null;
            }
            splash = Splash.showSplash();
        }
    }

    static {
        noBar = Boolean.getBoolean("netbeans.splash.nobar");
    }
}

