/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeOp;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.io.NbMarshalledObject;
import org.openide.util.io.SafeException;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import org.openide.windows.Workspace;

public final class NbSheet
extends TopComponent {
    private static final String PROP_LONGER_DISPLAY_NAME = "longerDisplayName";
    static final long serialVersionUID = 7807519514644165460L;
    private static NbSheet sharedSheet;
    private final transient Listener listener;
    private final transient SheetNodesListener snListener;
    boolean global;
    private PropertySheet propertySheet;
    private Node[] nodes = new Node[0];
    private static MessageFormat globalPropertiesFormat;
    private static MessageFormat localPropertiesFormat;

    public NbSheet() {
        this(false);
    }

    public NbSheet(boolean global) {
        this.global = global;
        this.propertySheet = new PropertySheet();
        this.putClientProperty("NamingType", "BothOnlyCompName");
        this.setLayout(new BorderLayout());
        this.add((Component)this.propertySheet, "Center");
        this.setIcon(Utilities.loadImage((String)"org/netbeans/core/resources/frames/properties.gif", (boolean)true));
        this.updateTitle();
        this.putClientProperty("SlidingName", NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_PropertiesWindow"));
        this.listener = new Listener();
        this.snListener = new SheetNodesListener();
        this.getAccessibleContext().setAccessibleName(NbBundle.getBundle((Class)NbSheet.class).getString("ACSN_PropertiesSheet"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getBundle((Class)NbSheet.class).getString("ACSD_PropertiesSheet"));
        this.updateGlobalListening();
    }

    public static NbSheet findDefault() {
        if (sharedSheet == null) {
            TopComponent tc = WindowManager.getDefault().findTopComponent("properties");
            if (tc != null) {
                if (tc instanceof NbSheet) {
                    sharedSheet = (NbSheet)tc;
                } else {
                    IllegalStateException exc = new IllegalStateException("Incorrect settings file. Unexpected class returned. Expected:" + NbSheet.class.getName() + " Returned:" + tc.getClass().getName());
                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                    NbSheet.getDefault();
                }
            } else {
                NbSheet.getDefault();
            }
        }
        return sharedSheet;
    }

    protected String preferredID() {
        return "properties";
    }

    public static NbSheet getDefault() {
        if (sharedSheet == null) {
            sharedSheet = new NbSheet(true);
        }
        return sharedSheet;
    }

    public int getPersistenceType() {
        return 0;
    }

    public HelpCtx getHelpCtx() {
        return this.global ? ExplorerPanel.getHelpCtx((Node[])this.nodes, (HelpCtx)new HelpCtx(NbSheet.class)) : null;
    }

    public void requestFocus() {
        super.requestFocus();
        this.propertySheet.requestFocus();
    }

    public boolean requestFocusInWindow() {
        super.requestFocusInWindow();
        return this.propertySheet.requestFocusInWindow();
    }

    public void open(Workspace workspace) {
        Workspace realWorkspace;
        Mode tcMode;
        if (this.global && (tcMode = (realWorkspace = workspace == null ? WindowManager.getDefault().getCurrentWorkspace() : workspace).findMode((TopComponent)this)) == null) {
            Mode mode = realWorkspace.findMode("properties");
            if (mode == null) {
                mode = realWorkspace.createMode("properties", NbBundle.getBundle((Class)NbSheet.class).getString("CTL_PropertiesWindow"), null);
            }
            mode.dockInto((TopComponent)this);
        }
        super.open(workspace);
        if (this.global) {
            SwingUtilities.invokeLater(this.listener);
        }
    }

    protected void updateTitle() {
        Mode ourMode = WindowManager.getDefault().findMode((TopComponent)this);
        String nodeTitle = null;
        ArrayList<Node> copyNodes = new ArrayList<Node>(Arrays.asList(this.nodes));
        Node node = null;
        if (!copyNodes.isEmpty()) {
            node = (Node)copyNodes.get(0);
        }
        if (node == null) {
            nodeTitle = "";
        } else {
            nodeTitle = node.getDisplayName();
            Object alternativeDisplayName = node.getValue(PROP_LONGER_DISPLAY_NAME);
            if (alternativeDisplayName instanceof String) {
                nodeTitle = (String)alternativeDisplayName;
            }
        }
        Object[] titleParams = new Object[]{new Integer(copyNodes.size()), nodeTitle};
        if (ourMode != null && "properties".equals(ourMode.getName())) {
            if (globalPropertiesFormat == null) {
                globalPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_FMT_GlobalProperties"));
            }
            this.setName(globalPropertiesFormat.format(titleParams));
        } else {
            if (localPropertiesFormat == null) {
                localPropertiesFormat = new MessageFormat(NbBundle.getMessage((Class)NbSheet.class, (String)"CTL_FMT_LocalProperties"));
            }
            this.setName(localPropertiesFormat.format(titleParams));
        }
        this.setToolTipText(this.getName());
    }

    public void setNodes(Node[] nodes) {
        this.setNodesWithoutReattaching(nodes);
        this.snListener.detach();
        this.snListener.attach(nodes);
    }

    private void setNodesWithoutReattaching(Node[] nodes) {
        this.nodes = nodes;
        this.propertySheet.setNodes(nodes);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NbSheet.this.updateTitle();
            }
        });
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        if (this.global) {
            out.writeObject(null);
        } else {
            Node.Handle[] arr = NodeOp.toHandles((Node[])this.nodes);
            out.writeObject(arr);
        }
        out.writeBoolean(this.global);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            super.readExternal(in);
        }
        catch (SafeException se) {
            // empty catch block
        }
        Object obj = in.readObject();
        if (obj instanceof NbMarshalledObject || obj instanceof ExplorerManager) {
            this.global = (Boolean)in.readObject();
        } else {
            Node[] nodes;
            if (obj == null) {
                nodes = TopComponent.getRegistry().getActivatedNodes();
            } else {
                Node.Handle[] arr = (Node.Handle[])obj;
                try {
                    nodes = NodeOp.fromHandles((Node.Handle[])arr);
                }
                catch (IOException ex) {
                    ErrorManager errMgr = ErrorManager.getDefault();
                    errMgr.annotate((Throwable)ex, NbBundle.getBundle((Class)NbSheet.class).getString("EXC_CannotLoadNodes"));
                    errMgr.notify(1, (Throwable)ex);
                    nodes = new Node[]{};
                }
            }
            this.global = in.readBoolean();
            this.setNodes(nodes);
        }
    }

    public Object readResolve() throws ObjectStreamException {
        if (this.global) {
            return NbSheet.getDefault();
        }
        if (this.nodes == null || this.nodes.length <= 0) {
            return null;
        }
        return this;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.global) {
            return new Replacer();
        }
        return super.writeReplace();
    }

    private void updateGlobalListening() {
        if (this.global) {
            TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)TopComponent.getRegistry()));
        }
    }

    static {
        globalPropertiesFormat = null;
        localPropertiesFormat = null;
    }

    private class SheetNodesListener
    extends NodeAdapter
    implements Runnable {
        private HashMap listenerMap;
        private HashMap pListenerMap;

        SheetNodesListener() {
        }

        public void nodeDestroyed(NodeEvent ev) {
            Node destroyedNode = ev.getNode();
            NodeListener listener = (NodeListener)this.listenerMap.get(destroyedNode);
            PropertyChangeListener pListener = (PropertyChangeListener)this.pListenerMap.get(destroyedNode);
            destroyedNode.removeNodeListener(listener);
            destroyedNode.removePropertyChangeListener(pListener);
            this.listenerMap.remove(destroyedNode);
            this.pListenerMap.remove(destroyedNode);
            if (this.listenerMap.isEmpty() && !NbSheet.this.global) {
                NbSheet.this.setCloseOperation(0);
                Mutex.EVENT.readAccess(new Runnable(this){
                    private final /* synthetic */ SheetNodesListener this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        SheetNodesListener.access$000(this.this$1).close();
                    }
                });
            } else {
                NbSheet.this.setNodesWithoutReattaching(this.listenerMap.keySet().toArray(new Node[this.listenerMap.size()]));
            }
        }

        public void attach(Node[] nodes) {
            this.listenerMap = new HashMap(nodes.length * 2);
            this.pListenerMap = new HashMap(nodes.length * 2);
            NodeListener curListener = null;
            PropertyChangeListener pListener = null;
            for (int i = 0; i < nodes.length; ++i) {
                curListener = NodeOp.weakNodeListener((NodeListener)this, (Object)nodes[i]);
                pListener = WeakListeners.propertyChange((PropertyChangeListener)((Object)this), (Object)nodes[i]);
                this.listenerMap.put(nodes[i], curListener);
                this.pListenerMap.put(nodes[i], pListener);
                nodes[i].addNodeListener(curListener);
                nodes[i].addPropertyChangeListener(pListener);
            }
        }

        public void detach() {
            Map.Entry curEntry;
            if (this.listenerMap == null) {
                return;
            }
            Iterator iter = this.listenerMap.entrySet().iterator();
            while (iter.hasNext()) {
                curEntry = iter.next();
                ((Node)curEntry.getKey()).removeNodeListener((NodeListener)curEntry.getValue());
            }
            iter = this.pListenerMap.entrySet().iterator();
            while (iter.hasNext()) {
                curEntry = iter.next();
                ((Node)curEntry.getKey()).removePropertyChangeListener((PropertyChangeListener)curEntry.getValue());
            }
            this.listenerMap = null;
            this.pListenerMap = null;
        }

        public void propertyChange(PropertyChangeEvent pce) {
            if ("displayName".equals(pce.getPropertyName())) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            NbSheet.this.updateTitle();
        }

        static /* synthetic */ NbSheet access$000(SheetNodesListener x0) {
            return x0.NbSheet.this;
        }
    }

    private class Listener
    implements Runnable,
    PropertyChangeListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            if (ev.getPropertyName().equals("activatedNodes")) {
                this.activate();
            }
        }

        public void run() {
            this.activate();
        }

        public void activate() {
            Node[] arr = TopComponent.getRegistry().getActivatedNodes();
            NbSheet.this.setNodes(arr);
        }
    }

    private static final class Replacer
    implements Serializable {
        static final long serialVersionUID = -7897067133215740572L;

        Replacer() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NbSheet.getDefault();
        }
    }
}

