/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.modules;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleManager;
import org.openide.ErrorManager;
import org.openide.modules.Dependency;
import org.openide.modules.InstalledFileLocator;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakSet;

abstract class Util {
    static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.modules");
    private static String[] suffixes = null;
    private static Locale lastLocale = null;
    private static String lastBranding = null;
    private static final Map codeNameParseCache = new HashMap(200);
    static /* synthetic */ Class class$org$netbeans$core$modules$Module;
    static /* synthetic */ Class class$org$openide$modules$ModuleInfo;
    static /* synthetic */ Class class$java$lang$Object;

    private Util() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File makeTempJar(File moduleFile) throws IOException {
        String prefix = moduleFile.getName();
        if (prefix.endsWith(".jar") || prefix.endsWith(".JAR")) {
            prefix = prefix.substring(0, prefix.length() - 4);
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        if (prefix.length() < 3) {
            prefix = prefix + '.';
        }
        String suffix = "-test.jar";
        File physicalModuleFile = File.createTempFile(prefix, suffix);
        physicalModuleFile.deleteOnExit();
        FileInputStream is = new FileInputStream(moduleFile);
        try {
            FileOutputStream os = new FileOutputStream(physicalModuleFile);
            try {
                int i;
                byte[] buf = new byte[4096];
                while ((i = ((InputStream)is).read(buf)) != -1) {
                    ((OutputStream)os).write(buf, 0, i);
                }
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            ((InputStream)is).close();
        }
        err.log("Made " + physicalModuleFile);
        return physicalModuleFile;
    }

    static List findLocaleVariantsOf(File f, boolean includeSuffixes) {
        String ext;
        String name;
        if (!f.isFile()) {
            return Collections.EMPTY_LIST;
        }
        File dir = new File(f.getParentFile(), "locale");
        String logicalDir = null;
        String logicalPath = Util.findLogicalPath(f);
        if (logicalPath != null) {
            int slash = logicalPath.lastIndexOf(47);
            logicalDir = slash != -1 ? logicalPath.substring(0, slash + 1) + "locale/" : "locale/";
        }
        ArrayList<Object> l = new ArrayList<Object>(7);
        String nameExt = f.getName();
        int idx = nameExt.lastIndexOf(46);
        if (idx != -1) {
            name = nameExt.substring(0, idx);
            ext = nameExt.substring(idx);
        } else {
            name = nameExt;
            ext = "";
        }
        String[] suffixes = Util.getLocalizingSuffixesFast();
        for (int i = 0; i < suffixes.length; ++i) {
            String suffix = suffixes[i];
            File v = new File(dir, name + suffix + ext);
            if (v.isFile()) {
                if (includeSuffixes) {
                    l.add(new Object[]{v, suffix});
                    continue;
                }
                l.add(v);
                continue;
            }
            if (logicalDir == null) continue;
            String path = logicalDir + name + suffix + ext;
            v = InstalledFileLocator.getDefault().locate(path, null, false);
            if (v == null) continue;
            if (includeSuffixes) {
                l.add(new Object[]{v, suffix});
                continue;
            }
            l.add(v);
        }
        return l;
    }

    static synchronized String[] getLocalizingSuffixesFast() {
        if (suffixes == null || Locale.getDefault() != lastLocale || NbBundle.getBranding() != lastBranding) {
            ArrayList<String> _suffixes = new ArrayList<String>();
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                _suffixes.add((String)it.next());
            }
            suffixes = _suffixes.toArray(new String[_suffixes.size()]);
            lastLocale = Locale.getDefault();
            lastBranding = NbBundle.getBranding();
        }
        return suffixes;
    }

    private static String findLogicalPath(File f) {
        InstalledFileLocator l = InstalledFileLocator.getDefault();
        String path = f.getName();
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            File probe = l.locate(path, null, false);
            if (f.equals(probe)) {
                return path;
            }
            path = parent.getName() + '/' + path;
        }
        return null;
    }

    static boolean checkJavaDependency(Dependency dep) throws IllegalArgumentException {
        if (dep.getType() == 3) {
            if (dep.getName().equals("Java")) {
                if (dep.getComparison() == 1) {
                    return new SpecificationVersion(dep.getVersion()).compareTo((Object)Dependency.JAVA_SPEC) <= 0;
                }
                return dep.getVersion().equals(Dependency.JAVA_IMPL);
            }
            if (dep.getComparison() == 1) {
                return new SpecificationVersion(dep.getVersion()).compareTo((Object)Dependency.VM_SPEC) <= 0;
            }
            return dep.getVersion().equals(Dependency.VM_IMPL);
        }
        throw new IllegalArgumentException();
    }

    static boolean checkPackageDependency(Dependency dep, ClassLoader cl) throws IllegalArgumentException {
        String sampleName;
        String packageName;
        if (dep.getType() != 2) {
            throw new IllegalArgumentException("Not a package dependency");
        }
        if (!(cl instanceof PackageAccessibleClassLoader) && cl != Util.class.getClassLoader()) {
            throw new IllegalArgumentException("Not a package-accessible classloader: " + cl);
        }
        String name = dep.getName();
        String version = dep.getVersion();
        int comparison = dep.getComparison();
        int idx = name.indexOf(91);
        if (idx == -1) {
            packageName = name;
            sampleName = null;
        } else if (idx == 0) {
            packageName = null;
            sampleName = name.substring(1, name.length() - 1);
        } else {
            packageName = name.substring(0, idx);
            sampleName = name.substring(idx + 1, name.length() - 1);
            if (sampleName.indexOf(46) == -1) {
                sampleName = packageName + '.' + sampleName;
            }
        }
        if (sampleName != null) {
            try {
                cl.loadClass(sampleName);
            }
            catch (ClassNotFoundException cnfe) {
                if (packageName == null) {
                    err.notify(1, (Throwable)cnfe);
                    err.log("Probed class could not be found");
                    return false;
                }
            }
            catch (RuntimeException e) {
                err.notify(1, (Throwable)e);
                err.log("Assuming package " + packageName + " is corrupt");
                return false;
            }
            catch (LinkageError le) {
                err.notify(1, (Throwable)le);
                err.log("Assuming package " + packageName + " is corrupt");
                return false;
            }
        }
        if (packageName != null) {
            Package pkg = cl instanceof PackageAccessibleClassLoader ? ((PackageAccessibleClassLoader)((Object)cl)).getPackageAccessibly(packageName) : Package.getPackage(packageName);
            if (pkg == null) {
                err.log("No package with the name " + packageName + " found");
                return false;
            }
            if (comparison == 3) {
                return true;
            }
            if (comparison == 1) {
                if (pkg.getSpecificationVersion() == null) {
                    err.log("Package " + packageName + " did not give a specification version");
                    return false;
                }
                try {
                    SpecificationVersion versionSpec = new SpecificationVersion(version);
                    SpecificationVersion pkgSpec = new SpecificationVersion(pkg.getSpecificationVersion().trim());
                    if (versionSpec.compareTo((Object)pkgSpec) <= 0) {
                        return true;
                    }
                    err.log("Loaded package " + packageName + " was only of version " + pkgSpec + " but " + versionSpec + " was requested");
                    return false;
                }
                catch (NumberFormatException nfe) {
                    err.notify(1, (Throwable)nfe);
                    err.log("Will not honor a dependency on non-numeric package spec version");
                    return false;
                }
            }
            if (pkg.getImplementationVersion() == null) {
                err.log("Package " + packageName + " had no implementation version");
                return false;
            }
            if (!pkg.getImplementationVersion().trim().equals(version)) {
                err.log("Package " + packageName + " had the wrong impl version: " + pkg.getImplementationVersion());
                return false;
            }
            return true;
        }
        return true;
    }

    static Map moduleDependencies(Collection modules, Map modulesByName, Map _providersOf) {
        Set modulesSet = modules instanceof Set ? (Set)modules : new HashSet(modules);
        HashMap providersOf = new HashMap(_providersOf.size() * 2 + 1);
        Iterator it = _providersOf.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Set providers = (Set)entry.getValue();
            if (providers == null) continue;
            LinkedList availableProviders = new LinkedList(providers);
            availableProviders.retainAll(modulesSet);
            if (availableProviders.isEmpty()) continue;
            providersOf.put(entry.getKey(), availableProviders);
        }
        HashMap m = new HashMap();
        it = modules.iterator();
        while (it.hasNext()) {
            Module m1 = (Module)((Object)it.next());
            LinkedList<Module> l = null;
            Dependency[] dependencies = m1.getDependenciesArray();
            for (int i = 0; i < dependencies.length; ++i) {
                String cnb;
                Module m2;
                Dependency dep = dependencies[i];
                if (dep.getType() == 5) {
                    List providers = (List)providersOf.get(dep.getName());
                    if (providers == null) continue;
                    if (l == null) {
                        l = new LinkedList<Module>();
                    }
                    l.addAll(providers);
                    continue;
                }
                if (dep.getType() != 1 || (m2 = (Module)((Object)modulesByName.get(cnb = (String)Util.parseCodeName(dep.getName())[0]))) == null || !modulesSet.contains((Object)m2)) continue;
                if (l == null) {
                    l = new LinkedList();
                }
                l.add(m2);
            }
            if (l == null) continue;
            m.put(m1, l);
        }
        return m;
    }

    static Set moduleInterdependencies(Module m, boolean reverse, boolean transitive, Set modules, Map modulesByName, Map providersOf) {
        if (reverse) {
            HashSet<Module> s = new HashSet<Module>();
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                Module m2 = (Module)((Object)it.next());
                if (m2 == m || !Util.moduleInterdependencies(m2, false, transitive, modules, modulesByName, providersOf).contains((Object)m)) continue;
                s.add(m2);
            }
            return s;
        }
        HashSet<Module> s = new HashSet<Module>();
        Dependency[] dependencies = m.getDependenciesArray();
        for (int i = 0; i < dependencies.length; ++i) {
            String cnb;
            Module m2;
            Dependency dep = dependencies[i];
            if (dep.getType() == 5) {
                Set providers = (Set)providersOf.get(dep.getName());
                if (providers == null) continue;
                s.addAll(providers);
                continue;
            }
            if (dep.getType() != 1 || (m2 = (Module)((Object)modulesByName.get(cnb = (String)Util.parseCodeName(dep.getName())[0]))) == null) continue;
            s.add(m2);
        }
        s.remove((Object)m);
        if (transitive) {
            HashSet toAdd;
            do {
                toAdd = new HashSet();
                Iterator it = s.iterator();
                while (it.hasNext()) {
                    Module m2 = (Module)((Object)it.next());
                    Set s2 = Util.moduleInterdependencies(m2, false, false, modules, modulesByName, providersOf);
                    s2.remove((Object)m);
                    s2.removeAll(s);
                    toAdd.addAll(s2);
                }
                s.addAll(toAdd);
            } while (!toAdd.isEmpty());
        }
        return s;
    }

    static Comparator displayNameComparator() {
        return new DisplayNameComparator();
    }

    static String findLocalizedMessage(Throwable t, boolean detailOK) {
        String locmsg = t.getLocalizedMessage();
        if (Utilities.compareObjects((Object)locmsg, (Object)t.getMessage())) {
            ErrorManager.Annotation[] anns = err.findAnnotations(t);
            if (anns != null) {
                for (int i = 0; i < anns.length; ++i) {
                    if (anns[i].getLocalizedMessage() == null) continue;
                    return anns[i].getLocalizedMessage();
                }
            }
            if (!detailOK) {
                return null;
            }
        }
        return locmsg;
    }

    static FilenameFilter jarFilter() {
        return new JarFilter();
    }

    static String createPackageName(String name) throws IllegalArgumentException {
        String clExt = ".class";
        if (!name.endsWith(clExt)) {
            clExt = ".ser";
        }
        if (name.endsWith(clExt)) {
            String bareName = name.substring(0, name.length() - clExt.length());
            if (bareName.length() == 0) {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.charAt(0) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.charAt(bareName.length() - 1) == '/') {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            if (bareName.indexOf(46) != -1) {
                throw new IllegalArgumentException("Bad class file name: " + name);
            }
            return bareName.replace('/', '.');
        }
        throw new IllegalArgumentException("Bad class file name: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object[] parseCodeName(String cn) throws NumberFormatException {
        Map map = codeNameParseCache;
        synchronized (map) {
            Object[] r = (Object[])codeNameParseCache.get(cn);
            if (r == null) {
                r = new Object[3];
                int i = cn.lastIndexOf(47);
                if (i == -1) {
                    r[0] = cn;
                } else {
                    r[0] = cn.substring(0, i).intern();
                    String end = cn.substring(i + 1);
                    int j = end.indexOf(45);
                    if (j == -1) {
                        r[1] = new Integer(end);
                    } else {
                        r[1] = new Integer(end.substring(0, j));
                        r[2] = new Integer(end.substring(j + 1));
                    }
                }
                codeNameParseCache.put(cn.intern(), r);
            }
            return r;
        }
    }

    static SpecificationVersion getModuleDep(Set dependencies, String cnb) {
        Iterator it = dependencies.iterator();
        while (it.hasNext()) {
            Dependency d = (Dependency)it.next();
            if (d.getType() != 1 || d.getComparison() != 1) continue;
            try {
                Object[] p = Util.parseCodeName(d.getName());
                if (!p[0].equals(cnb)) continue;
                int rel = (Integer)p[1];
                if (rel == -1) {
                    rel = 0;
                }
                return new SpecificationVersion("" + rel + "." + d.getVersion());
            }
            catch (NumberFormatException nfe) {
                err.notify((Throwable)nfe);
                return null;
            }
        }
        return null;
    }

    static void transitiveClosureModuleDependencies(ModuleManager mgr, Set modules) {
        HashSet<Module> nue = null;
        while (nue == null || !nue.isEmpty()) {
            nue = new HashSet<Module>();
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                Dependency[] deps = m.getDependenciesArray();
                for (int i = 0; i < deps.length; ++i) {
                    Module other;
                    if (deps[i].getType() != 1 || (other = mgr.get((String)Util.parseCodeName(deps[i].getName())[0])) == null || modules.contains((Object)other)) continue;
                    nue.add(other);
                }
            }
            modules.addAll(nue);
        }
    }

    static final class ModuleLookup
    extends Lookup {
        private final HashSet modules = new HashSet(100);
        private final Set results = new WeakSet(10);

        ModuleLookup() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(Module m) {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                this.modules.add(m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(Module m) {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                this.modules.remove((Object)m);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void changed() {
            Set set = this.results;
            synchronized (set) {
                Iterator it = this.results.iterator();
                while (it.hasNext()) {
                    ((ModuleResult)((Object)it.next())).changed();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lookup(Class clazz) {
            if (!(clazz != (class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = Util.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module) && clazz != (class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = Util.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo) && clazz != (class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object) && clazz != null || this.modules.isEmpty())) {
                HashSet hashSet = this.modules;
                synchronized (hashSet) {
                    return this.modules.iterator().next();
                }
            }
            return null;
        }

        public Lookup.Result lookup(Lookup.Template t) {
            Class clazz = t.getType();
            if (clazz == (class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = Util.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module) || clazz == (class$org$openide$modules$ModuleInfo == null ? (class$org$openide$modules$ModuleInfo = Util.class$("org.openide.modules.ModuleInfo")) : class$org$openide$modules$ModuleInfo) || clazz == (class$java$lang$Object == null ? (class$java$lang$Object = Util.class$("java.lang.Object")) : class$java$lang$Object) || clazz == null) {
                return new ModuleResult(t);
            }
            return Lookup.EMPTY.lookup(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            HashSet hashSet = this.modules;
            synchronized (hashSet) {
                return "ModuleLookup" + this.modules;
            }
        }

        private static final class ModuleItem
        extends Lookup.Item {
            public static final String PREFIX = "Module[";
            private final Module item;

            public ModuleItem(Module item) {
                this.item = item;
            }

            public Object getInstance() {
                return this.item;
            }

            public Class getType() {
                return class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = Util.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module;
            }

            public String getId() {
                return PREFIX + this.item.getCodeNameBase();
            }

            public String getDisplayName() {
                return this.item.getDisplayName();
            }
        }

        private final class ModuleResult
        extends Lookup.Result {
            private final Lookup.Template t;
            private final Set listeners = new HashSet(10);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ModuleResult(Lookup.Template t) {
                this.t = t;
                Set set = ModuleLookup.this.results;
                synchronized (set) {
                    ModuleLookup.this.results.add(this);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void addLookupListener(LookupListener l) {
                Set set = this.listeners;
                synchronized (set) {
                    this.listeners.add(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removeLookupListener(LookupListener l) {
                Set set = this.listeners;
                synchronized (set) {
                    this.listeners.remove(l);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed() {
                LookupListener[] _listeners;
                Set set = this.listeners;
                synchronized (set) {
                    if (this.listeners.isEmpty()) {
                        return;
                    }
                    _listeners = this.listeners.toArray(new LookupListener[this.listeners.size()]);
                }
                LookupEvent ev = new LookupEvent((Lookup.Result)this);
                for (int i = 0; i < _listeners.length; ++i) {
                    _listeners[i].resultChanged(ev);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Collection allInstances() {
                HashSet hashSet = ModuleLookup.this.modules;
                synchronized (hashSet) {
                    String id = this.t.getId();
                    Object inst = this.t.getInstance();
                    if (id != null) {
                        Iterator it = ModuleLookup.this.modules.iterator();
                        while (it.hasNext()) {
                            Module m = (Module)((Object)it.next());
                            if (!id.equals("Module[" + m.getCodeNameBase()) || inst != null && inst != m) continue;
                            return Collections.singleton(m);
                        }
                        return Collections.EMPTY_SET;
                    }
                    if (inst != null) {
                        return ModuleLookup.this.modules.contains(inst) ? Collections.singleton(inst) : Collections.EMPTY_SET;
                    }
                    return (Set)ModuleLookup.this.modules.clone();
                }
            }

            public Set allClasses() {
                return Collections.singleton(class$org$netbeans$core$modules$Module == null ? (class$org$netbeans$core$modules$Module = Util.class$("org.netbeans.core.modules.Module")) : class$org$netbeans$core$modules$Module);
            }

            public Collection allItems() {
                Collection insts = this.allInstances();
                ArrayList<ModuleItem> list = new ArrayList<ModuleItem>(Math.max(1, insts.size()));
                Iterator it = insts.iterator();
                while (it.hasNext()) {
                    list.add(new ModuleItem((Module)((Object)it.next())));
                }
                return list;
            }

            public String toString() {
                return "ModuleResult:" + this.t;
            }
        }
    }

    private static final class JarFilter
    implements FilenameFilter {
        JarFilter() {
        }

        public boolean accept(File dir, String name) {
            String n = name.toLowerCase(Locale.US);
            return n.endsWith(".jar");
        }
    }

    private static final class DisplayNameComparator
    implements Comparator {
        DisplayNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            Module m1 = (Module)((Object)o1);
            Module m2 = (Module)((Object)o2);
            return m1.getDisplayName().compareTo(m2.getDisplayName());
        }
    }

    static interface ModuleProvider {
        public Module getModule();
    }

    static interface PackageAccessibleClassLoader {
        public Package getPackageAccessibly(String var1);

        public Package[] getPackagesAccessibly();
    }
}

