/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import org.netbeans.core.NbTopManager;
import org.netbeans.core.modules.DuplicateException;
import org.netbeans.core.modules.Events;
import org.netbeans.core.modules.InvalidException;
import org.netbeans.core.modules.Module;
import org.netbeans.core.modules.ModuleHistory;
import org.netbeans.core.modules.ModuleManager;
import org.netbeans.core.modules.NbProblemDisplayer;
import org.netbeans.core.ui.ModuleEnableDisablePanel;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.WeakListeners;

public final class ModuleBean
implements Runnable,
PropertyChangeListener {
    private static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.core.ui.ModuleBean");
    private final Module module;
    private String codeName;
    private String codeNameBase;
    private String specVers;
    private String implVers;
    private String buildVers;
    private String[] provides;
    private File jar;
    private boolean enabled;
    private boolean reloadable;
    private boolean autoload;
    private boolean eager;
    private boolean problematic;
    private String[] problemDescriptions;
    private String displayName;
    private String shortDescription;
    private String longDescription;
    private String category;
    private String classpath;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$org$netbeans$core$ui$ModuleBean;

    private ModuleBean(Module m) {
        this.module = m;
        this.loadProps();
        this.module.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)((Object)this.module)));
    }

    public Module getModule() {
        return this.module;
    }

    private void loadProps() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("loadProps: module=" + (Object)((Object)this.module));
        if (!this.module.isValid()) {
            err.log("invalid, forget it...");
            return;
        }
        this.codeName = this.module.getCodeName();
        this.codeNameBase = this.module.getCodeNameBase();
        SpecificationVersion sv = this.module.getSpecificationVersion();
        this.specVers = sv == null ? null : sv.toString();
        this.implVers = this.module.getImplementationVersion();
        this.buildVers = this.module.getBuildVersion();
        this.provides = this.module.getProvides();
        this.jar = this.module.getJarFile();
        this.enabled = this.module.isEnabled();
        this.reloadable = this.module.isReloadable();
        this.autoload = this.module.isAutoload();
        this.eager = this.module.isEager();
        Set problems = this.module.getProblems();
        boolean bl = this.problematic = !problems.isEmpty();
        if (this.problematic) {
            this.problemDescriptions = new String[problems.size()];
            Iterator it = problems.iterator();
            int i = 0;
            while (it.hasNext()) {
                this.problemDescriptions[i++] = NbProblemDisplayer.messageForProblem(this.module, it.next());
            }
        } else {
            this.problemDescriptions = null;
        }
        this.displayName = this.module.getDisplayName();
        this.shortDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Short-Description");
        this.longDescription = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Long-Description");
        this.category = (String)this.module.getLocalizedAttribute("OpenIDE-Module-Display-Category");
        this.classpath = NbTopManager.getUninitialized().getModuleSystem().getEffectiveClasspath(this.module);
    }

    public String getCodeName() {
        return this.codeName;
    }

    public String getCodeNameBase() {
        return this.codeNameBase;
    }

    public String getSpecificationVersion() {
        return this.specVers;
    }

    public String getImplementationVersion() {
        return this.implVers;
    }

    public String getBuildVersion() {
        return this.buildVers;
    }

    public String[] getProvides() {
        return this.provides;
    }

    public File getJar() {
        return this.jar;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean e) {
        if (this.enabled == e) {
            return;
        }
        if (this.jar == null || this.autoload || this.eager || this.problematic) {
            throw new IllegalStateException();
        }
        err.log("setEnabled: module=" + (Object)((Object)this.module) + " enabled=" + e);
        this.enabled = e;
        this.supp.firePropertyChange("enabled", null, null);
        Update u = new Update(e ? "enable" : "disable", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public boolean isAutoload() {
        return this.autoload;
    }

    public boolean isEager() {
        return this.eager;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public void setReloadable(boolean r) {
        if (this.reloadable == r) {
            return;
        }
        err.log("setReloadable: module=" + (Object)((Object)this.module) + " reloadable=" + r);
        this.reloadable = r;
        this.supp.firePropertyChange("reloadable", null, null);
        Update u = new Update(r ? "makeReloadable" : "makeUnreloadable", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public void delete() {
        if (this.jar == null) {
            throw new IllegalStateException();
        }
        err.log("delete: module=" + (Object)((Object)this.module));
        Update u = new Update("delete", (Object)this.module);
        AllModulesBean.getDefault().update(u);
    }

    public boolean isProblematic() {
        return this.problematic;
    }

    public String[] getProblemDescriptions() {
        return this.problemDescriptions;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getCategory() {
        return this.category;
    }

    public String getEffectiveClasspath() {
        return this.classpath;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
        this.supp.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("got changes: module=" + (Object)((Object)this.module) + " evt=" + evt);
        if (evt != null && "classLoader".equals(evt.getPropertyName())) {
            err.log("ignoring PROP_CLASS_LOADER");
            return;
        }
        this.loadProps();
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException();
        }
        err.log("firing changes: module=" + (Object)((Object)this.module));
        this.supp.firePropertyChange(null, null, null);
    }

    public boolean equals(Object o) {
        return o instanceof ModuleBean && this.codeNameBase.equals(((ModuleBean)o).codeNameBase);
    }

    public int hashCode() {
        return 0x21FB6CE ^ this.codeNameBase.hashCode();
    }

    public String toString() {
        return "ModuleBean[" + this.codeNameBase + "]";
    }

    private static final class Update {
        public final String command;
        public final Object arg;

        public Update(String command, Object arg) {
            this.command = command;
            this.arg = arg;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Update)) {
                return false;
            }
            Update u = (Update)o;
            return this.command.equals(u.command) && this.arg.equals(u.arg);
        }

        public int hashCode() {
            return this.command.hashCode() ^ this.arg.hashCode();
        }

        public String toString() {
            return "Update[" + this.command + "," + this.arg + "]";
        }
    }

    public static final class AllModulesBean
    implements Runnable,
    PropertyChangeListener,
    Comparator {
        private static AllModulesBean deflt = null;
        private final ModuleManager mgr = NbTopManager.getUninitialized().getModuleSystem().getManager();
        private final Events ev = NbTopManager.getUninitialized().getModuleSystem().getEvents();
        private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
        private ModuleBean[] modules = null;
        private Task recalcTask = null;
        private final List updates = new LinkedList();
        private boolean paused = false;
        private Runnable updater = new Updater();
        public static final int RELATION_DIRECTLY_NEEDS = 0;
        public static final int RELATION_TRANSITIVELY_NEEDS = 1;
        public static final int RELATION_DIRECTLY_NEEDED_BY = 2;
        public static final int RELATION_TRANSITIVELY_NEEDED_BY = 3;
        private static final RequestProcessor RELATION_COMPUTER_RP = new RequestProcessor("RelationComputer");

        public static synchronized AllModulesBean getDefault() {
            if (deflt == null) {
                deflt = new AllModulesBean();
            }
            return deflt;
        }

        private AllModulesBean() {
        }

        public void addPropertyChangeListener(PropertyChangeListener l) {
            this.supp.removePropertyChangeListener(l);
            this.supp.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(PropertyChangeListener l) {
            this.supp.removePropertyChangeListener(l);
        }

        public synchronized ModuleBean[] getModules() {
            err.log("getModules: modules count=" + (this.modules == null ? "null" : String.valueOf(this.modules.length)));
            if (this.modules == null) {
                this.recalcTask = RequestProcessor.getDefault().post((Runnable)new Reader());
                this.modules = new ModuleBean[0];
                return this.modules;
            }
            return this.modules;
        }

        public synchronized Task waitForModules() {
            this.getModules();
            if (this.recalcTask != null) {
                return this.recalcTask;
            }
            return Task.EMPTY;
        }

        public void create(File jar, boolean reloadable) {
            err.log("create: jar=" + jar);
            Update u = new Update(reloadable ? "createReloadable" : "create", jar);
            this.update(u);
        }

        public void run() {
            if (!SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("in event thread, will fire changes");
            this.supp.firePropertyChange(null, null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent evt) {
            if (SwingUtilities.isEventDispatchThread()) {
                throw new IllegalStateException();
            }
            err.log("got changes: evt=" + evt);
            if ("modules".equals(evt.getPropertyName())) {
                HashMap<Module, ModuleBean> modules2Beans = new HashMap<Module, ModuleBean>(this.modules.length * 4 / 3 + 1);
                for (int i = 0; i < this.modules.length; ++i) {
                    modules2Beans.put(this.modules[i].getModule(), this.modules[i]);
                }
                Set modulesSet = this.mgr.getModules();
                ModuleBean[] themodules = new ModuleBean[modulesSet.size()];
                Iterator it = modulesSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Module m = (Module)((Object)it.next());
                    ModuleBean existing = (ModuleBean)modules2Beans.get((Object)m);
                    if (existing == null) {
                        existing = new ModuleBean(m);
                    }
                    themodules[i++] = existing;
                }
                AllModulesBean allModulesBean = this;
                synchronized (allModulesBean) {
                    this.modules = themodules;
                }
                SwingUtilities.invokeLater(this);
            }
        }

        public void pause() {
            err.log("pause");
            this.paused = true;
        }

        public void resume() {
            err.log("resume");
            this.paused = false;
            RequestProcessor.getDefault().post(this.updater);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            err.log("cancel");
            List list = this.updates;
            synchronized (list) {
                this.updates.clear();
            }
            this.paused = false;
            this.supp.firePropertyChange("pending", null, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPending() {
            List list = this.updates;
            synchronized (list) {
                return !this.updates.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void update(Update u) {
            List list = this.updates;
            synchronized (list) {
                boolean runme = this.updates.isEmpty();
                this.updates.add(u);
                err.log("pending updates: " + this.updates);
                if (runme) {
                    RequestProcessor.getDefault().post(this.updater);
                }
            }
            this.supp.firePropertyChange("pending", null, null);
        }

        private void doDelete(Set modules) {
            if (modules.isEmpty()) {
                return;
            }
            err.log("doDelete: " + modules);
            this.doDisable(modules);
            Iterator it = modules.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isFixed()) continue;
                this.mgr.delete(m);
            }
        }

        public int compare(Object o1, Object o2) {
            Module m1 = (Module)((Object)o1);
            Module m2 = (Module)((Object)o2);
            int i = m1.getDisplayName().compareTo(m2.getDisplayName());
            if (i != 0) {
                return i;
            }
            return m1.getCodeNameBase().compareTo(m2.getCodeNameBase());
        }

        private void doDisable(Set modules) {
            if (modules.isEmpty()) {
                return;
            }
            err.log("doDisable: " + modules);
            TreeSet realModules = new TreeSet(this);
            realModules.addAll(modules);
            Iterator it = realModules.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isEnabled() && !m.isAutoload() && !m.isEager() && !m.isFixed()) continue;
                it.remove();
            }
            List toDisable = this.mgr.simulateDisable(realModules);
            it = toDisable.iterator();
            TreeSet<Module> others = new TreeSet<Module>(this);
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                if (m.isAutoload() || m.isEager() || realModules.contains((Object)m)) continue;
                others.add(m);
            }
            if (!others.isEmpty()) {
                ModuleEnableDisablePanel c = new ModuleEnableDisablePanel(false, realModules.toArray(new Module[realModules.size()]), others.toArray(new Module[others.size()]));
                ((Component)c).getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"ACSN_TITLE_disabling"));
                ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"ACSD_TITLE_disabling"));
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_disabling"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                    ModuleBean[] _modules = this.modules;
                    if (_modules != null) {
                        for (int i = 0; i < _modules.length; ++i) {
                            if (!realModules.contains((Object)_modules[i].module)) continue;
                            _modules[i].propertyChange(null);
                        }
                    }
                    return;
                }
                realModules.addAll(others);
            }
            this.mgr.disable(realModules);
        }

        private void doEnable(Set modules) {
            Module m;
            if (modules.isEmpty()) {
                return;
            }
            err.log("doEnable: " + modules);
            TreeSet realModules = new TreeSet(this);
            realModules.addAll(modules);
            Iterator it = realModules.iterator();
            while (it.hasNext()) {
                Module m2 = (Module)((Object)it.next());
                if (!m2.isEnabled() && !m2.isAutoload() && !m2.isEager() && !m2.isFixed() && m2.getProblems().isEmpty()) continue;
                it.remove();
            }
            List toEnable = this.mgr.simulateEnable(realModules);
            it = toEnable.iterator();
            TreeSet<Module> others = new TreeSet<Module>(this);
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (m.isAutoload() || m.isEager() || realModules.contains((Object)m)) continue;
                others.add(m);
            }
            if (!others.isEmpty()) {
                ModuleEnableDisablePanel c = new ModuleEnableDisablePanel(true, realModules.toArray(new Module[realModules.size()]), others.toArray(new Module[others.size()]));
                ((Component)c).getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"ACSN_TITLE_disabling"));
                ((Component)c).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"ACSD_TITLE_disabling"));
                NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)c, NbBundle.getMessage((Class)(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean), (String)"MB_TITLE_enabling"), 2);
                if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) != NotifyDescriptor.OK_OPTION) {
                    ModuleBean[] _modules = this.modules;
                    if (_modules != null) {
                        for (int i = 0; i < _modules.length; ++i) {
                            if (!realModules.contains((Object)_modules[i].module)) continue;
                            _modules[i].propertyChange(null);
                        }
                    }
                    return;
                }
                realModules.addAll(others);
            }
            it = toEnable.iterator();
            while (it.hasNext()) {
                m = (Module)((Object)it.next());
                if (!m.isReloadable()) continue;
                try {
                    this.mgr.reload(m);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                    ModuleBean[] _modules = this.modules;
                    if (_modules != null) {
                        for (int i = 0; i < _modules.length; ++i) {
                            if (!realModules.contains((Object)_modules[i].module)) continue;
                            _modules[i].propertyChange(null);
                        }
                    }
                    return;
                }
            }
            try {
                this.mgr.enable(realModules);
            }
            catch (InvalidException ie) {
                err.notify(1, (Throwable)ie);
                Module bad = ie.getModule();
                if (bad == null) {
                    throw new IllegalStateException();
                }
                this.ev.log("failedInstallNewUnexpected", (Object)bad, ie);
                ModuleBean[] _modules = this.modules;
                if (_modules != null) {
                    for (int i = 0; i < _modules.length; ++i) {
                        if (_modules[i].module != bad) continue;
                        _modules[i].propertyChange(null);
                    }
                }
                realModules.remove((Object)ie.getModule());
                this.doEnable(realModules);
            }
        }

        private void doCreate(Set files, boolean reloadable) {
            if (files.isEmpty()) {
                return;
            }
            err.log("doCreate: " + files + " reloadable=" + reloadable);
            Iterator it = files.iterator();
            while (it.hasNext()) {
                Module nue;
                File jar = (File)it.next();
                try {
                    nue = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), reloadable, false, false);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(256, (Throwable)ioe);
                    continue;
                }
                catch (DuplicateException dupe) {
                    Module old = dupe.getOldModule();
                    if (old.isFixed()) continue;
                    if (old.isEnabled()) {
                        if (old.isAutoload() || old.isEager()) continue;
                        this.doDisable(Collections.singleton(old));
                        if (old.isEnabled()) continue;
                    }
                    this.mgr.delete(old);
                    try {
                        nue = this.mgr.create(jar, new ModuleHistory(jar.getAbsolutePath()), reloadable, false, false);
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(256, (Throwable)ioe);
                        continue;
                    }
                    catch (DuplicateException dupe2) {
                        ErrorManager.getDefault().notify((Throwable)dupe2);
                        continue;
                    }
                }
                if (nue.getProblems().isEmpty()) {
                    this.doEnable(Collections.singleton(nue));
                    continue;
                }
                this.ev.log("failedInstallNew", Collections.singleton(nue));
            }
        }

        public void getRelations(ModuleBean mb, int type, RelationCallback callback) {
            if (type != 0 && type != 1 && type != 2 && type != 3) {
                throw new IllegalArgumentException("bad type: " + type);
            }
            RELATION_COMPUTER_RP.post((Runnable)new RelationComputer(mb.module, type, callback));
        }

        static /* synthetic */ ModuleBean[] access$302(AllModulesBean x0, ModuleBean[] x1) {
            x0.modules = x1;
            return x1;
        }

        private class RelationComputer
        implements Runnable {
            private int stage = 0;
            private final Module m;
            private final int type;
            private final RelationCallback callback;
            private Set result;
            static final /* synthetic */ boolean $assertionsDisabled;

            public RelationComputer(Module m, int type, RelationCallback callback) {
                this.m = m;
                this.type = type;
                this.callback = callback;
            }

            public void run() {
                switch (this.stage) {
                    case 0: {
                        this.stage = 1;
                        AllModulesBean.this.mgr.mutex().readAccess((Runnable)this);
                        break;
                    }
                    case 1: {
                        this.compute();
                        this.stage = 2;
                        SwingUtilities.invokeLater(this);
                        break;
                    }
                    default: {
                        HashSet<ModuleBean> mbresult = new HashSet<ModuleBean>(this.result.size() * 2 + 1);
                        ModuleBean[] _modules = AllModulesBean.this.getModules();
                        for (int i = 0; i < _modules.length; ++i) {
                            if (!this.result.contains((Object)_modules[i].module)) continue;
                            mbresult.add(_modules[i]);
                        }
                        this.callback.result(mbresult);
                    }
                }
            }

            private void compute() {
                switch (this.type) {
                    case 0: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, false, false);
                        break;
                    }
                    case 2: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, true, false);
                        break;
                    }
                    case 1: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, false, true);
                        break;
                    }
                    case 3: {
                        this.result = AllModulesBean.this.mgr.getModuleInterdependencies(this.m, true, true);
                        break;
                    }
                    default: {
                        if (!$assertionsDisabled) {
                            throw new AssertionError(this.type);
                        }
                        break;
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$core$ui$ModuleBean == null ? (class$org$netbeans$core$ui$ModuleBean = ModuleBean.class$("org.netbeans.core.ui.ModuleBean")) : class$org$netbeans$core$ui$ModuleBean).desiredAssertionStatus();
            }
        }

        public static interface RelationCallback {
            public void result(Set var1);
        }

        private class Updater
        implements Runnable {
            private boolean theother = false;

            Updater() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block24: {
                    if (SwingUtilities.isEventDispatchThread()) {
                        throw new IllegalStateException();
                    }
                    if (!this.theother) {
                        err.log("saving all documents...");
                        LifecycleManager.getDefault().saveAll();
                        err.log("will run updates in write mutex...");
                        Updater u = new Updater();
                        u.theother = true;
                        AllModulesBean.this.mgr.mutex().writeAccess((Runnable)u);
                        return;
                    }
                    try {
                        Module m;
                        Iterator it;
                        if (AllModulesBean.this.paused) {
                            err.log("run updates, but paused");
                            return;
                        }
                        HashSet<Object> toEnable = new HashSet<Object>();
                        HashSet<Object> toDisable = new HashSet<Object>();
                        HashSet<Object> toMakeReloadable = new HashSet<Object>();
                        HashSet<Object> toMakeUnreloadable = new HashSet<Object>();
                        HashSet<Object> toDelete = new HashSet<Object>();
                        HashSet<Object> toCreate = new HashSet<Object>();
                        HashSet<Object> toCreateReloable = new HashSet<Object>();
                        List list = AllModulesBean.this.updates;
                        synchronized (list) {
                            if (AllModulesBean.this.updates.isEmpty()) {
                                err.log("run updates, but empty");
                                return;
                            }
                            err.log("run updates: " + AllModulesBean.this.updates);
                            it = new LinkedList(AllModulesBean.this.updates).iterator();
                            AllModulesBean.this.updates.clear();
                        }
                        while (it.hasNext()) {
                            Update u = (Update)it.next();
                            if (u.command.equals("enable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toDisable.remove(u.arg);
                                toEnable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("disable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toEnable.remove(u.arg);
                                toDisable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("makeReloadable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toMakeUnreloadable.remove(u.arg);
                                toMakeReloadable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("makeUnreloadable")) {
                                if (toDelete.contains(u.arg)) {
                                    throw new IllegalStateException();
                                }
                                toMakeReloadable.remove(u.arg);
                                toMakeUnreloadable.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("delete")) {
                                toEnable.remove(u.arg);
                                toDisable.remove(u.arg);
                                toMakeReloadable.remove(u.arg);
                                toMakeUnreloadable.remove(u.arg);
                                toDelete.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("create")) {
                                toCreateReloable.remove(u.arg);
                                toCreate.add(u.arg);
                                continue;
                            }
                            if (u.command.equals("createReloadable")) {
                                toCreate.remove(u.arg);
                                toCreateReloable.add(u.arg);
                                continue;
                            }
                            throw new IllegalStateException();
                        }
                        AllModulesBean.this.doDelete(toDelete);
                        AllModulesBean.this.doDisable(toDisable);
                        it = toMakeReloadable.iterator();
                        while (it.hasNext()) {
                            m = (Module)((Object)it.next());
                            m.setReloadable(true);
                        }
                        it = toMakeUnreloadable.iterator();
                        while (it.hasNext()) {
                            m = (Module)((Object)it.next());
                            m.setReloadable(false);
                        }
                        AllModulesBean.this.doEnable(toEnable);
                        AllModulesBean.this.doCreate(toCreate, false);
                        AllModulesBean.this.doCreate(toCreateReloable, true);
                    }
                    catch (RuntimeException re) {
                        err.notify((Throwable)re);
                        ModuleBean[] _modules = AllModulesBean.this.modules;
                        if (_modules == null) break block24;
                        for (int i = 0; i < _modules.length; ++i) {
                            _modules[i].propertyChange(null);
                        }
                    }
                }
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }

        private class Reader
        implements Runnable {
            private boolean theother = false;

            Reader() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    throw new IllegalStateException();
                }
                if (!this.theother) {
                    err.log("will load modules in read mutex...");
                    Reader r = new Reader();
                    r.theother = true;
                    AllModulesBean.this.mgr.mutex().readAccess((Runnable)r);
                    return;
                }
                err.log("first time, finding module list");
                Set modulesSet = AllModulesBean.this.mgr.getModules();
                ModuleBean[] _modules = new ModuleBean[modulesSet.size()];
                Iterator it = modulesSet.iterator();
                int i = 0;
                while (it.hasNext()) {
                    Module m = (Module)((Object)it.next());
                    _modules[i++] = new ModuleBean(m);
                }
                AllModulesBean allModulesBean = AllModulesBean.this;
                synchronized (allModulesBean) {
                    AllModulesBean.access$302(AllModulesBean.this, _modules);
                    AllModulesBean.this.recalcTask = null;
                }
                AllModulesBean.this.mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)AllModulesBean.this, (Object)AllModulesBean.this.mgr));
                SwingUtilities.invokeLater(AllModulesBean.this);
            }
        }
    }
}

