/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.core.Splash;
import org.netbeans.core.ui.ModuleBean;
import org.netbeans.core.ui.WizardFolder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class SetupWizard
extends WizardFolder
implements PropertyChangeListener {
    private static final String PROP_AUTO_WIZARD_STYLE = "WizardPanel_autoWizardStyle";
    private static final String PROP_CONTENT_DISPLAYED = "WizardPanel_contentDisplayed";
    private static final String PROP_CONTENT_NUMBERED = "WizardPanel_contentNumbered";
    private static final String PROP_CONTENT_SELECTED_INDEX = "WizardPanel_contentSelectedIndex";
    private static final String PROP_HELP_DISPLAYED = "WizardPanel_helpDisplayed";
    private static final String PROP_CONTENT_DATA = "WizardPanel_contentData";
    private static final String DATE_SHOWN_PROPERTY = "dateShown";
    private static final String MODULE_ATTR = "module";
    private static final String HIDDEN_ATTR = "hidden";
    private static final String BASIC_ATTR = "basic";
    private boolean showAll = false;
    private boolean lock = false;
    private HashMap subIterators;
    private WizardFolder.CompoundIterator cit;
    private WizardDescriptor wd;
    private WizardDescriptor.Iterator separator;
    private HashSet initializedPanels = new HashSet();

    public SetupWizard(DataFolder df) {
        super(df);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance(InstanceCookie[] cookies) throws IOException, ClassNotFoundException {
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            if (this.lock) {
                return this;
            }
            LinkedList<Object> basic = new LinkedList<Object>();
            LinkedList<WizardDescriptor.Iterator> advanced = new LinkedList<WizardDescriptor.Iterator>();
            if (this.subIterators == null) {
                this.subIterators = new HashMap();
            }
            for (int i = 0; i < cookies.length; ++i) {
                WizardDescriptor.Iterator subIter = (WizardDescriptor.Iterator)this.subIterators.get(cookies[i]);
                Object[] obj = (Object[])cookies[i].instanceCreate();
                if (subIter == null) {
                    if (obj[0] instanceof WizardDescriptor.Iterator) {
                        subIter = (WizardDescriptor.Iterator)obj[0];
                    } else if (obj[0] instanceof WizardDescriptor.Panel) {
                        WizardDescriptor.Panel p = (WizardDescriptor.Panel)obj[0];
                        subIter = new WizardFolder.PanelWrapper(p, cookies[i].instanceName());
                    } else {
                        if (!(obj[0] instanceof Component)) continue;
                        Component c = (Component)obj[0];
                        subIter = new WizardFolder.PanelWrapper(c, cookies[i].instanceName());
                    }
                }
                this.subIterators.put(cookies[i], subIter);
                if (Boolean.TRUE.equals(((DataObject)obj[1]).getPrimaryFile().getAttribute(BASIC_ATTR))) {
                    basic.add(subIter);
                    continue;
                }
                advanced.add(subIter);
            }
            if (!(this.showAll || advanced.isEmpty() || basic.isEmpty())) {
                basic.add(this.getSeparatorPanel());
            }
            basic.addAll(advanced);
            if (this.wd == null) {
                if (basic.isEmpty()) {
                    this.cit = null;
                } else {
                    this.setIterator(new InitializedIterator(basic));
                }
            } else {
                this.cit.setIterators(basic);
            }
        }
        return this;
    }

    protected InstanceCookie acceptDataObject(DataObject dob) {
        InstanceCookie cookie = super.acceptDataObject(dob);
        if (cookie != null) {
            FileObject fo = dob.getPrimaryFile();
            Date lastVisit = (Date)fo.getAttribute(DATE_SHOWN_PROPERTY);
            String moduleName = (String)fo.getAttribute(MODULE_ATTR);
            Boolean hidden = (Boolean)fo.getAttribute(HIDDEN_ATTR);
            if (Boolean.TRUE.equals(hidden) || lastVisit != null && !this.showAll || this.skipping(moduleName)) {
                return null;
            }
        }
        return cookie;
    }

    private boolean skipping(String moduleName) {
        if (moduleName == null) {
            return false;
        }
        ModuleBean[] modules = SetupWizard.getAllModules().getModules();
        for (int i = 0; i < modules.length; ++i) {
            if (!modules[i].getCodeNameBase().equals(moduleName)) continue;
            return !modules[i].isEnabled();
        }
        return false;
    }

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return new Object[]{cookie.instanceCreate(), obj};
    }

    protected void markPanelsAsSeen() {
        Date now = new Date();
        FileObject[] fo = this.folder.getPrimaryFile().getChildren();
        for (int i = 0; i < fo.length; ++i) {
            try {
                fo[i].setAttribute(DATE_SHOWN_PROPERTY, (Object)now);
                continue;
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
        }
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
        this.run();
    }

    private void setIterator(WizardFolder.CompoundIterator it) {
        if (this.cit != null) {
            this.cit.removePropertyChangeListener(this);
        }
        this.cit = it;
        if (this.cit != null) {
            this.cit.addPropertyChangeListener(this);
        }
    }

    public WizardDescriptor.Iterator getIterator() {
        return this.cit;
    }

    public void show() {
        this.show(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void show(Splash.SplashOutput splash) {
        if (this.cit == null) {
            return;
        }
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            this.lock = true;
        }
        if (splash != null) {
            Splash.hideSplash(splash);
        }
        this.wd = new InitializedWizardDescriptor(this.cit);
        this.wd.putProperty(PROP_AUTO_WIZARD_STYLE, (Object)Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_DISPLAYED, (Object)Boolean.TRUE);
        this.wd.putProperty(PROP_CONTENT_NUMBERED, (Object)Boolean.TRUE);
        this.wd.setTitleFormat(new MessageFormat("{0}"));
        this.wd.setTitle(NbBundle.getBundle((Class)WizardFolder.class).getString("CTL_SetupWizardTitle"));
        this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
        this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.cit.getContentSelectedIndex()));
        this.wd.putProperty(PROP_HELP_DISPLAYED, (Object)Boolean.FALSE);
        SetupWizard.getAllModules().addPropertyChangeListener(this);
        ModuleBean[] modules = SetupWizard.getAllModules().getModules();
        for (int i = 0; i < modules.length; ++i) {
            modules[i].addPropertyChangeListener(this);
        }
        Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wd);
        d.show();
        d.dispose();
        SetupWizard.getAllModules().removePropertyChangeListener(this);
        modules = SetupWizard.getAllModules().getModules();
        for (int i = 0; i < modules.length; ++i) {
            modules[i].removePropertyChangeListener(this);
        }
        this.cit.removePropertyChangeListener(this);
        if (this.wd.getValue() != WizardDescriptor.CANCEL_OPTION) {
            if (this.wd.getValue() != WizardDescriptor.CLOSED_OPTION) {
                this.markPanelsAsSeen();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAdvancedWizard() {
        this.lock = false;
        this.run();
        SetupWizard setupWizard = this;
        synchronized (setupWizard) {
            this.lock = true;
        }
        this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
    }

    public void propertyChange(PropertyChangeEvent ev) {
        if (PROP_CONTENT_SELECTED_INDEX.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_SELECTED_INDEX, (Object)new Integer(this.cit.getContentSelectedIndex()));
        } else if (PROP_CONTENT_DATA.equals(ev.getPropertyName())) {
            this.wd.putProperty(PROP_CONTENT_DATA, (Object)this.cit.getContentData());
        } else if (SetupWizard.getAllModules() == ev.getSource() || "enabled".equals(ev.getPropertyName())) {
            this.updateAdvancedWizard();
        }
    }

    private WizardDescriptor.Iterator getSeparatorPanel() {
        if (this.separator == null) {
            JPanel panel = new JPanel(new BorderLayout());
            JLabel label = new JLabel(NbBundle.getBundle((Class)SetupWizard.class).getString("LBL_SeparatorPanelInstr"));
            panel.add((Component)label, "North");
            panel.setName(NbBundle.getBundle((Class)SetupWizard.class).getString("LBL_SeparatorPanelName"));
            panel.getAccessibleContext().setAccessibleDescription(label.getText());
            this.separator = new WizardFolder.PanelWrapper(panel, "");
        }
        return this.separator;
    }

    public static void showSetupWizard(boolean showAll) {
        SetupWizard.showSetupWizard(showAll, null);
    }

    public static void showSetupWizard(boolean showAll, Splash.SplashOutput splash) {
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource("Wizards/Setup");
        if (fo != null) {
            SetupWizard f = new SetupWizard(DataFolder.findFolder((FileObject)fo));
            f.setShowAll(showAll);
            f.show(splash);
        }
    }

    private static ModuleBean.AllModulesBean getAllModules() {
        return ModuleBean.AllModulesBean.getDefault();
    }

    private class InitializedWizardDescriptor
    extends WizardDescriptor {
        public InitializedWizardDescriptor(WizardDescriptor.Iterator iter) {
            super(iter);
        }

        protected void updateState() {
            super.updateState();
            SetupWizard.this.initializedPanels.add(SetupWizard.this.cit.current());
        }
    }

    private class InitializedIterator
    extends WizardFolder.CompoundIterator {
        private static final String PROP_INITIALIZE = "initializePanel";

        public InitializedIterator(LinkedList iterators) {
            super(iterators);
        }

        public WizardDescriptor.Panel current() {
            WizardDescriptor.Panel current = super.current();
            SetupWizard.this.wd.putProperty(PROP_INITIALIZE, (Object)(SetupWizard.this.initializedPanels.contains(current) ? Boolean.FALSE : Boolean.TRUE));
            return current;
        }
    }
}

