/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.netbeans.core.IDESettings;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebBrowserPanel
extends JPanel
implements WizardDescriptor.FinishPanel,
PropertyChangeListener {
    ResourceBundle bundle = NbBundle.getBundle((String)"org/netbeans/core/ui/Bundle");
    private JLabel browserLabel;
    private JComboBox browserComboBox;
    private JTextArea helpTextArea;
    private ArrayList changeListeners = new ArrayList(1);
    private PropertyEditor editor;

    public WebBrowserPanel() {
        this.initComponents();
        this.browserLabel.setDisplayedMnemonic(this.bundle.getString("CTL_BrowserLabel_mnemonic").charAt(0));
        this.browserLabel.setLabelFor(this.browserComboBox);
        this.helpTextArea.setFont(UIManager.getFont("Label.font"));
        this.helpTextArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.setName(this.bundle.getString("LBL_WebBrowserPanelName"));
        try {
            IDESettings settings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
            this.editor = PropertyEditorManager.findEditor(HtmlBrowser.Factory.class);
            this.editor.setValue(settings.getWWWBrowser());
            String[] tags = this.editor.getTags();
            for (int j = 0; j < tags.length; ++j) {
                this.browserComboBox.insertItemAt(tags[j], j);
            }
            this.browserComboBox.setSelectedItem(this.editor.getAsText());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    private void initComponents() {
        this.browserLabel = new JLabel();
        this.browserComboBox = new JComboBox();
        this.helpTextArea = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.browserLabel.setText(this.bundle.getString("CTL_BrowserLabel"));
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.browserLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 1;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.browserComboBox, gridBagConstraints1);
        this.helpTextArea.setWrapStyleWord(true);
        this.helpTextArea.setLineWrap(true);
        this.helpTextArea.setEditable(false);
        this.helpTextArea.setText(this.bundle.getString("CTL_HelpTextArea"));
        this.helpTextArea.setEnabled(false);
        this.helpTextArea.setOpaque(false);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.insets = new Insets(17, 0, 0, 0);
        gridBagConstraints1.anchor = 18;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.helpTextArea, gridBagConstraints1);
    }

    public Component getComponent() {
        return this;
    }

    public HelpCtx getHelp() {
        return null;
    }

    public boolean isValid() {
        return true;
    }

    public void storeSettings(Object obj) {
    }

    public void readSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            ((WizardDescriptor)settings).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (!this.changeListeners.contains(l)) {
            this.changeListeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeListeners.remove(l);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof WizardDescriptor && "value".equals(evt.getPropertyName())) {
            WizardDescriptor wd = (WizardDescriptor)evt.getSource();
            if (wd.getValue() == WizardDescriptor.FINISH_OPTION) {
                wd.removePropertyChangeListener((PropertyChangeListener)this);
                if (this.editor != null) {
                    try {
                        Object o = this.browserComboBox.getSelectedItem();
                        if (o instanceof String && o != null) {
                            IDESettings settings = (IDESettings)IDESettings.findObject((Class)IDESettings.class, (boolean)true);
                            this.editor.setAsText((String)o);
                            settings.setWWWBrowser((HtmlBrowser.Factory)this.editor.getValue());
                        }
                    }
                    catch (Exception ex) {
                        ErrorManager.getDefault().notify((Throwable)ex);
                    }
                }
            }
        }
    }
}

