/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.xml;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.loaders.InstanceDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.w3c.dom.DocumentType;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public final class FileEntityResolver
extends EntityCatalog
implements Environment.Provider {
    private static final String ENTITY_PREFIX = "/xml/entities";
    private static final String LOOKUP_PREFIX = "/xml/lookups";
    private static Method method;
    private static final StopSaxException STOP;

    public InputSource resolveEntity(String publicID, String systemID) throws IOException, SAXException {
        if (publicID == null) {
            return null;
        }
        String id = FileEntityResolver.convertPublicId(publicID);
        StringBuffer sb = new StringBuffer(200);
        sb.append(ENTITY_PREFIX);
        sb.append(id);
        FileObject fo = Repository.getDefault().getDefaultFileSystem().findResource(sb.toString());
        if (fo != null) {
            InputSource in = new InputSource(fo.getInputStream());
            try {
                Object myPublicID = fo.getAttribute("hint.originalPublicID");
                if (myPublicID instanceof String) {
                    in.setPublicId((String)myPublicID);
                }
                URL url = fo.getURL();
                in.setSystemId(url.toString());
            }
            catch (IOException ex) {
                // empty catch block
            }
            return in;
        }
        return null;
    }

    public Lookup getEnvironment(DataObject obj) {
        if (obj instanceof XMLDataObject) {
            XMLDataObject xml = (XMLDataObject)obj;
            String id = null;
            try {
                DocumentType domDTD = xml.getDocument().getDoctype();
                if (domDTD != null) {
                    id = domDTD.getPublicId();
                }
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
            catch (SAXException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
            if (id == null) {
                return null;
            }
            id = FileEntityResolver.convertPublicId(id);
            return new Lkp(id, (DataObject)xml);
        }
        if (obj instanceof InstanceDataObject) {
            return this.getEnvForIDO((InstanceDataObject)obj);
        }
        return null;
    }

    private Lookup getEnvForIDO(InstanceDataObject ido) {
        DTDParser parser = new DTDParser(ido.getPrimaryFile());
        parser.parse();
        String id = parser.getPublicId();
        if (id == null) {
            return null;
        }
        id = FileEntityResolver.convertPublicId(id);
        return new Lkp(id, (DataObject)ido);
    }

    private static Lookup findLookup(DataObject obj, DataObject source) {
        if (source == null) {
            return null;
        }
        try {
            InstanceCookie cookie = (InstanceCookie)source.getCookie(InstanceCookie.class);
            if (cookie != null) {
                Object inst = cookie.instanceCreate();
                if (inst instanceof Environment.Provider) {
                    return ((Environment.Provider)inst).getEnvironment(obj);
                }
                if (!(obj instanceof XMLDataObject)) {
                    return null;
                }
                if (inst instanceof XMLDataObject.Processor) {
                    XMLDataObject.Info info = new XMLDataObject.Info();
                    info.addProcessorClass(inst.getClass());
                    inst = info;
                }
                if (inst instanceof XMLDataObject.Info) {
                    return FileEntityResolver.createInfoLookup((XMLDataObject)obj, (XMLDataObject.Info)inst);
                }
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
        return null;
    }

    private static Lookup createInfoLookup(XMLDataObject obj, XMLDataObject.Info info) {
        if (method == null) {
            try {
                method = XMLDataObject.class.getDeclaredMethod("createInfoLookup", XMLDataObject.class, XMLDataObject.Info.class);
                method.setAccessible(true);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
                return null;
            }
        }
        try {
            return (Lookup)method.invoke(null, obj, info);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String convertPublicId(String publicID) {
        char[] arr = publicID.toCharArray();
        int numberofslashes = 0;
        int state = 0;
        int write = 0;
        int i = 0;
        while (i < arr.length) {
            block9: {
                int ch = arr[i];
                switch (state) {
                    case 0: {
                        if (ch == 43 || ch == 45 || ch == 73 || ch == 83 || ch == 79) break block9;
                        state = 1;
                    }
                    case 1: {
                        if (ch != 47) break;
                        state = 2;
                        if (++numberofslashes == 3) {
                            return new String(arr, 0, write);
                        }
                        arr[write++] = 47;
                    }
                    {
                        break block9;
                    }
                    case 2: {
                        if (ch == 47) break block9;
                        state = 1;
                    }
                }
                arr[write++] = ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch >= 48 && ch <= 57 ? ch : 95;
            }
            ++i;
        }
        return new String(arr, 0, write);
    }

    private static FileObject findObject(String id, FileObject[] last) {
        StringBuffer sb = new StringBuffer(200);
        sb.append(LOOKUP_PREFIX);
        sb.append(id);
        int len = sb.length();
        sb.append(".instance");
        FileObject root = Repository.getDefault().getDefaultFileSystem().getRoot();
        String toSearch1 = sb.toString();
        int indx = FileEntityResolver.searchFolder(root, toSearch1, last);
        if (indx == -1) {
            return null;
        }
        FileObject fo = last[0].getFileObject(toSearch1.substring(indx));
        if (fo == null) {
            sb.setLength(len);
            sb.append(".xml");
            fo = last[0].getFileObject(sb.toString().substring(indx));
        }
        return fo;
    }

    private static int searchFolder(FileObject fo, String resourceName, FileObject[] last) {
        int pos = 0;
        while (true) {
            int next;
            if ((next = resourceName.indexOf(47, pos)) == -1) {
                last[0] = fo;
                return pos;
            }
            if (next == pos) {
                ++pos;
                continue;
            }
            FileObject nf = fo.getFileObject(resourceName.substring(pos, next));
            if (nf == null) {
                last[0] = fo;
                return -1;
            }
            pos = next + 1;
            fo = nf;
        }
    }

    static {
        STOP = new StopSaxException();
    }

    private static final class Lkp
    extends ProxyLookup
    implements PropertyChangeListener,
    FileChangeListener {
        private String id;
        private DataObject xml;
        private FileObject folder;
        private DataObject obj;

        public Lkp(String id, DataObject xml) {
            super(new Lookup[0]);
            this.id = id;
            this.xml = xml;
        }

        protected void beforeLookup(Lookup.Template t) {
            if (this.folder == null && this.obj == null) {
                this.update();
            }
        }

        private void update() {
            FileObject[] last = new FileObject[1];
            FileObject fo = FileEntityResolver.findObject(this.id, last);
            DataObject o = null;
            if (fo != null) {
                try {
                    o = DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                }
            }
            if (o == this.obj) {
                Lookup l = FileEntityResolver.findLookup(this.xml, o);
                if (o != null && l != null) {
                    this.setLookups(new Lookup[]{l});
                    return;
                }
            } else {
                this.obj = o;
                Lookup l = FileEntityResolver.findLookup(this.xml, o);
                if (o != null && l != null) {
                    o.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)o));
                    this.setLookups(new Lookup[]{l});
                    return;
                }
            }
            this.setLookups(new Lookup[0]);
            if (this.folder != last[0]) {
                this.folder = last[0];
                last[0].addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)last[0]));
            }
        }

        public void fileDeleted(FileEvent fe) {
            this.update();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.update();
        }

        public void fileDataCreated(FileEvent fe) {
            this.update();
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            String name = ev.getPropertyName();
            if ("cookie" == name || "name" == name || "valid" == name || "primaryFile" == name) {
                this.update();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.update();
        }

        public void fileChanged(FileEvent fe) {
        }
    }

    private static class DTDParser
    extends DefaultHandler
    implements LexicalHandler {
        private String publicId = null;
        private FileObject src;

        public DTDParser(FileObject src) {
            this.src = src;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public void parse() {
            try {
                XMLReader reader = XMLUtil.createXMLReader((boolean)false, (boolean)false);
                reader.setContentHandler(this);
                reader.setEntityResolver(this);
                InputSource is = new InputSource(this.src.getURL().toExternalForm());
                is.setByteStream(new BufferedInputStream(this.src.getInputStream()));
                try {
                    reader.setFeature("http://xml.org/sax/features/validation", false);
                }
                catch (SAXException sex) {
                    ErrorManager.getDefault().log(1, "Warning: XML parser does not support validation feature.");
                }
                try {
                    reader.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                }
                catch (SAXException sex) {
                    ErrorManager.getDefault().log(4096, "Warning: XML parser does not support lexical-handler feature.");
                }
                reader.parse(is);
            }
            catch (StopSaxException ex) {
            }
            catch (Exception ex) {
                if (ex.getClass().getName().equals("org.openide.util.lookup.AbstractLookup$ISE")) {
                    throw (IllegalStateException)ex;
                }
                try {
                    if (this.src.getFileSystem() == Repository.getDefault().getDefaultFileSystem()) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        }

        public InputSource resolveEntity(String publicId, String systemID) {
            InputSource ret = new InputSource(new StringReader(""));
            ret.setSystemId("StringReader");
            return ret;
        }

        public void endDTD() throws SAXException {
            throw STOP;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.publicId = publicId;
        }

        public void startEntity(String str) throws SAXException {
        }

        public void endEntity(String str) throws SAXException {
        }

        public void comment(char[] values, int param, int param2) throws SAXException {
        }

        public void startCDATA() throws SAXException {
        }

        public void endCDATA() throws SAXException {
        }
    }

    private static class StopSaxException
    extends SAXException {
        public StopSaxException() {
            super("STOP");
        }
    }
}

