/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.cim;

import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMFlavor;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.MOFFormatter;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    static final long serialVersionUID = 200L;
    private CIMValue value;
    private Vector flavors = new Vector();

    public CIMValue getValue() {
        return this.value;
    }

    public void setValue(CIMValue value) {
        this.value = value;
    }

    public void setDefaults(CIMQualifierType qualifierType) {
        if (!this.hasValue() && qualifierType.hasDefaultValue()) {
            CIMValue cv = qualifierType.getDefaultValue();
            this.value = cv.getType() == null && qualifierType.getType() != null ? new CIMValue(cv.getValue(), qualifierType.getType()) : cv;
        }
        if (this.flavors == null || this.flavors.size() == 0) {
            this.flavors = (Vector)qualifierType.getFlavor().clone();
        }
    }

    public boolean hasFlavor(CIMFlavor flavor) {
        if (this.flavors == null) {
            return false;
        }
        Enumeration e = this.flavors.elements();
        while (e.hasMoreElements()) {
            if (!((CIMFlavor)e.nextElement()).equals(flavor)) continue;
            return true;
        }
        return false;
    }

    public void addFlavor(CIMFlavor newFlavor) {
        if (!this.hasFlavor(newFlavor)) {
            this.flavors.addElement(newFlavor);
        }
    }

    public Vector getFlavor() {
        return this.flavors;
    }

    public CIMQualifier() {
        this("");
    }

    public CIMQualifier(String qualifierName) {
        super(qualifierName);
    }

    public CIMQualifier(String qualifierName, CIMQualifierType qualifierType) {
        this(qualifierName);
        this.setDefaults(qualifierType);
    }

    public String toString() {
        return this.toMOF();
    }

    public String toMOF() {
        MOFFormatter mf = new MOFFormatter();
        return mf.toString(this);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifier)) {
            return false;
        }
        return super.equals(o);
    }

    public synchronized Object clone() {
        CIMQualifier qe = new CIMQualifier();
        qe.name = this.name;
        qe.value = this.value;
        qe.flavors = (Vector)this.flavors.clone();
        return qe;
    }
}

