/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http;

import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.wbem.cimxml.CIMXml;
import javax.wbem.cimxml.CIMXmlFactory;
import javax.wbem.client.CIMEvent;
import javax.wbem.client.CIMListener;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.HttpServerRequestHandler;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class HttpEventRequestHandler
extends HttpServerRequestHandler {
    CIMListener clientListener;
    private CIMXml xmlInst;
    private List events = new ArrayList();

    public HttpEventRequestHandler(CIMListener clientListener) {
        this.clientListener = clientListener;
        this.xmlInst = CIMXmlFactory.getCIMXmlImpl();
        EventProcessor ep = new EventProcessor();
        ep.setDaemon(true);
        ep.start();
    }

    public boolean checkAuthentication(InboundRequest request) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(InboundRequest request) {
        try {
            Document xmlDoc = this.getXmlDocument(request);
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            String str = request.getHeaderField("CIMExportMethod");
            if (str == null || !str.equals("ExportIndication")) {
                this.do501Error(out);
                return;
            }
            List list = this.events;
            synchronized (list) {
                this.events.add(new CIMEvent(this.xmlInst.getCIMInstance(xmlDoc)));
                this.events.notify();
            }
            xmlDoc = this.xmlInst.getXMLResponse(null, xmlDoc, null);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            try {
                String systemId;
                Transformer transformer = tFactory.newTransformer();
                DocumentType docType = xmlDoc.getDoctype();
                if (docType != null && (systemId = docType.getSystemId()) != null) {
                    String systemValue = new File(systemId).getName();
                    transformer.setOutputProperty("doctype-system", systemValue);
                }
                DOMSource source = new DOMSource(xmlDoc);
                StreamResult result = new StreamResult(out);
                transformer.transform(source, result);
            }
            catch (TransformerConfigurationException e) {
                Debug.trace3("HttpEventRequestHandler", e);
            }
            catch (TransformerException e) {
                Debug.trace3("HttpEventRequestHandler", e);
            }
        }
        catch (SAXException e) {
            DataOutputStream out = new DataOutputStream(request.getResponseOutputStream());
            Exception x = e.getException();
            String message = "Parse Error with Request:\n";
            if (x == null) {
                x = e;
            }
            if (e instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)e;
                message = message + "** URI: " + spe.getSystemId() + "\n";
                message = message + "** Line: " + spe.getLineNumber() + "\n";
            }
            this.do500Error(out, "XML Parsing error: <b>" + message + "</b>");
            Debug.trace3(message, e);
        }
        catch (IOException e) {
            Debug.trace3("HttpEventRequestHandler", e);
        }
        catch (ParserConfigurationException e) {
            Debug.trace3("HttpEventRequestHandler", e);
        }
    }

    public void addResponseHeaderFields(InboundRequest request) {
        request.setRespondHeaderField("CIMOperation", "ExportMethodResponse");
    }

    private class EventProcessor
    extends Thread {
        private EventProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                List list = HttpEventRequestHandler.this.events;
                synchronized (list) {
                    while (HttpEventRequestHandler.this.events.isEmpty()) {
                        try {
                            HttpEventRequestHandler.this.events.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    HttpEventRequestHandler.this.clientListener.indicationOccured((CIMEvent)HttpEventRequestHandler.this.events.remove(0));
                }
            }
        }
    }
}

